/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.util.PatternUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class PatternPackageReferenceSet
extends PackageReferenceSet {
    public PatternPackageReferenceSet(String packageName, PsiElement element, int startInElement) {
        super(packageName, element, startInElement);
    }

    @Override
    public Collection<PsiPackage> resolvePackageName(@Nullable PsiPackage context, String packageName) {
        if (context == null) {
            return Collections.emptySet();
        }
        if (packageName.contains("*")) {
            final Pattern pattern = PatternUtil.fromMask((String)packageName);
            final HashSet<PsiPackage> packages = new HashSet<PsiPackage>();
            PatternPackageReferenceSet.processSubPackages(context, new Processor<PsiPackage>(){

                public boolean process(PsiPackage psiPackage) {
                    String name = psiPackage.getName();
                    if (name != null && pattern.matcher(name).matches()) {
                        packages.add(psiPackage);
                    }
                    return true;
                }
            });
            return packages;
        }
        return super.resolvePackageName(context, packageName);
    }

    protected static boolean processSubPackages(PsiPackage pkg, Processor<PsiPackage> processor) {
        if (!processor.process((Object)pkg)) {
            return false;
        }
        for (PsiPackage aPackage : pkg.getSubPackages()) {
            if (PatternPackageReferenceSet.processSubPackages(aPackage, processor)) continue;
            return false;
        }
        return true;
    }
}

