/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConflictsDialog
extends DialogWrapper {
    private static final int SHOW_CONFLICTS_EXIT_CODE = 4;
    private final String[] myConflictDescriptions;
    private MultiMap<PsiElement, String> myElementConflictDescription;
    private final Project myProject;
    private Runnable myDoRefactoringRunnable;
    private final boolean myCanShowConflictsInView;
    private String myCommandName;

    public ConflictsDialog(@NotNull Project project, @NotNull MultiMap<PsiElement, String> conflictDescriptions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/ui/ConflictsDialog", "<init>"));
        }
        if (conflictDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictDescriptions", "com/intellij/refactoring/ui/ConflictsDialog", "<init>"));
        }
        this(project, conflictDescriptions, null, true, true);
    }

    public ConflictsDialog(@NotNull Project project, @NotNull MultiMap<PsiElement, String> conflictDescriptions, @Nullable Runnable doRefactoringRunnable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/ui/ConflictsDialog", "<init>"));
        }
        if (conflictDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictDescriptions", "com/intellij/refactoring/ui/ConflictsDialog", "<init>"));
        }
        this(project, conflictDescriptions, doRefactoringRunnable, true, true);
    }

    public ConflictsDialog(@NotNull Project project, @NotNull MultiMap<PsiElement, String> conflictDescriptions, @Nullable Runnable doRefactoringRunnable, boolean alwaysShowOkButton, boolean canShowConflictsInView) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/ui/ConflictsDialog", "<init>"));
        }
        if (conflictDescriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflictDescriptions", "com/intellij/refactoring/ui/ConflictsDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.myDoRefactoringRunnable = doRefactoringRunnable;
        this.myCanShowConflictsInView = canShowConflictsInView;
        LinkedHashSet<String> conflicts = new LinkedHashSet<String>();
        for (String conflict : conflictDescriptions.values()) {
            conflicts.add(conflict);
        }
        this.myConflictDescriptions = ArrayUtil.toStringArray(conflicts);
        this.myElementConflictDescription = conflictDescriptions;
        this.setTitle(RefactoringBundle.message((String)"problems.detected.title"));
        this.setOKButtonText(RefactoringBundle.message((String)"continue.button"));
        this.setOKActionEnabled(alwaysShowOkButton || this.getDoRefactoringRunnable(null) != null);
        this.init();
    }

    @Deprecated
    public ConflictsDialog(Project project, Collection<String> conflictDescriptions) {
        this(project, ArrayUtil.toStringArray(conflictDescriptions));
    }

    @Deprecated
    public ConflictsDialog(Project project, String ... conflictDescriptions) {
        super(project, true);
        this.myProject = project;
        this.myConflictDescriptions = conflictDescriptions;
        this.myCanShowConflictsInView = true;
        this.setTitle(RefactoringBundle.message((String)"problems.detected.title"));
        this.setOKButtonText(RefactoringBundle.message((String)"continue.button"));
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        boolean showUsagesButton;
        Action okAction = this.getOKAction();
        boolean bl = showUsagesButton = this.myElementConflictDescription != null && this.myCanShowConflictsInView;
        if (showUsagesButton || !okAction.isEnabled()) {
            okAction.putValue("DefaultAction", null);
        }
        if (!showUsagesButton) {
            Action[] actionArray = new Action[]{okAction, new CancelAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{okAction, new MyShowConflictsInUsageViewAction(), new CancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog", "createActions"));
        }
        return actionArray;
    }

    public boolean isShowConflicts() {
        return this.getExitCode() == 4;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 2));
        panel.add((Component)new JLabel(RefactoringBundle.message((String)"the.following.problems.were.found")), "North");
        StringBuilder buf = new StringBuilder();
        for (String description : this.myConflictDescriptions) {
            buf.append(description);
            buf.append("<br><br>");
        }
        JEditorPane messagePane = new JEditorPane("text/html", buf.toString());
        messagePane.setEditable(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)messagePane, (int)22, (int)30);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        panel.add((Component)scrollPane, "Center");
        if (this.getOKAction().isEnabled()) {
            panel.add((Component)new JLabel(RefactoringBundle.message((String)"do.you.wish.to.ignore.them.and.continue")), "South");
        }
        return panel;
    }

    public void setCommandName(String commandName) {
        this.myCommandName = commandName;
    }

    protected Runnable getDoRefactoringRunnable(@Nullable UsageView usageView) {
        return this.myDoRefactoringRunnable;
    }

    private class MyShowConflictsInUsageViewAction
    extends AbstractAction {
        public MyShowConflictsInUsageViewAction() {
            super("Show conflicts in view");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UsageViewPresentation presentation = new UsageViewPresentation();
            String codeUsagesString = "Conflicts";
            presentation.setCodeUsagesString("Conflicts");
            presentation.setTabName("Conflicts");
            presentation.setTabText("Conflicts");
            presentation.setShowCancelButton(true);
            Usage[] usages = new Usage[ConflictsDialog.this.myElementConflictDescription.size()];
            int i = 0;
            for (final PsiElement element : ConflictsDialog.this.myElementConflictDescription.keySet()) {
                if (element == null) {
                    usages[i++] = new DescriptionOnlyUsage();
                    continue;
                }
                boolean isRead = false;
                boolean isWrite = false;
                for (ReadWriteAccessDetector detector : (ReadWriteAccessDetector[])Extensions.getExtensions((ExtensionPointName)ReadWriteAccessDetector.EP_NAME)) {
                    if (!detector.isReadWriteAccessible(element)) continue;
                    ReadWriteAccessDetector.Access access = detector.getExpressionAccess(element);
                    isRead = access != ReadWriteAccessDetector.Access.Write;
                    isWrite = access != ReadWriteAccessDetector.Access.Read;
                    break;
                }
                usages[i++] = isRead || isWrite ? new ReadWriteAccessUsageInfo2UsageAdapter(new UsageInfo(element), isRead, isWrite){

                    @NotNull
                    public UsagePresentation getPresentation() {
                        UsagePresentation usagePresentation = super.getPresentation();
                        UsagePresentation usagePresentation2 = MyShowConflictsInUsageViewAction.this.getPresentation(usagePresentation, element);
                        if (usagePresentation2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$1", "getPresentation"));
                        }
                        return usagePresentation2;
                    }
                } : new UsageInfo2UsageAdapter(new UsageInfo(element)){

                    @NotNull
                    public UsagePresentation getPresentation() {
                        UsagePresentation usagePresentation = super.getPresentation();
                        UsagePresentation usagePresentation2 = MyShowConflictsInUsageViewAction.this.getPresentation(usagePresentation, element);
                        if (usagePresentation2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$2", "getPresentation"));
                        }
                        return usagePresentation2;
                    }
                };
            }
            UsageView usageView = UsageViewManager.getInstance((Project)ConflictsDialog.this.myProject).showUsages(UsageTarget.EMPTY_ARRAY, usages, presentation);
            Runnable doRefactoringRunnable = ConflictsDialog.this.getDoRefactoringRunnable(usageView);
            if (doRefactoringRunnable != null) {
                usageView.addPerformOperationAction(doRefactoringRunnable, ConflictsDialog.this.myCommandName != null ? ConflictsDialog.this.myCommandName : RefactoringBundle.message((String)"retry.command"), "Unable to perform refactoring. There were changes in code after the usages have been found.", RefactoringBundle.message((String)"usageView.doAction"));
            }
            ConflictsDialog.this.close(4);
        }

        private UsagePresentation getPresentation(final UsagePresentation usagePresentation, PsiElement element) {
            LinkedHashSet elementConflicts = new LinkedHashSet(ConflictsDialog.this.myElementConflictDescription.get((Object)element));
            final String conflictDescription = " (" + Pattern.compile("<[^<>]*>").matcher(StringUtil.join(elementConflicts, (String)"\n")).replaceAll("") + ")";
            return new UsagePresentation(){

                @NotNull
                public TextChunk[] getText() {
                    Object[] chunks = usagePresentation.getText();
                    TextChunk[] textChunkArray = (TextChunk[])ArrayUtil.append((Object[])chunks, (Object)new TextChunk(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.toTextAttributes(), conflictDescription));
                    if (textChunkArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$3", "getText"));
                    }
                    return textChunkArray;
                }

                @NotNull
                public String getPlainText() {
                    String string = usagePresentation.getPlainText() + conflictDescription;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$3", "getPlainText"));
                    }
                    return string;
                }

                public Icon getIcon() {
                    return usagePresentation.getIcon();
                }

                public String getTooltipText() {
                    return usagePresentation.getTooltipText();
                }
            };
        }

        private class DescriptionOnlyUsage
        implements Usage {
            private final String myConflictDescription;

            private DescriptionOnlyUsage() {
                this.myConflictDescription = Pattern.compile("<[^<>]*>").matcher(StringUtil.join(new LinkedHashSet(ConflictsDialog.this.myElementConflictDescription.get(null)), (String)"\n")).replaceAll("");
            }

            @NotNull
            public UsagePresentation getPresentation() {
                UsagePresentation usagePresentation = new UsagePresentation(){

                    @NotNull
                    public TextChunk[] getText() {
                        TextChunk[] textChunkArray = new TextChunk[]{};
                        if (textChunkArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$DescriptionOnlyUsage$1", "getText"));
                        }
                        return textChunkArray;
                    }

                    @Nullable
                    public Icon getIcon() {
                        return null;
                    }

                    public String getTooltipText() {
                        return DescriptionOnlyUsage.this.myConflictDescription;
                    }

                    @NotNull
                    public String getPlainText() {
                        String string = DescriptionOnlyUsage.this.myConflictDescription;
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$DescriptionOnlyUsage$1", "getPlainText"));
                        }
                        return string;
                    }
                };
                if (usagePresentation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/ConflictsDialog$MyShowConflictsInUsageViewAction$DescriptionOnlyUsage", "getPresentation"));
                }
                return usagePresentation;
            }

            public boolean canNavigateToSource() {
                return false;
            }

            public boolean canNavigate() {
                return false;
            }

            public void navigate(boolean requestFocus) {
            }

            public FileEditorLocation getLocation() {
                return null;
            }

            public boolean isReadOnly() {
                return false;
            }

            public boolean isValid() {
                return true;
            }

            public void selectInEditor() {
            }

            public void highlightInEditor() {
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(RefactoringBundle.message((String)"cancel.button"));
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConflictsDialog.this.doCancelAction();
        }
    }
}

