/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class EditorMouseFixture {
    private final EditorImpl myEditor;
    private int myX;
    private int myY;
    private int myModifiers;
    private int myButton = 1;
    private int myLastId;

    public EditorMouseFixture(EditorImpl editor) {
        this.myEditor = editor;
    }

    public EditorMouseFixture pressAt(int visualLine, int visualColumn) {
        return this.pressAt(1, visualLine, visualColumn);
    }

    private EditorMouseFixture pressAt(int clickCount, int visualLine, int visualColumn) {
        EditorComponentImpl component = this.myEditor.getContentComponent();
        Point p = this.getPoint(visualLine, visualColumn);
        this.myLastId = 501;
        this.myX = p.x;
        this.myY = p.y;
        component.dispatchEvent(new MouseEvent(component, 501, System.currentTimeMillis(), this.getModifiers(), this.myX, this.myY, clickCount, false, this.myButton));
        return this;
    }

    public EditorMouseFixture release() {
        return this.release(1);
    }

    private EditorMouseFixture release(int clickCount) {
        int oldLastId = this.myLastId;
        EditorComponentImpl component = this.myEditor.getContentComponent();
        this.myLastId = 502;
        component.dispatchEvent(new MouseEvent(component, 502, System.currentTimeMillis(), this.getModifiers(), this.myX, this.myY, clickCount, false, this.myButton));
        if (oldLastId == 501) {
            this.myLastId = 500;
            component.dispatchEvent(new MouseEvent(component, 500, System.currentTimeMillis(), this.getModifiers(), this.myX, this.myY, clickCount, false, this.myButton));
        }
        return this;
    }

    public EditorMouseFixture clickAt(int visualLine, int visualColumn) {
        return this.pressAt(visualLine, visualColumn).release();
    }

    public EditorMouseFixture doubleClickAt(int visualLine, int visualColumn) {
        return this.clickAt(visualLine, visualColumn).pressAt(2, visualLine, visualColumn).release(2);
    }

    public EditorMouseFixture tripleClickAt(int visualLine, int visualColumn) {
        return this.doubleClickAt(visualLine, visualColumn).pressAt(3, visualLine, visualColumn).release(3);
    }

    public EditorMouseFixture dragTo(int visualLine, int visualColumn) {
        EditorComponentImpl component = this.myEditor.getContentComponent();
        Point p = this.getPoint(visualLine, visualColumn);
        this.myLastId = 506;
        this.myX = p.x;
        this.myY = p.y;
        component.dispatchEvent(new MouseEvent(component, 506, System.currentTimeMillis(), this.getModifiers(), this.myX, this.myY, 1, false, this.myButton));
        return this;
    }

    public EditorMouseFixture alt() {
        this.myModifiers |= 0x200;
        return this;
    }

    public EditorMouseFixture shift() {
        this.myModifiers |= 0x40;
        return this;
    }

    public EditorMouseFixture middle() {
        this.myButton = 2;
        return this;
    }

    private Point getPoint(int visualLine, int visualColumn) {
        return this.myEditor.visualPositionToXY(new VisualPosition(visualLine, visualColumn));
    }

    private int getModifiers() {
        if (this.myButton == 2) {
            return this.myModifiers | 8;
        }
        return this.myModifiers;
    }
}

