/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.printer.idea;

import com.intellij.ui.JBColor;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.SimplePrintElement;
import com.intellij.vcs.log.printer.idea.ColorGenerator;
import com.intellij.vcs.log.printer.idea.GraphCellPainter;
import com.intellij.vcs.log.printer.idea.PositionUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleGraphCellPainter
implements GraphCellPainter {
    private static final Color MARK_COLOR = JBColor.BLACK;
    private final Stroke usual;
    private final Stroke hide;
    private final Stroke selectUsual;
    private final Stroke selectHide;
    private Graphics2D g2;
    @NotNull
    private final ColorGenerator myColorGenerator;

    public SimpleGraphCellPainter(@NotNull ColorGenerator colorGenerator) {
        if (colorGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorGenerator", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "<init>"));
        }
        this.usual = new BasicStroke(1.5f, 1, 2);
        this.hide = new BasicStroke(1.5f, 1, 2, 0.0f, new float[]{7.0f}, 0.0f);
        this.selectUsual = new BasicStroke(2.5f, 1, 2);
        this.selectHide = new BasicStroke(2.5f, 1, 2, 0.0f, new float[]{7.0f}, 0.0f);
        this.myColorGenerator = colorGenerator;
    }

    private void paintUpLine(int from, int to, Color color) {
        int x1 = 15 * from + 7;
        int y1 = 11;
        int x2 = 15 * to + 7;
        int y2 = -11;
        this.g2.setColor(color);
        this.g2.drawLine(x2, y2, x1, y1);
    }

    private void paintDownLine(int from, int to, Color color) {
        int x1 = 15 * from + 7;
        int y1 = 11;
        int x2 = 15 * to + 7;
        int y2 = 33;
        this.g2.setColor(color);
        this.g2.drawLine(x1, y1, x2, y2);
    }

    private void paintCircle(int position, Color color, boolean select) {
        int x0 = 15 * position + 7;
        int y0 = 11;
        int r = 4;
        if (select) {
            r = 5;
        }
        Ellipse2D.Double circle = new Ellipse2D.Double((double)(x0 - r) + 0.5, (double)(y0 - r) + 0.5, 2 * r, 2 * r);
        this.g2.setColor(color);
        this.g2.fill(circle);
    }

    private void paintDownArrow(int position, Color color) {
        int x0 = 15 * position + 7;
        int r = 4;
        int y0 = 22 - r - 2;
        this.g2.setColor(color);
        this.g2.drawLine(x0, 11, x0, y0 + r);
        this.g2.drawLine(x0, y0 + r, x0 + r, y0);
        this.g2.drawLine(x0, y0 + r, x0 - r, y0);
    }

    private void paintUpArrow(int position, Color color) {
        int x0 = 15 * position + 7;
        int r = 4;
        int y0 = r + 2;
        this.g2.setColor(color);
        this.g2.drawLine(x0, 11, x0, y0 - r);
        this.g2.drawLine(x0, y0 - r, x0 + r, y0);
        this.g2.drawLine(x0, y0 - r, x0 - r, y0);
    }

    private void setStroke(boolean usual, boolean select) {
        if (usual) {
            if (select) {
                this.g2.setStroke(this.selectUsual);
            } else {
                this.g2.setStroke(this.usual);
            }
        } else if (select) {
            this.g2.setStroke(this.selectHide);
        } else {
            this.g2.setStroke(this.hide);
        }
    }

    private void drawLogic(boolean isSelected, boolean isUsual, Color usualColor, LitePrinter printer) {
        if (isSelected) {
            this.setStroke(isUsual, true);
            printer.print(MARK_COLOR);
            this.setStroke(isUsual, false);
            printer.print(usualColor);
        } else {
            this.setStroke(isUsual, false);
            printer.print(usualColor);
        }
    }

    @NotNull
    private Color getColor(@NotNull PrintElement printElement) {
        if (printElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElement", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "getColor"));
        }
        Color color = this.myColorGenerator.getColor(printElement.getColorId());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "getColor"));
        }
        return color;
    }

    private static boolean isUsual(PrintElement printElement) {
        if (!(printElement instanceof EdgePrintElement)) {
            return true;
        }
        EdgePrintElement.LineStyle lineStyle = ((EdgePrintElement)printElement).getLineStyle();
        return lineStyle == EdgePrintElement.LineStyle.SOLID;
    }

    @Override
    public void draw(@NotNull Graphics2D g2, @NotNull Collection<PrintElement> printElements) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "draw"));
        }
        if (printElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElements", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "draw"));
        }
        this.g2 = g2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (final PrintElement printElement : printElements) {
            LitePrinter printer = null;
            if (printElement instanceof EdgePrintElement) {
                printer = new LitePrinter(){

                    @Override
                    public void print(Color color) {
                        EdgePrintElement edgePrintElement = (EdgePrintElement)printElement;
                        int from = edgePrintElement.getPositionInCurrentRow();
                        int to = edgePrintElement.getPositionInOtherRow();
                        if (edgePrintElement.getType() == EdgePrintElement.Type.DOWN) {
                            SimpleGraphCellPainter.this.paintDownLine(from, to, color);
                        } else {
                            SimpleGraphCellPainter.this.paintUpLine(from, to, color);
                        }
                    }
                };
            }
            if (printElement instanceof SimplePrintElement) {
                final int position = printElement.getPositionInCurrentRow();
                switch (((SimplePrintElement)printElement).getType()) {
                    case NODE: {
                        if (printElement.isSelected()) {
                            this.paintCircle(position, MARK_COLOR, true);
                            this.paintCircle(position, this.getColor(printElement), false);
                            break;
                        }
                        this.paintCircle(position, this.getColor(printElement), false);
                        break;
                    }
                    case UP_ARROW: {
                        printer = new LitePrinter(){

                            @Override
                            public void print(Color color) {
                                SimpleGraphCellPainter.this.paintUpArrow(position, color);
                            }
                        };
                        break;
                    }
                    case DOWN_ARROW: {
                        printer = new LitePrinter(){

                            @Override
                            public void print(Color color) {
                                SimpleGraphCellPainter.this.paintDownArrow(position, color);
                            }
                        };
                    }
                }
            }
            if (printer == null) continue;
            this.drawLogic(printElement.isSelected(), SimpleGraphCellPainter.isUsual(printElement), this.getColor(printElement), printer);
        }
    }

    @Override
    @Nullable
    public PrintElement mouseOver(@NotNull Collection<PrintElement> printElements, int x, int y) {
        if (printElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElements", "com/intellij/vcs/log/printer/idea/SimpleGraphCellPainter", "mouseOver"));
        }
        for (PrintElement printElement : printElements) {
            if (!(printElement instanceof SimplePrintElement) || !PositionUtil.overNode(printElement.getPositionInCurrentRow(), x, y, ((SimplePrintElement)printElement).getType())) continue;
            return printElement;
        }
        for (PrintElement printElement : printElements) {
            EdgePrintElement edgePrintElement;
            if (!(printElement instanceof EdgePrintElement) || !((edgePrintElement = (EdgePrintElement)printElement).getType() == EdgePrintElement.Type.DOWN ? PositionUtil.overDownEdge(edgePrintElement.getPositionInCurrentRow(), edgePrintElement.getPositionInOtherRow(), x, y) : PositionUtil.overUpEdge(edgePrintElement.getPositionInOtherRow(), edgePrintElement.getPositionInCurrentRow(), x, y))) continue;
            return printElement;
        }
        return null;
    }

    private static interface LitePrinter {
        public void print(Color var1);
    }
}

