/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.openapi.project.Project;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointChooser;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointNoneItem;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class XMasterBreakpointPanel<B extends XBreakpoint<?>>
extends XBreakpointPropertiesSubPanel<B> {
    private JPanel myMasterBreakpointComboBoxPanel;
    private JPanel myAfterBreakpointHitPanel;
    private JRadioButton myLeaveEnabledRadioButton;
    private JPanel myContentPane;
    private JPanel myMainPanel;
    private BreakpointChooser myMasterBreakpointChooser;
    private XDependentBreakpointManager myDependentBreakpointManager;

    public XMasterBreakpointPanel() {
        this.$$$setupUI$$$();
    }

    private List<BreakpointItem> getBreakpointItemsExceptMy() {
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        DebuggerSupport.getDebuggerSupport(XDebuggerSupport.class).getBreakpointPanelProvider().provideBreakpointItems(this.myProject, items);
        for (BreakpointItem item : items) {
            if (item.getBreakpoint() != this.myBreakpoint) continue;
            items.remove(item);
            break;
        }
        items.add(new BreakpointNoneItem());
        return items;
    }

    @Override
    public void init(Project project, XBreakpointManager breakpointManager, @NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/ui/XMasterBreakpointPanel", "init"));
        }
        super.init(project, breakpointManager, breakpoint);
        this.myDependentBreakpointManager = ((XBreakpointManagerImpl)breakpointManager).getDependentBreakpointManager();
        this.myMasterBreakpointChooser = new BreakpointChooser(project, new BreakpointChooser.Delegate(){

            @Override
            public void breakpointChosen(Project project, BreakpointItem breakpointItem) {
                XMasterBreakpointPanel.this.updateAfterBreakpointHitPanel();
            }
        }, null, this.getBreakpointItemsExceptMy());
        this.myMasterBreakpointComboBoxPanel.add((Component)this.myMasterBreakpointChooser.getComponent(), "Center");
    }

    @Override
    public boolean lightVariant(boolean showAllOptions) {
        XBreakpoint<?> masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint(this.myBreakpoint);
        if (!showAllOptions && masterBreakpoint == null) {
            this.myMainPanel.setVisible(false);
            return true;
        }
        return false;
    }

    private void updateAfterBreakpointHitPanel() {
        boolean enable = this.myMasterBreakpointChooser.getSelectedBreakpoint() != null;
        GuiUtils.enableChildren((boolean)enable, (Component[])new Component[]{this.myAfterBreakpointHitPanel});
    }

    @Override
    void loadProperties() {
        XBreakpoint<?> masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint(this.myBreakpoint);
        if (masterBreakpoint != null) {
            this.myMasterBreakpointChooser.setSelectesBreakpoint(masterBreakpoint);
            this.myLeaveEnabledRadioButton.setSelected(this.myDependentBreakpointManager.isLeaveEnabled(this.myBreakpoint));
        }
        this.updateAfterBreakpointHitPanel();
    }

    @Override
    void saveProperties() {
        XBreakpoint masterBreakpoint = (XBreakpoint)this.myMasterBreakpointChooser.getSelectedBreakpoint();
        if (masterBreakpoint == null) {
            this.myDependentBreakpointManager.clearMasterBreakpoint(this.myBreakpoint);
        } else {
            this.myDependentBreakpointManager.setMasterBreakpoint(this.myBreakpoint, masterBreakpoint, this.myLeaveEnabledRadioButton.isSelected());
        }
    }

    public void setDetailView(DetailView detailView) {
        this.myMasterBreakpointChooser.setDetailView(detailView);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myContentPane = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myMasterBreakpointComboBoxPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setToolTipText(ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.master.breakpoint.description"));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        this.myAfterBreakpointHitPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.label.after.breakpoint.was.hit"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JRadioButton jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.radio.disable.again"));
        jRadioButton2.setSelected(true);
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLeaveEnabledRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.radio.leave.enabled"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        ((Component)jLabel2).setEnabled(true);
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/XDebuggerBundle").getString("xbreakpoint.master.breakpoint.description"));
        ((Component)jLabel2).setFont(UIManager.getFont("Label.font"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

