/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NestedTryStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.try.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/NestedTryStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.try.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/NestedTryStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedTryStatementVisitor();
    }

    private static class NestedTryStatementVisitor
    extends BaseInspectionVisitor {
        private NestedTryStatementVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/NestedTryStatementInspection$NestedTryStatementVisitor", "visitTryStatement"));
            }
            super.visitTryStatement(statement);
            PsiTryStatement parentTry = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiTryStatement.class);
            if (parentTry == null) {
                return;
            }
            PsiCodeBlock tryBlock = parentTry.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)statement, (boolean)true)) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
            PsiMethod containingContainingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parentTry, PsiMethod.class);
            if (containingMethod == null || containingContainingMethod == null || !containingMethod.equals(containingContainingMethod)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

