/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceWhileLoopWithDoWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        WhileLoopPredicate whileLoopPredicate = new WhileLoopPredicate();
        if (whileLoopPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/whileloop/ReplaceWhileLoopWithDoWhileLoopIntention", "getElementPredicate"));
        }
        return whileLoopPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/whileloop/ReplaceWhileLoopWithDoWhileLoopIntention", "processIntention"));
        }
        PsiWhileStatement whileStatement = (PsiWhileStatement)element.getParent();
        if (whileStatement == null) {
            return;
        }
        PsiStatement body = whileStatement.getBody();
        PsiExpression condition = whileStatement.getCondition();
        boolean infiniteLoop = BoolUtils.isTrue(condition);
        StringBuilder doWhileStatementText = new StringBuilder();
        if (!infiniteLoop) {
            doWhileStatementText.append("if(");
            if (condition != null) {
                doWhileStatementText.append(condition.getText());
            }
            doWhileStatementText.append(") {\n");
        }
        if (body instanceof PsiBlockStatement) {
            doWhileStatementText.append("do {");
            PsiBlockStatement blockStatement = (PsiBlockStatement)body;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            if (children.length > 2) {
                for (int i = 1; i < children.length - 1; ++i) {
                    PsiElement child = children[i];
                    doWhileStatementText.append(child.getText());
                }
            }
            doWhileStatementText.append('}');
        } else if (body != null) {
            doWhileStatementText.append("do ").append(body.getText()).append('\n');
        }
        doWhileStatementText.append("while(");
        if (condition != null) {
            doWhileStatementText.append(condition.getText());
        }
        doWhileStatementText.append(");");
        if (!infiniteLoop) {
            doWhileStatementText.append("\n}");
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)whileStatement, doWhileStatementText.toString());
    }
}

