/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.template;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.generate.tostring.exception.TemplateResourceException;
import org.jetbrains.generate.tostring.template.TemplateResource;

public class TemplateResourceLocator {
    private static final String DEFAULT_CONCAT = "/org/jetbrains/generate/tostring/template/DefaultConcatMember.vm";
    private static final String DEFAULT_CONCAT_GROOVY = "/org/jetbrains/generate/tostring/template/DefaultConcatMemberGroovy.vm";
    private static final String DEFAULT_CONCAT_SUPER = "/org/jetbrains/generate/tostring/template/DefaultConcatMemberSuper.vm";
    private static final String DEFAULT_BUFFER = "/org/jetbrains/generate/tostring/template/DefaultBuffer.vm";
    private static final String DEFAULT_BUILDER = "/org/jetbrains/generate/tostring/template/DefaultBuilder.vm";
    private static final String DEFAULT_TOSTRINGBUILDER = "/org/jetbrains/generate/tostring/template/DefaultToStringBuilder.vm";
    private static final String DEFAULT_TOSTRINGBUILDER3 = "/org/jetbrains/generate/tostring/template/DefaultToStringBuilder3.vm";
    private static final String DEFAULT_GUAVA = "/org/jetbrains/generate/tostring/template/DefaultGuava.vm";

    private TemplateResourceLocator() {
    }

    public static TemplateResource[] getDefaultTemplates() {
        try {
            return new TemplateResource[]{new TemplateResource("String concat (+)", TemplateResourceLocator.readFile(DEFAULT_CONCAT), true), new TemplateResource("String concat (+) and super.toString()", TemplateResourceLocator.readFile(DEFAULT_CONCAT_SUPER), true), new TemplateResource("StringBuffer", TemplateResourceLocator.readFile(DEFAULT_BUFFER), true), new TemplateResource("StringBuilder (JDK 1.5)", TemplateResourceLocator.readFile(DEFAULT_BUILDER), true), new TemplateResource("ToStringBuilder (Apache commons-lang)", TemplateResourceLocator.readFile(DEFAULT_TOSTRINGBUILDER), true), new TemplateResource("ToStringBuilder (Apache commons-lang 3)", TemplateResourceLocator.readFile(DEFAULT_TOSTRINGBUILDER3), true), new TemplateResource("Objects.toStringHelper (Guava)", TemplateResourceLocator.readFile(DEFAULT_GUAVA), true), new TemplateResource("Groovy: String concat (+)", TemplateResourceLocator.readFile(DEFAULT_CONCAT_GROOVY), true)};
        }
        catch (IOException e) {
            throw new TemplateResourceException("Error loading default templates", e);
        }
    }

    private static String readFile(String resource) throws IOException {
        BufferedInputStream in = new BufferedInputStream(TemplateResourceLocator.class.getResourceAsStream(resource));
        return StringUtil.convertLineSeparators((String)FileUtil.loadTextAndClose((Reader)new InputStreamReader((InputStream)in, CharsetToolkit.UTF8_CHARSET)));
    }
}

