/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.BuiltInServer;

public class BuiltInServerManagerImpl
extends BuiltInServerManager {
    private static final Logger LOG = Logger.getInstance(BuiltInServerManager.class);
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = new NotificationGroup("Built-in Server", NotificationDisplayType.STICKY_BALLOON, true);
            if (notificationGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/BuiltInServerManagerImpl$1", "compute"));
            }
            return notificationGroup;
        }
    };
    @NonNls
    public static final String PROPERTY_RPC_PORT = "rpc.port";
    private static final int FIRST_PORT_NUMBER = 63342;
    private static final int PORTS_COUNT = 20;
    private volatile int detectedPortNumber = -1;
    private final AtomicBoolean started = new AtomicBoolean(false);
    @Nullable
    private BuiltInServer server;
    private boolean enabledInUnitTestMode = true;

    @Override
    public int getPort() {
        return this.detectedPortNumber == -1 ? BuiltInServerManagerImpl.getDefaultPort() : this.detectedPortNumber;
    }

    @Override
    public BuiltInServerManager waitForStart() {
        Future<?> serverStartFuture = this.startServerInPooledThread();
        if (serverStartFuture != null) {
            LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
            try {
                serverStartFuture.get();
            }
            catch (InterruptedException ignored) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return this;
    }

    private static int getDefaultPort() {
        return System.getProperty(PROPERTY_RPC_PORT) == null ? 63342 : Integer.parseInt(System.getProperty(PROPERTY_RPC_PORT));
    }

    private Future<?> startServerInPooledThread() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() && !this.enabledInUnitTestMode) {
            return null;
        }
        if (!this.started.compareAndSet(false, true)) {
            return null;
        }
        return application.executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                int defaultPort = BuiltInServerManagerImpl.getDefaultPort();
                int workerCount = 1;
                if (Runtime.getRuntime().availableProcessors() > 1) {
                    for (CustomPortServerManager customPortServerManager : (CustomPortServerManager[])CustomPortServerManager.EP_NAME.getExtensions()) {
                        if (customPortServerManager.getPort() == defaultPort) continue;
                        workerCount = 2;
                        break;
                    }
                }
                try {
                    BuiltInServerManagerImpl.this.server = new BuiltInServer();
                    BuiltInServerManagerImpl.this.detectedPortNumber = BuiltInServerManagerImpl.this.server.start(workerCount, defaultPort, 20, true);
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                    ((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification("Cannot start internal HTTP server. Git integration, JavaScript debugger and LiveEdit may operate with errors. Please check your firewall settings and restart " + ApplicationNamesInfo.getInstance().getFullProductName(), NotificationType.ERROR).notify(null);
                    return;
                }
                if (BuiltInServerManagerImpl.this.detectedPortNumber == -1) {
                    LOG.info("built-in server cannot be started, cannot bind to port");
                    return;
                }
                LOG.info("built-in server started, port " + BuiltInServerManagerImpl.this.detectedPortNumber);
                Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)BuiltInServerManagerImpl.this.server);
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        if (!Disposer.isDisposed((Disposable)BuiltInServerManagerImpl.this.server)) {
                            Disposer.dispose((Disposable)BuiltInServerManagerImpl.this.server);
                        }
                    }
                });
            }
        });
    }

    @Override
    @Nullable
    public Disposable getServerDisposable() {
        return this.server;
    }

    @Override
    public boolean isOnBuiltInWebServer(@Nullable Url url) {
        return url != null && !StringUtil.isEmpty((String)url.getAuthority()) && BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority(url.getAuthority());
    }

    private static boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authority", "org/jetbrains/ide/BuiltInServerManagerImpl", "isOnBuiltInWebServerByAuthority"));
        }
        int portIndex = authority.indexOf(58);
        if (portIndex < 0 || portIndex == authority.length() - 1) {
            return false;
        }
        int port = StringUtil.parseInt((String)authority.substring(portIndex + 1), (int)-1);
        if (port == -1) {
            return false;
        }
        BuiltInServerOptions options = BuiltInServerOptions.getInstance();
        int idePort = BuiltInServerManager.getInstance().getPort();
        if (options.builtInServerPort != port && idePort != port) {
            return false;
        }
        String host = authority.substring(0, portIndex);
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            return inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress() || options.builtInServerAvailableExternally && idePort != port && NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setEnabledInUnitTestMode(boolean enabled) {
        this.enabledInUnitTestMode = enabled;
    }

    static final class MyPostStartupActivity
    implements StartupActivity,
    DumbAware {
        private boolean veryFirstProjectOpening = true;

        MyPostStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/ide/BuiltInServerManagerImpl$MyPostStartupActivity", "runActivity"));
            }
            if (!this.veryFirstProjectOpening) {
                return;
            }
            this.veryFirstProjectOpening = false;
            BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
            if (builtInServerManager instanceof BuiltInServerManagerImpl) {
                ((BuiltInServerManagerImpl)builtInServerManager).startServerInPooledThread();
            }
        }
    }
}

