/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.extensions.ExtensionPointName;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.NettyUtil;

public abstract class HttpRequestHandler {
    public static final ExtensionPointName<HttpRequestHandler> EP_NAME = ExtensionPointName.create((String)"com.intellij.httpRequestHandler");

    protected static boolean checkPrefix(@NotNull String uri, @NotNull String prefix) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/ide/HttpRequestHandler", "checkPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/ide/HttpRequestHandler", "checkPrefix"));
        }
        if (uri.length() > prefix.length() && uri.charAt(0) == '/' && uri.regionMatches(true, 1, prefix, 0, prefix.length())) {
            if (uri.length() - prefix.length() == 1) {
                return true;
            }
            char c = uri.charAt(prefix.length() + 1);
            return c == '/' || c == '?';
        }
        return false;
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/HttpRequestHandler", "isAccessible"));
        }
        String host = NettyUtil.host(request);
        return host != null && NettyUtil.isLocalOrigin(request) && NettyUtil.parseAndCheckIsLocalHost("http://" + host);
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/HttpRequestHandler", "isSupported"));
        }
        return request.method() == HttpMethod.GET || request.method() == HttpMethod.HEAD;
    }

    public abstract boolean process(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;
}

