/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultExecutionResult
implements ExecutionResult {
    private final ExecutionConsole myConsole;
    private final ProcessHandler myProcessHandler;
    private AnAction[] myActions;
    @NotNull
    private AnAction[] myRestartActions;
    private final List<AnAction> myStopActions;

    public DefaultExecutionResult() {
        this.myRestartActions = AnAction.EMPTY_ARRAY;
        this.myStopActions = new ArrayList<AnAction>();
        this.myConsole = null;
        this.myProcessHandler = null;
        this.myActions = AnAction.EMPTY_ARRAY;
    }

    public DefaultExecutionResult(@Nullable ExecutionConsole console, @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/DefaultExecutionResult", "<init>"));
        }
        this(console, processHandler, AnAction.EMPTY_ARRAY);
    }

    public DefaultExecutionResult(ExecutionConsole console, @NotNull ProcessHandler processHandler, AnAction ... actions) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/DefaultExecutionResult", "<init>"));
        }
        this.myRestartActions = AnAction.EMPTY_ARRAY;
        this.myStopActions = new ArrayList<AnAction>();
        this.myConsole = console;
        this.myProcessHandler = processHandler;
        this.myActions = actions;
    }

    @Override
    public ExecutionConsole getExecutionConsole() {
        return this.myConsole;
    }

    @Override
    public AnAction[] getActions() {
        return this.myActions;
    }

    public void setActions(AnAction ... actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/execution/DefaultExecutionResult", "setActions"));
        }
        this.myActions = actions;
    }

    @NotNull
    public AnAction[] getRestartActions() {
        if (this.myRestartActions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/DefaultExecutionResult", "getRestartActions"));
        }
        return this.myRestartActions;
    }

    public void setRestartActions(AnAction ... restartActions) {
        this.myRestartActions = restartActions != null ? restartActions : AnAction.EMPTY_ARRAY;
    }

    public void addStopAction(AnAction action) {
        this.myStopActions.add(action);
    }

    @NotNull
    public AnAction[] getAdditionalStopActions() {
        AnAction[] anActionArray = this.myStopActions.toArray(new AnAction[this.myStopActions.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/DefaultExecutionResult", "getAdditionalStopActions"));
        }
        return anActionArray;
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    public static class StopAction
    extends AnAction
    implements DumbAware {
        private final ProcessHandler myProcessHandler;

        public StopAction(ProcessHandler processHandler) {
            super(ExecutionBundle.message("run.configuration.stop.action.name", new Object[0]), null, AllIcons.Actions.Suspend);
            this.getTemplatePresentation().setEnabled(false);
            this.myProcessHandler = processHandler;
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            if (this.myProcessHandler.detachIsDefault()) {
                this.myProcessHandler.detachProcess();
            } else {
                this.myProcessHandler.destroyProcess();
            }
        }

        @Override
        public void update(AnActionEvent event) {
            event.getPresentation().setEnabled(!this.myProcessHandler.isProcessTerminating() && !this.myProcessHandler.isProcessTerminated());
        }
    }
}

