/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiMethodCallPattern;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PsiExpressionPattern<T extends PsiExpression, Self extends PsiExpressionPattern<T, Self>>
extends PsiJavaElementPattern<T, Self> {
    protected PsiExpressionPattern(Class<T> aClass) {
        super(aClass);
    }

    public Self ofType(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/patterns/PsiExpressionPattern", "ofType"));
        }
        return (Self)((PsiExpressionPattern)this.with(new PatternCondition<T>("ofType"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiExpressionPattern$1", "accepts"));
                }
                return pattern.getCondition().accepts(t.getType(), context);
            }
        }));
    }

    public PsiMethodCallPattern methodCall(final ElementPattern<? extends PsiMethod> method) {
        return (PsiMethodCallPattern)((PsiMethodCallPattern)new PsiMethodCallPattern().and(this)).with(new PatternCondition<PsiMethodCallExpression>("methodCall"){

            @Override
            public boolean accepts(@NotNull PsiMethodCallExpression callExpression, ProcessingContext context) {
                JavaResolveResult[] results;
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/patterns/PsiExpressionPattern$2", "accepts"));
                }
                for (JavaResolveResult result : results = callExpression.getMethodExpression().multiResolve(true)) {
                    if (!method.getCondition().accepts(result.getElement(), context)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public Self skipParentheses(final ElementPattern<? extends PsiExpression> expressionPattern) {
        return (Self)((PsiExpressionPattern)this.with(new PatternCondition<T>("skipParentheses"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiExpressionPattern$3", "accepts"));
                }
                Object expression = t;
                while (expression instanceof PsiParenthesizedExpression) {
                    expression = ((PsiParenthesizedExpression)expression).getExpression();
                }
                return expressionPattern.accepts(expression, context);
            }
        }));
    }

    public static class Capture<T extends PsiExpression>
    extends PsiExpressionPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }
    }
}

