/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRemoteBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.push.GitDefineRemoteDialog;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTargetPanel
extends PushTargetPanel<GitPushTarget> {
    private static final Logger LOG = Logger.getInstance(GitPushTargetPanel.class);
    private static final Comparator<GitRemoteBranch> REMOTE_BRANCH_COMPARATOR = new MyRemoteBranchComparator();
    private static final String SEPARATOR = " : ";
    @NotNull
    private final GitPushSupport myPushSupport;
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsEditableTextComponent myTargetRenderer;
    @NotNull
    private final PushTargetTextField myTargetEditor;
    @NotNull
    private final VcsLinkedTextComponent myRemoteRenderer;
    @NotNull
    private final Project myProject;
    @Nullable
    private GitPushTarget myCurrentTarget;
    @Nullable
    private String myError;
    @Nullable
    private Runnable myFireOnChangeAction;

    public GitPushTargetPanel(@NotNull GitPushSupport support, @NotNull GitRepository repository, @Nullable GitPushTarget defaultTarget) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "git4idea/push/GitPushTargetPanel", "<init>"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTargetPanel", "<init>"));
        }
        this.myPushSupport = support;
        this.myRepository = repository;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myProject = this.myRepository.getProject();
        this.myTargetRenderer = new VcsEditableTextComponent("", null);
        this.myTargetEditor = new PushTargetTextField(repository.getProject(), GitPushTargetPanel.getTargetNames(this.myRepository), "");
        this.myRemoteRenderer = new VcsLinkedTextComponent("", new VcsLinkListener(){

            public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                if (sourceNode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "git4idea/push/GitPushTargetPanel$1", "hyperlinkActivated"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel$1", "hyperlinkActivated"));
                }
                if (GitPushTargetPanel.this.myRepository.getRemotes().isEmpty()) {
                    GitPushTargetPanel.this.showDefineRemoteDialog();
                } else {
                    GitPushTargetPanel.this.showRemoteSelector(event);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel remoteAndSeparator = new JPanel(new BorderLayout());
        remoteAndSeparator.setOpaque(false);
        remoteAndSeparator.add((Component)this.myRemoteRenderer, "Center");
        remoteAndSeparator.add((Component)new JBLabel(SEPARATOR), "East");
        this.add(remoteAndSeparator, "West");
        this.add((Component)this.myTargetEditor, "Center");
        this.updateComponents(defaultTarget);
    }

    private void updateComponents(@Nullable GitPushTarget target) {
        this.myCurrentTarget = target;
        String initialBranch = "";
        String initialRemote = "";
        boolean noRemotes = this.myRepository.getRemotes().isEmpty();
        if (target == null) {
            if (this.myRepository.getCurrentBranch() == null) {
                this.myError = "Detached HEAD";
            } else if (this.myRepository.isFresh()) {
                this.myError = "Empty repository";
            } else if (!noRemotes) {
                this.myError = "Can't push";
            }
        } else {
            initialBranch = GitPushTargetPanel.getTextFieldText(target);
            initialRemote = target.getBranch().getRemote().getName();
        }
        this.myTargetRenderer.updateLinkText(initialBranch);
        this.myTargetEditor.setText(initialBranch);
        this.myRemoteRenderer.updateLinkText(noRemotes ? "Define remote" : initialRemote);
        this.myTargetEditor.setVisible(!noRemotes);
    }

    private void showDefineRemoteDialog() {
        GitDefineRemoteDialog dialog = new GitDefineRemoteDialog(this.myRepository.getProject());
        if (dialog.showAndGet()) {
            String url;
            String name = dialog.getRemoteName();
            String error = this.validateRemoteUnderModal(name, url = dialog.getRemoteUrl());
            if (error != null) {
                LOG.warn(String.format("Invalid remote. Name: [%s], URL: [%s], error: %s", name, url, error));
                Messages.showErrorDialog((Project)this.myRepository.getProject(), (String)error, (String)"Invalid Remote URL");
            } else {
                this.addRemoteUnderModal(name, url);
            }
        }
    }

    @Nullable
    private String validateRemoteUnderModal(String name, final String url) {
        if (url.isEmpty()) {
            return "URL can't be empty";
        }
        if (!GitRefNameValidator.getInstance().checkInput(name)) {
            return "Remote name is invalid";
        }
        final Ref error = Ref.create();
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRepository.getProject(), "Checking URL...", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/push/GitPushTargetPanel$2", "run"));
                }
                indicator.setIndeterminate(true);
                GitCommandResult result = GitPushTargetPanel.this.myGit.lsRemote(GitPushTargetPanel.this.myRepository.getProject(), VfsUtilCore.virtualToIoFile((VirtualFile)GitPushTargetPanel.this.myRepository.getRoot()), url);
                if (!result.success()) {
                    error.set((Object)("Remote URL is invalid: " + result.getErrorOutputAsHtmlString()));
                }
            }
        });
        return (String)error.get();
    }

    private void addRemoteUnderModal(final @NotNull String remoteName, final @NotNull String remoteUrl) {
        if (remoteName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteName", "git4idea/push/GitPushTargetPanel", "addRemoteUnderModal"));
        }
        if (remoteUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteUrl", "git4idea/push/GitPushTargetPanel", "addRemoteUnderModal"));
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRepository.getProject(), "Adding remote...", false){
            private GitCommandResult myResult;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/push/GitPushTargetPanel$3", "run"));
                }
                indicator.setIndeterminate(true);
                this.myResult = GitPushTargetPanel.this.myGit.addRemote(GitPushTargetPanel.this.myRepository, remoteName, remoteUrl);
                GitPushTargetPanel.this.myRepository.update();
            }

            public void onSuccess() {
                if (this.myResult.success()) {
                    GitPushTargetPanel.this.updateComponents(GitPushTargetPanel.this.myPushSupport.getDefaultTarget(GitPushTargetPanel.this.myRepository));
                    if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                        GitPushTargetPanel.this.myFireOnChangeAction.run();
                    }
                } else {
                    String message = "Couldn't add remote: " + this.myResult.getErrorOutputAsHtmlString();
                    LOG.warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)message, (String)"Add Remote");
                }
            }
        });
    }

    private void showRemoteSelector(@NotNull MouseEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/push/GitPushTargetPanel", "showRemoteSelector"));
        }
        List<String> remotes = this.getRemotes();
        if (remotes.size() <= 1) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, remotes){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                GitPushTargetPanel.this.myRemoteRenderer.updateLinkText(selectedValue);
                if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                    GitPushTargetPanel.this.myFireOnChangeAction.run();
                }
                return super.onChosen((Object)selectedValue, finalChoice);
            }
        });
        popup.show(new RelativePoint(event));
    }

    @NotNull
    private List<String> getRemotes() {
        List list = ContainerUtil.map(this.myRepository.getRemotes(), (Function)new Function<GitRemote, String>(){

            public String fun(GitRemote remote) {
                return remote.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getRemotes"));
        }
        return list;
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer, boolean isSelected, boolean isActive, @Nullable String forceRenderedText) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "git4idea/push/GitPushTargetPanel", "render"));
        }
        SimpleTextAttributes targetTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)isActive);
        if (this.myError != null) {
            renderer.append(this.myError, PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES, (boolean)isActive));
        } else {
            String currentRemote = this.myRemoteRenderer.getText();
            List<String> remotes = this.getRemotes();
            if (remotes.isEmpty() || remotes.size() > 1) {
                this.myRemoteRenderer.setSelected(isSelected);
                this.myRemoteRenderer.setTransparent(!remotes.isEmpty() && !isActive);
                this.myRemoteRenderer.render(renderer);
            } else {
                renderer.append(currentRemote, targetTextAttributes);
            }
            if (!remotes.isEmpty()) {
                renderer.append(SEPARATOR, targetTextAttributes);
                if (forceRenderedText != null) {
                    this.myTargetEditor.setText(forceRenderedText);
                    renderer.append(forceRenderedText);
                    return;
                }
                GitPushTarget target = this.getValue();
                if (target != null && target.isNewBranchCreated()) {
                    renderer.append("+", PushLogTreeUtil.addTransparencyIfNeeded((SimpleTextAttributes)SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, (boolean)isActive), (Object)this);
                }
                this.myTargetRenderer.setSelected(isSelected);
                this.myTargetRenderer.setTransparent(!isActive);
                this.myTargetRenderer.render(renderer);
            }
        }
    }

    @Nullable
    public GitPushTarget getValue() {
        return this.myCurrentTarget;
    }

    @NotNull
    private static String getTextFieldText(@Nullable GitPushTarget target) {
        String string = target != null ? target.getBranch().getNameForRemoteOperations() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getTextFieldText"));
        }
        return string;
    }

    public void fireOnCancel() {
        this.myTargetEditor.setText(GitPushTargetPanel.getTextFieldText(this.myCurrentTarget));
    }

    public void fireOnChange() {
        if (this.myError != null || this.myRepository.getRemotes().isEmpty()) {
            return;
        }
        String remoteName = this.myRemoteRenderer.getText();
        String branchName = this.myTargetEditor.getText();
        try {
            this.myCurrentTarget = GitPushTarget.parse(this.myRepository, remoteName, branchName);
            this.myTargetRenderer.updateLinkText(branchName);
        }
        catch (ParseException e) {
            LOG.error("Invalid remote name shouldn't be allowed. [" + remoteName + ", " + branchName + "]", (Throwable)e);
        }
    }

    @Nullable
    public ValidationInfo verify() {
        if (this.myError != null) {
            return new ValidationInfo(this.myError, (JComponent)this.myTargetEditor);
        }
        try {
            GitPushTarget.parse(this.myRepository, this.myRemoteRenderer.getText(), this.myTargetEditor.getText());
            return null;
        }
        catch (ParseException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myTargetEditor);
        }
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "git4idea/push/GitPushTargetPanel", "setFireOnChangeAction"));
        }
        this.myFireOnChangeAction = action;
    }

    @NotNull
    private static List<String> getTargetNames(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/push/GitPushTargetPanel", "getTargetNames"));
        }
        List remoteBranches = ContainerUtil.sorted(repository.getBranches().getRemoteBranches(), REMOTE_BRANCH_COMPARATOR);
        List list = ContainerUtil.map((Collection)remoteBranches, (Function)new Function<GitRemoteBranch, String>(){

            public String fun(GitRemoteBranch branch) {
                return branch.getNameForRemoteOperations();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel", "getTargetNames"));
        }
        return list;
    }

    public void addTargetEditorListener(final @NotNull PushTargetEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "git4idea/push/GitPushTargetPanel", "addTargetEditorListener"));
        }
        this.myTargetEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                super.documentChanged(e);
                listener.onTargetInEditModeChanged(GitPushTargetPanel.this.myTargetEditor.getText());
            }
        });
    }

    private static class MyRemoteBranchComparator
    implements Comparator<GitRemoteBranch> {
        private MyRemoteBranchComparator() {
        }

        @Override
        public int compare(@NotNull GitRemoteBranch o1, @NotNull GitRemoteBranch o2) {
            String remoteName2;
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "git4idea/push/GitPushTargetPanel$MyRemoteBranchComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "git4idea/push/GitPushTargetPanel$MyRemoteBranchComparator", "compare"));
            }
            String remoteName1 = o1.getRemote().getName();
            int remoteComparison = remoteName1.compareTo(remoteName2 = o2.getRemote().getName());
            if (remoteComparison != 0) {
                if (remoteName1.equals("origin")) {
                    return -1;
                }
                if (remoteName2.equals("origin")) {
                    return 1;
                }
                return remoteComparison;
            }
            return o1.getNameForLocalOperations().compareTo(o2.getNameForLocalOperations());
        }
    }
}

