/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaAwareCompletionData
extends CompletionData {
    @Override
    protected void addLookupItem(Set<LookupElement> set, final TailType tailType, @NotNull Object completion, PsiFile file, CompletionVariant variant) {
        if (completion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "completion", "com/intellij/codeInsight/completion/JavaAwareCompletionData", "addLookupItem"));
        }
        if (completion instanceof LookupElement && !(completion instanceof LookupItem)) {
            set.add((LookupElement)completion);
            return;
        }
        LookupElement _ret = LookupItemUtil.objectToLookupItem(completion);
        if (_ret == null || !(_ret instanceof LookupItem)) {
            return;
        }
        LookupItem ret = (LookupItem)_ret;
        ret.setInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                if (context.shouldAddCompletionChar()) {
                    return;
                }
                if (tailType != TailType.NONE && tailType.isApplicable(context)) {
                    tailType.processTail(context.getEditor(), context.getTailOffset());
                }
            }
        });
        Map<Object, Object> itemProperties = variant.getItemProperties();
        for (Object key : itemProperties.keySet()) {
            ret.setAttribute(key, itemProperties.get(key));
        }
        set.add((LookupElement)ret);
    }

    @Override
    protected void addKeyword(Set<LookupElement> set, TailType tailType, Object comp, PrefixMatcher matcher, PsiFile file, CompletionVariant variant) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file.getProject()).getElementFactory();
        for (LookupElement item : set) {
            if (!item.getObject().toString().equals(comp.toString())) continue;
            return;
        }
        try {
            PsiKeyword keyword = factory.createKeyword((String)comp);
            this.addLookupItem(set, tailType, keyword, file, variant);
        }
        catch (IncorrectOperationException e) {
            this.addLookupItem(set, tailType, comp, file, variant);
        }
    }

    public void fillCompletions(CompletionParameters parameters, CompletionResultSet result) {
    }
}

