/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaImplementMethodsHandler
implements LanguageCodeInsightActionHandler {
    public boolean isValidFor(Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile) && !(file instanceof PsiCodeFragment)) {
            return false;
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(file.getProject(), editor, file, PsiUtil.isLanguageLevel8OrHigher((PsiElement)file));
        return aClass != null && !OverrideImplementUtil.getMethodSignaturesToImplement(aClass).isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/JavaImplementMethodsHandler", "invoke"));
        }
        PsiClass aClass = OverrideImplementUtil.getContextClass(project, editor, file, PsiUtil.isLanguageLevel8OrHigher((PsiElement)file));
        if (aClass == null) {
            return;
        }
        if (OverrideImplementUtil.getMethodSignaturesToImplement(aClass).isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No methods to implement have been found");
            return;
        }
        OverrideImplementUtil.chooseAndImplementMethods(project, editor, aClass);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

