/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FakeRerunAction
extends AnAction
implements DumbAware {
    FakeRerunAction() {
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/runners/FakeRerunAction", "update"));
        }
        Presentation presentation = event.getPresentation();
        ExecutionEnvironment environment = this.getEnvironment(event);
        if (environment != null) {
            presentation.setText(ExecutionBundle.message((String)"rerun.configuration.action.name", (Object[])new Object[]{environment.getRunProfile().getName()}));
            presentation.setIcon(ExecutionManagerImpl.isProcessRunning(this.getDescriptor(event)) ? AllIcons.Actions.Restart : environment.getExecutor().getIcon());
            presentation.setEnabledAndVisible(this.isEnabled(event));
            return;
        }
        presentation.setEnabledAndVisible(false);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/runners/FakeRerunAction", "actionPerformed"));
        }
        ExecutionEnvironment environment = this.getEnvironment(event);
        if (environment != null) {
            ExecutionUtil.restart((ExecutionEnvironment)environment);
        }
    }

    @Nullable
    protected RunContentDescriptor getDescriptor(AnActionEvent event) {
        return (RunContentDescriptor)event.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
    }

    @Nullable
    protected ExecutionEnvironment getEnvironment(AnActionEvent event) {
        return (ExecutionEnvironment)event.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
    }

    protected boolean isEnabled(AnActionEvent event) {
        RunContentDescriptor descriptor = this.getDescriptor(event);
        ProcessHandler processHandler = descriptor == null ? null : descriptor.getProcessHandler();
        ExecutionEnvironment environment = this.getEnvironment(event);
        return environment != null && !ExecutorRegistry.getInstance().isStarting(environment) && (processHandler == null || !processHandler.isProcessTerminating());
    }
}

