/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestTreeView
extends Tree
implements DataProvider,
CopyProvider {
    public static final DataKey<TestFrameworkRunningModel> MODEL_DATA_KEY = DataKey.create((String)"testFrameworkModel.dataId");
    private TestFrameworkRunningModel myModel;

    protected abstract TreeCellRenderer getRenderer(TestConsoleProperties var1);

    public abstract AbstractTestProxy getSelectedTest(@NotNull TreePath var1);

    protected TestFrameworkRunningModel getTestFrameworkRunningModel() {
        return this.myModel;
    }

    @Nullable
    public AbstractTestProxy getSelectedTest() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length > 1) {
            return null;
        }
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? this.getSelectedTest(selectionPath) : null;
    }

    public void attachToModel(TestFrameworkRunningModel model) {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(model.getRoot())));
        this.getSelectionModel().setSelectionMode(this.getSelectionMode());
        this.myModel = model;
        Disposer.register((Disposable)this.myModel, (Disposable)this.myModel.getRoot());
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                TestTreeView.this.setModel(null);
                TestTreeView.this.myModel = null;
            }
        });
        this.installHandlers();
        this.setCellRenderer(this.getRenderer(this.myModel.getProperties()));
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
        int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        int iconHeight = PoolOfTestIcons.PASSED_ICON.getIconHeight();
        this.setRowHeight(Math.max(fontHeight, iconHeight) + 2);
        this.setLargeModel(true);
    }

    public Object getData(String dataId) {
        TreePath[] paths;
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && (paths = this.getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<PsiElement> els = new ArrayList<PsiElement>(paths.length);
            for (TreePath path : paths) {
                PsiElement psiElement;
                AbstractTestProxy test;
                if (this.isPathSelected(path.getParentPath()) || (test = this.getSelectedTest(path)) == null || (psiElement = (PsiElement)TestsUIUtil.getData(test, CommonDataKeys.PSI_ELEMENT.getName(), this.myModel)) == null) continue;
                els.add(psiElement);
            }
            return els.isEmpty() ? null : els.toArray(new PsiElement[els.size()]);
        }
        if (Location.DATA_KEYS.is(dataId) && (paths = this.getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<Location> locations = new ArrayList<Location>(paths.length);
            for (TreePath path : paths) {
                Location location;
                AbstractTestProxy test;
                if (this.isPathSelected(path.getParentPath()) || (test = this.getSelectedTest(path)) == null || (location = (Location)TestsUIUtil.getData(test, Location.DATA_KEY.getName(), this.myModel)) == null) continue;
                locations.add(location);
            }
            return locations.isEmpty() ? null : locations.toArray(new Location[locations.size()]);
        }
        if (MODEL_DATA_KEY.is(dataId)) {
            return this.myModel;
        }
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        AbstractTestProxy testProxy = this.getSelectedTest(selectionPath);
        if (testProxy == null) {
            return null;
        }
        return TestsUIUtil.getData(testProxy, dataId, this.myModel);
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/testframework/TestTreeView", "performCopy"));
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyReferenceAction.elementToFqn(element)));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/testframework/TestTreeView", "isCopyEnabled"));
        }
        return CommonDataKeys.PSI_ELEMENT.getData(dataContext) != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/testframework/TestTreeView", "isCopyVisible"));
        }
        return true;
    }

    protected void installHandlers() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        new TreeSpeedSearch(this, new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                AbstractTestProxy testProxy = TestTreeView.this.getSelectedTest(path);
                if (testProxy == null) {
                    return null;
                }
                return testProxy.getName();
            }
        });
        TreeUtil.installActions((JTree)((Object)this));
        PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
    }

    @JdkConstants.TreeSelectionMode
    protected int getSelectionMode() {
        return 1;
    }
}

