/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentFactory;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.FormatProcessor;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.formatting.FormattingModelFactory;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentFactory;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingFactory;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapFactory;
import com.intellij.formatting.WrapImpl;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.PsiBasedFormattingModel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialTask;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterImpl
extends FormatterEx
implements IndentFactory,
WrapFactory,
AlignmentFactory,
SpacingFactory,
FormattingModelFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.formatting.FormatterImpl");
    private final AtomicReference<FormattingProgressTask> myProgressTask = new AtomicReference();
    private final AtomicInteger myIsDisabledCount = new AtomicInteger();
    private final IndentImpl NONE_INDENT = new IndentImpl(Indent.Type.NONE, false, false);
    private final IndentImpl myAbsoluteNoneIndent = new IndentImpl(Indent.Type.NONE, true, false);
    private final IndentImpl myLabelIndent = new IndentImpl(Indent.Type.LABEL, false, false);
    private final IndentImpl myContinuationIndentRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION, false, true);
    private final IndentImpl myContinuationIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION, false, false);
    private final IndentImpl myContinuationWithoutFirstIndentRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION_WITHOUT_FIRST, false, true);
    private final IndentImpl myContinuationWithoutFirstIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.CONTINUATION_WITHOUT_FIRST, false, false);
    private final IndentImpl myAbsoluteLabelIndent = new IndentImpl(Indent.Type.LABEL, true, false);
    private final IndentImpl myNormalIndentRelativeToDirectParent = new IndentImpl(Indent.Type.NORMAL, false, true);
    private final IndentImpl myNormalIndentNotRelativeToDirectParent = new IndentImpl(Indent.Type.NORMAL, false, false);
    private final SpacingImpl myReadOnlySpacing = new SpacingImpl(0, 0, 0, true, false, true, 0, false, 0);
    private final Map<SpacingImpl, SpacingImpl> ourSharedProperties = new HashMap<SpacingImpl, SpacingImpl>();
    private final SpacingImpl ourSharedSpacing = new SpacingImpl(-1, -1, -1, false, false, false, -1, false, 0);

    public FormatterImpl() {
        Indent.setFactory((IndentFactory)this);
        Wrap.setFactory((WrapFactory)this);
        Alignment.setFactory((AlignmentFactory)this);
        Spacing.setFactory((SpacingFactory)this);
        FormattingModelProvider.setFactory((FormattingModelFactory)this);
    }

    public Alignment createAlignment(boolean applyToNonFirstBlocksOnLine, @NotNull Alignment.Anchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/formatting/FormatterImpl", "createAlignment"));
        }
        return new AlignmentImpl(applyToNonFirstBlocksOnLine, anchor);
    }

    public Alignment createChildAlignment(Alignment base) {
        AlignmentImpl result = new AlignmentImpl();
        result.setParent(base);
        return result;
    }

    public Indent getNormalIndent(boolean relative) {
        return relative ? this.myNormalIndentRelativeToDirectParent : this.myNormalIndentNotRelativeToDirectParent;
    }

    public Indent getNoneIndent() {
        return this.NONE_INDENT;
    }

    @Override
    public void setProgressTask(@NotNull FormattingProgressTask progressIndicator) {
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/formatting/FormatterImpl", "setProgressTask"));
        }
        if (!FormatterUtil.isFormatterCalledExplicitly()) {
            return;
        }
        this.myProgressTask.set(progressIndicator);
    }

    @Override
    public int getSpacingForBlockAtOffset(FormattingModel model, int offset) {
        Couple<Block> blockWithParent = FormatterImpl.getBlockAtOffset(null, model.getRootBlock(), offset);
        if (blockWithParent != null) {
            int minSpaces;
            SpacingImpl spacing;
            Block prevBlock;
            Block parentBlock = (Block)blockWithParent.first;
            Block targetBlock = (Block)blockWithParent.second;
            if (parentBlock != null && targetBlock != null && (prevBlock = FormatterImpl.findPreviousSibling(parentBlock, targetBlock)) != null && (spacing = (SpacingImpl)parentBlock.getSpacing(prevBlock, targetBlock)) != null && (minSpaces = spacing.getMinSpaces()) > 0) {
                return minSpaces;
            }
        }
        return 0;
    }

    @Nullable
    private static Couple<Block> getBlockAtOffset(@Nullable Block parent, @NotNull Block block, int offset) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/FormatterImpl", "getBlockAtOffset"));
        }
        TextRange textRange = block.getTextRange();
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        if (startOffset == offset) {
            return Couple.of((Object)parent, (Object)block);
        }
        if (startOffset > offset || endOffset < offset || block.isLeaf()) {
            return null;
        }
        for (Block subBlock : block.getSubBlocks()) {
            Couple<Block> result = FormatterImpl.getBlockAtOffset(block, subBlock, offset);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static Block findPreviousSibling(@NotNull Block parent, Block block) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/formatting/FormatterImpl", "findPreviousSibling"));
        }
        Block result = null;
        for (Block subBlock : parent.getSubBlocks()) {
            if (subBlock == block) {
                return result;
            }
            result = subBlock;
        }
        return null;
    }

    @Override
    public void format(final FormattingModel model, final CodeStyleSettings settings, final CommonCodeStyleSettings.IndentOptions indentOptions, final CommonCodeStyleSettings.IndentOptions javaIndentOptions, final FormatTextRanges affectedRanges) throws IncorrectOperationException {
        try {
            FormatterImpl.validateModel(model);
            MyFormattingTask task = new MyFormattingTask(){

                @Override
                @NotNull
                protected FormatProcessor buildProcessor() {
                    FormatProcessor processor = new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, affectedRanges, FormattingProgressCallback.EMPTY);
                    processor.setJavaIndentOptions(javaIndentOptions);
                    processor.format(model);
                    FormatProcessor formatProcessor = processor;
                    if (formatProcessor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl$1", "buildProcessor"));
                    }
                    return formatProcessor;
                }
            };
            this.execute(task);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
    }

    public Wrap createWrap(WrapType type, boolean wrapFirstElement) {
        return new WrapImpl(type, wrapFirstElement);
    }

    public Wrap createChildWrap(Wrap parentWrap, WrapType wrapType, boolean wrapFirstElement) {
        WrapImpl result = new WrapImpl(wrapType, wrapFirstElement);
        result.registerParent((WrapImpl)parentWrap);
        return result;
    }

    @NotNull
    public Spacing createSpacing(int minOffset, int maxOffset, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minOffset, maxOffset, minLineFeeds, false, false, keepLineBreaks, keepBlankLines, false, 0);
        if (spacingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl", "createSpacing"));
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing getReadOnlySpacing() {
        SpacingImpl spacingImpl = this.myReadOnlySpacing;
        if (spacingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl", "getReadOnlySpacing"));
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createDependentLFSpacing(int minSpaces, int maxSpaces, @NotNull TextRange dependencyRange, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependencyRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyRange", "com/intellij/formatting/FormatterImpl", "createDependentLFSpacing"));
        }
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/formatting/FormatterImpl", "createDependentLFSpacing"));
        }
        DependantSpacingImpl dependantSpacingImpl = new DependantSpacingImpl(minSpaces, maxSpaces, dependencyRange, keepLineBreaks, keepBlankLines, rule);
        if (dependantSpacingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl", "createDependentLFSpacing"));
        }
        return dependantSpacingImpl;
    }

    @NotNull
    private FormattingProgressCallback getProgressCallback() {
        FormattingProgressCallback result = this.myProgressTask.get();
        FormattingProgressCallback formattingProgressCallback = result == null ? FormattingProgressCallback.EMPTY : result;
        if (formattingProgressCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl", "getProgressCallback"));
        }
        return formattingProgressCallback;
    }

    @Override
    public void format(final FormattingModel model, final CodeStyleSettings settings, final CommonCodeStyleSettings.IndentOptions indentOptions, final FormatTextRanges affectedRanges) throws IncorrectOperationException {
        try {
            FormatterImpl.validateModel(model);
            MyFormattingTask task = new MyFormattingTask(){

                @Override
                @NotNull
                protected FormatProcessor buildProcessor() {
                    FormatProcessor processor = new FormatProcessor(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, affectedRanges, FormatterImpl.this.getProgressCallback());
                    processor.format(model, true);
                    FormatProcessor formatProcessor = processor;
                    if (formatProcessor == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl$2", "buildProcessor"));
                    }
                    return formatProcessor;
                }
            };
            this.execute(task);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
    }

    public void formatWithoutModifications(final FormattingDocumentModel model, final Block rootBlock, final CodeStyleSettings settings, final CommonCodeStyleSettings.IndentOptions indentOptions, final TextRange affectedRange) throws IncorrectOperationException {
        MyFormattingTask task = new MyFormattingTask(){

            @Override
            @NotNull
            protected FormatProcessor buildProcessor() {
                FormatProcessor result = new FormatProcessor(model, rootBlock, settings, indentOptions, new FormatTextRanges(affectedRange, true), FormattingProgressCallback.EMPTY);
                result.formatWithoutRealModifications();
                FormatProcessor formatProcessor = result;
                if (formatProcessor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl$3", "buildProcessor"));
                }
                return formatProcessor;
            }
        };
        this.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(@NotNull SequentialTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/formatting/FormatterImpl", "execute"));
        }
        this.disableFormatting();
        Application application = ApplicationManager.getApplication();
        FormattingProgressTask progressTask = this.myProgressTask.getAndSet(null);
        if (progressTask == null || !application.isDispatchThread() || application.isUnitTestMode()) {
            try {
                task.prepare();
                while (!task.isDone()) {
                    task.iteration();
                }
            }
            finally {
                this.enableFormatting();
            }
        } else {
            progressTask.setTask(task);
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    FormatterImpl.this.enableFormatting();
                }
            };
            for (FormattingProgressCallback.EventType eventType : FormattingProgressCallback.EventType.values()) {
                progressTask.addCallback(eventType, callback);
            }
            ProgressManager.getInstance().run((Task)progressTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndentInfo getWhiteSpaceBefore(FormattingDocumentModel model, Block block, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange, boolean mayChangeLineFeeds) {
        this.disableFormatting();
        try {
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(model, block, settings, indentOptions, new FormatTextRanges(affectedRange, true));
            LeafBlockWrapper blockBefore = processor.getBlockAtOrAfter(affectedRange.getStartOffset());
            LOG.assertTrue(blockBefore != null);
            WhiteSpace whiteSpace = blockBefore.getWhiteSpace();
            LOG.assertTrue(whiteSpace != null);
            if (!mayChangeLineFeeds) {
                whiteSpace.setLineFeedsAreReadOnly();
            }
            processor.setAllWhiteSpacesAreReadOnly();
            whiteSpace.setReadOnly(false);
            processor.formatWithoutRealModifications();
            IndentInfo indentInfo = new IndentInfo(whiteSpace.getLineFeeds(), whiteSpace.getIndentOffset(), whiteSpace.getSpaces());
            return indentInfo;
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustLineIndentsForRange(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange rangeToAdjust) {
        this.disableFormatting();
        try {
            FormatterImpl.validateModel(model);
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(documentModel, block, settings, indentOptions, new FormatTextRanges(rangeToAdjust, true));
            for (LeafBlockWrapper tokenBlock = processor.getFirstTokenBlock(); tokenBlock != null; tokenBlock = tokenBlock.getNextBlock()) {
                WhiteSpace whiteSpace = tokenBlock.getWhiteSpace();
                whiteSpace.setLineFeedsAreReadOnly(true);
                if (whiteSpace.containsLineFeeds()) continue;
                whiteSpace.setIsReadOnly(true);
            }
            processor.formatWithoutRealModifications();
            processor.performModifications(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatAroundRange(FormattingModel model, CodeStyleSettings settings, TextRange textRange, FileType fileType) {
        this.disableFormatting();
        try {
            FormatterImpl.validateModel(model);
            FormattingDocumentModel documentModel = model.getDocumentModel();
            Block block = model.getRootBlock();
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(documentModel, block, settings, settings.getIndentOptions(fileType), null);
            for (LeafBlockWrapper tokenBlock = processor.getFirstTokenBlock(); tokenBlock != null; tokenBlock = tokenBlock.getNextBlock()) {
                WhiteSpace whiteSpace = tokenBlock.getWhiteSpace();
                if (whiteSpace.getEndOffset() < textRange.getStartOffset() || whiteSpace.getEndOffset() > textRange.getEndOffset() + 1) {
                    whiteSpace.setIsReadOnly(true);
                    continue;
                }
                if (whiteSpace.getStartOffset() <= textRange.getStartOffset() || whiteSpace.getEndOffset() >= textRange.getEndOffset()) continue;
                if (whiteSpace.containsLineFeeds()) {
                    whiteSpace.setLineFeedsAreReadOnly(true);
                    continue;
                }
                whiteSpace.setIsReadOnly(true);
            }
            processor.formatWithoutRealModifications();
            processor.performModifications(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int adjustLineIndent(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, int offset, TextRange affectedRange) throws IncorrectOperationException {
        this.disableFormatting();
        try {
            Block block;
            FormattingDocumentModel documentModel;
            FormatProcessor processor;
            LeafBlockWrapper blockAfterOffset;
            FormatterImpl.validateModel(model);
            if (model instanceof PsiBasedFormattingModel) {
                ((PsiBasedFormattingModel)model).canModifyAllWhiteSpaces();
            }
            if ((blockAfterOffset = (processor = FormatterImpl.buildProcessorAndWrapBlocks(documentModel = model.getDocumentModel(), block = model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true), offset)).getBlockAtOrAfter(offset)) != null && blockAfterOffset.contains(offset)) {
                int n = offset;
                return n;
            }
            WhiteSpace whiteSpace = blockAfterOffset != null ? blockAfterOffset.getWhiteSpace() : processor.getLastWhiteSpace();
            int n = FormatterImpl.adjustLineIndent(offset, documentModel, processor, indentOptions, model, whiteSpace, blockAfterOffset != null ? blockAfterOffset.getNode() : null);
            return n;
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
        return offset;
    }

    private static FormatProcessor buildProcessorAndWrapBlocks(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges) {
        return FormatterImpl.buildProcessorAndWrapBlocks(docModel, rootBlock, settings, indentOptions, affectedRanges, -1);
    }

    private static FormatProcessor buildProcessorAndWrapBlocks(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges, int interestingOffset) {
        FormatProcessor processor = new FormatProcessor(docModel, rootBlock, settings, indentOptions, affectedRanges, interestingOffset, FormattingProgressCallback.EMPTY);
        while (!processor.iteration()) {
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int adjustLineIndent(int offset, FormattingDocumentModel documentModel, FormatProcessor processor, CommonCodeStyleSettings.IndentOptions indentOptions, FormattingModel model, WhiteSpace whiteSpace, ASTNode nodeAfter) {
        IndentInfo indent;
        boolean wsContainsCaret = whiteSpace.getStartOffset() <= offset && offset < whiteSpace.getEndOffset();
        int lineStartOffset = FormatterImpl.getLineStartOffset(offset, whiteSpace, documentModel);
        String newWS = whiteSpace.generateWhiteSpace(indentOptions, lineStartOffset, indent = FormatterImpl.calcIndent(offset, documentModel, processor, whiteSpace)).toString();
        if (!whiteSpace.equalsToString(newWS)) {
            try {
                if (model instanceof FormattingModelEx) {
                    ((FormattingModelEx)model).replaceWhiteSpace(whiteSpace.getTextRange(), nodeAfter, newWS);
                } else {
                    model.replaceWhiteSpace(whiteSpace.getTextRange(), newWS);
                }
            }
            finally {
                model.commitChanges();
            }
        }
        int defaultOffset = offset - whiteSpace.getLength() + newWS.length();
        if (wsContainsCaret) {
            int ws = whiteSpace.getStartOffset() + CharArrayUtil.shiftForward((CharSequence)newWS, (int)Math.max(0, lineStartOffset - whiteSpace.getStartOffset()), (String)" \t");
            return Math.max(defaultOffset, ws);
        }
        return defaultOffset;
    }

    private static boolean hasContentAfterLineBreak(FormattingDocumentModel documentModel, int offset, WhiteSpace whiteSpace) {
        return documentModel.getLineNumber(offset) == documentModel.getLineNumber(whiteSpace.getEndOffset()) && documentModel.getTextLength() != offset;
    }

    @Override
    public String getLineIndent(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, int offset, TextRange affectedRange) {
        FormattingDocumentModel documentModel = model.getDocumentModel();
        Block block = model.getRootBlock();
        if (block.getTextRange().isEmpty()) {
            return null;
        }
        FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(documentModel, block, settings, indentOptions, new FormatTextRanges(affectedRange, true), offset);
        LeafBlockWrapper blockAfterOffset = processor.getBlockAtOrAfter(offset);
        if (blockAfterOffset != null && !blockAfterOffset.contains(offset)) {
            WhiteSpace whiteSpace = blockAfterOffset.getWhiteSpace();
            IndentInfo indent = FormatterImpl.calcIndent(offset, documentModel, processor, whiteSpace);
            return indent.generateNewWhiteSpace(indentOptions);
        }
        return null;
    }

    private static IndentInfo calcIndent(int offset, FormattingDocumentModel documentModel, FormatProcessor processor, WhiteSpace whiteSpace) {
        IndentInfo indent;
        processor.setAllWhiteSpacesAreReadOnly();
        whiteSpace.setLineFeedsAreReadOnly(true);
        if (FormatterImpl.hasContentAfterLineBreak(documentModel, offset, whiteSpace)) {
            whiteSpace.setReadOnly(false);
            processor.formatWithoutRealModifications();
            indent = new IndentInfo(0, whiteSpace.getIndentOffset(), whiteSpace.getSpaces());
        } else {
            indent = processor.getIndentAt(offset);
        }
        return indent;
    }

    public static String getText(FormattingDocumentModel documentModel) {
        return ((Object)FormatterImpl.getCharSequence(documentModel)).toString();
    }

    private static CharSequence getCharSequence(FormattingDocumentModel documentModel) {
        return documentModel.getText(new TextRange(0, documentModel.getTextLength()));
    }

    private static int getLineStartOffset(int offset, WhiteSpace whiteSpace, FormattingDocumentModel documentModel) {
        int lineStartOffset = offset;
        CharSequence text = FormatterImpl.getCharSequence(documentModel);
        lineStartOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)lineStartOffset, (String)" \t\n");
        if (lineStartOffset > whiteSpace.getStartOffset()) {
            int prevEnd;
            if (lineStartOffset >= text.length()) {
                lineStartOffset = text.length() - 1;
            }
            int wsStart = whiteSpace.getStartOffset();
            if (text.charAt(lineStartOffset) == '\n' && wsStart <= (prevEnd = documentModel.getLineStartOffset(documentModel.getLineNumber(lineStartOffset - 1))) && ((Object)documentModel.getText(new TextRange(prevEnd, lineStartOffset))).toString().trim().length() == 0) {
                --lineStartOffset;
            }
            if ((lineStartOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)lineStartOffset, (String)"\t ")) < 0) {
                lineStartOffset = 0;
            }
            if (lineStartOffset != offset && text.charAt(lineStartOffset) == '\n') {
                ++lineStartOffset;
            }
        }
        return lineStartOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustTextRange(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange, boolean keepBlankLines, boolean keepLineBreaks, boolean changeWSBeforeFirstElement, boolean changeLineFeedsBeforeFirstElement, @Nullable FormatterEx.IndentInfoStorage indentInfoStorage) {
        this.disableFormatting();
        try {
            FormatterImpl.validateModel(model);
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true));
            for (LeafBlockWrapper current = processor.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
                SpacingImpl spaceProperty;
                WhiteSpace whiteSpace = current.getWhiteSpace();
                if (whiteSpace.isReadOnly()) continue;
                if (whiteSpace.getStartOffset() > affectedRange.getStartOffset()) {
                    if (whiteSpace.containsLineFeeds() && indentInfoStorage != null) {
                        whiteSpace.setLineFeedsAreReadOnly(true);
                        current.setIndentFromParent(indentInfoStorage.getIndentInfo(current.getStartOffset()));
                        continue;
                    }
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                if (!changeWSBeforeFirstElement) {
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                if (!changeLineFeedsBeforeFirstElement) {
                    whiteSpace.setLineFeedsAreReadOnly(true);
                }
                if ((spaceProperty = current.getSpaceProperty()) == null) continue;
                boolean needChange = false;
                int newKeepLineBreaks = spaceProperty.getKeepBlankLines();
                boolean newKeepLineBreaksFlag = spaceProperty.shouldKeepLineFeeds();
                if (!keepLineBreaks) {
                    needChange = true;
                    newKeepLineBreaksFlag = false;
                }
                if (!keepBlankLines) {
                    needChange = true;
                    newKeepLineBreaks = 0;
                }
                if (!needChange) continue;
                assert (!(spaceProperty instanceof DependantSpacingImpl));
                current.setSpaceProperty(this.getSpacingImpl(spaceProperty.getMinSpaces(), spaceProperty.getMaxSpaces(), spaceProperty.getMinLineFeeds(), spaceProperty.isReadOnly(), spaceProperty.isSafe(), newKeepLineBreaksFlag, newKeepLineBreaks, false, spaceProperty.getPrefLineFeeds()));
            }
            processor.format(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustTextRange(FormattingModel model, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, TextRange affectedRange) {
        this.disableFormatting();
        try {
            FormatterImpl.validateModel(model);
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(model.getDocumentModel(), model.getRootBlock(), settings, indentOptions, new FormatTextRanges(affectedRange, true));
            for (LeafBlockWrapper current = processor.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
                WhiteSpace whiteSpace = current.getWhiteSpace();
                if (whiteSpace.isReadOnly()) continue;
                if (whiteSpace.getStartOffset() > affectedRange.getStartOffset()) {
                    whiteSpace.setReadOnly(true);
                    continue;
                }
                whiteSpace.setReadOnly(false);
            }
            processor.format(model);
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.enableFormatting();
        }
    }

    @Override
    public void saveIndents(FormattingModel model, TextRange affectedRange, FormatterEx.IndentInfoStorage storage, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions) {
        try {
            FormatterImpl.validateModel(model);
            Block block = model.getRootBlock();
            FormatProcessor processor = FormatterImpl.buildProcessorAndWrapBlocks(model.getDocumentModel(), block, settings, indentOptions, new FormatTextRanges(affectedRange, true));
            for (LeafBlockWrapper current = processor.getFirstTokenBlock(); current != null; current = current.getNextBlock()) {
                WhiteSpace whiteSpace = current.getWhiteSpace();
                if (whiteSpace.isReadOnly() || !whiteSpace.containsLineFeeds()) continue;
                storage.saveIndentInfo(current.calcIndentFromParent(), current.getStartOffset());
            }
        }
        catch (FormattingModelInconsistencyException e) {
            LOG.error((Throwable)e);
        }
    }

    public FormattingModel createFormattingModelForPsiFile(PsiFile file, @NotNull Block rootBlock, CodeStyleSettings settings) {
        if (rootBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootBlock", "com/intellij/formatting/FormatterImpl", "createFormattingModelForPsiFile"));
        }
        return new PsiBasedFormattingModel(file, rootBlock, FormattingDocumentModelImpl.createOn(file));
    }

    public Indent getSpaceIndent(int spaces, boolean relative) {
        return this.getIndent(Indent.Type.SPACES, spaces, relative, false);
    }

    public Indent getIndent(@NotNull Indent.Type type, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/formatting/FormatterImpl", "getIndent"));
        }
        return this.getIndent(type, 0, relativeToDirectParent, enforceIndentToChildren);
    }

    public Indent getIndent(@NotNull Indent.Type type, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/formatting/FormatterImpl", "getIndent"));
        }
        return new IndentImpl(type, false, spaces, relativeToDirectParent, enforceIndentToChildren);
    }

    public Indent getAbsoluteLabelIndent() {
        return this.myAbsoluteLabelIndent;
    }

    @NotNull
    public Spacing createSafeSpacing(boolean shouldKeepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(0, 0, 0, false, true, shouldKeepLineBreaks, keepBlankLines, false, 0);
        if (spacingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl", "createSafeSpacing"));
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createKeepingFirstColumnSpacing(int minSpace, int maxSpace, boolean keepLineBreaks, int keepBlankLines) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minSpace, maxSpace, -1, false, false, keepLineBreaks, keepBlankLines, true, 0);
        if (spacingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl", "createKeepingFirstColumnSpacing"));
        }
        return spacingImpl;
    }

    @NotNull
    public Spacing createSpacing(int minSpaces, int maxSpaces, int minLineFeeds, boolean keepLineBreaks, int keepBlankLines, int prefLineFeeds) {
        SpacingImpl spacingImpl = this.getSpacingImpl(minSpaces, maxSpaces, minLineFeeds, false, false, keepLineBreaks, keepBlankLines, false, prefLineFeeds);
        if (spacingImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatterImpl", "createSpacing"));
        }
        return spacingImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpacingImpl getSpacingImpl(int minSpaces, int maxSpaces, int minLineFeeds, boolean readOnly, boolean safe, boolean keepLineBreaksFlag, int keepLineBreaks, boolean keepFirstColumn, int prefLineFeeds) {
        SpacingImpl spacingImpl = this.ourSharedSpacing;
        synchronized (spacingImpl) {
            this.ourSharedSpacing.init(minSpaces, maxSpaces, minLineFeeds, readOnly, safe, keepLineBreaksFlag, keepLineBreaks, keepFirstColumn, prefLineFeeds);
            SpacingImpl spacing = this.ourSharedProperties.get((Object)this.ourSharedSpacing);
            if (spacing == null) {
                spacing = new SpacingImpl(minSpaces, maxSpaces, minLineFeeds, readOnly, safe, keepLineBreaksFlag, keepLineBreaks, keepFirstColumn, prefLineFeeds);
                this.ourSharedProperties.put(spacing, spacing);
            }
            return spacing;
        }
    }

    public Indent getAbsoluteNoneIndent() {
        return this.myAbsoluteNoneIndent;
    }

    public Indent getLabelIndent() {
        return this.myLabelIndent;
    }

    public Indent getContinuationIndent(boolean relative) {
        return relative ? this.myContinuationIndentRelativeToDirectParent : this.myContinuationIndentNotRelativeToDirectParent;
    }

    public Indent getContinuationWithoutFirstIndent(boolean relative) {
        return relative ? this.myContinuationWithoutFirstIndentRelativeToDirectParent : this.myContinuationWithoutFirstIndentNotRelativeToDirectParent;
    }

    @Override
    public boolean isDisabled() {
        return this.myIsDisabledCount.get() > 0;
    }

    private void disableFormatting() {
        this.myIsDisabledCount.incrementAndGet();
    }

    private void enableFormatting() {
        int old = this.myIsDisabledCount.getAndDecrement();
        if (old <= 0) {
            LOG.error("enableFormatting()/disableFormatting() not paired. DisabledLevel = " + old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T runWithFormattingDisabled(@NotNull Computable<T> runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/formatting/FormatterImpl", "runWithFormattingDisabled"));
        }
        this.disableFormatting();
        try {
            Object object = runnable.compute();
            return (T)object;
        }
        finally {
            this.enableFormatting();
        }
    }

    private static void validateModel(FormattingModel model) throws FormattingModelInconsistencyException {
        FormattingDocumentModel documentModel = model.getDocumentModel();
        Document document = documentModel.getDocument();
        Block rootBlock = model.getRootBlock();
        if (rootBlock instanceof ASTBlock) {
            PsiElement rootElement = ((ASTBlock)rootBlock).getNode().getPsi();
            if (!rootElement.isValid()) {
                throw new FormattingModelInconsistencyException("Invalid root block PSI element");
            }
            PsiFile file = rootElement.getContainingFile();
            Project project = file.getProject();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            if (documentManager.isUncommited(document)) {
                throw new FormattingModelInconsistencyException("Uncommitted document");
            }
            if (document.getTextLength() != file.getTextLength()) {
                throw new FormattingModelInconsistencyException("Document length " + document.getTextLength() + " doesn't match PSI file length " + file.getTextLength() + ", language: " + file.getLanguage());
            }
        }
    }

    private static class FormattingModelInconsistencyException
    extends Exception {
        public FormattingModelInconsistencyException(String message) {
            super(message);
        }
    }

    private static abstract class MyFormattingTask
    implements SequentialTask {
        private FormatProcessor myProcessor;
        private boolean myDone;

        private MyFormattingTask() {
        }

        public void prepare() {
            this.myProcessor = this.buildProcessor();
        }

        public boolean isDone() {
            return this.myDone;
        }

        public boolean iteration() {
            this.myDone = this.myProcessor.iteration();
            return this.myDone;
        }

        public void stop() {
            this.myProcessor.stopSequentialProcessing();
            this.myDone = true;
        }

        @NotNull
        protected abstract FormatProcessor buildProcessor();
    }
}

