/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.util.Comparing;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class EditorSettingsStatisticsCollector
extends UsagesCollector {
    EditorSettingsStatisticsCollector() {
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("Editor");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        HashSet<UsageDescriptor> set = new HashSet<UsageDescriptor>();
        EditorSettingsExternalizable es = EditorSettingsExternalizable.getInstance();
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isVirtualSpace(), false, "caretAfterLineEnd");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isCaretInsideTabs(), false, "caretInsideTabs");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isAdditionalPageAtBottom(), false, "virtualSpaceAtFileBottom");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR), false, "softWraps");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE), false, "softWraps.console");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isUseCustomSoftWrapIndent(), false, "softWraps.relativeIndent");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isAllSoftWrapsShown(), false, "softWraps.showAll");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.getStripTrailingSpaces(), "Changed", "stripTrailingSpaces");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isEnsureNewLineAtEOF(), false, "ensureNewlineAtEOF");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isShowQuickDocOnMouseOverElement(), false, "quickDocOnMouseHover");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isBlinkCaret(), true, "nonBlinkingCaret");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isBlockCursor(), false, "blockCaret");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isRightMarginShown(), true, "noRightMargin");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isLineNumbersShown(), false, "lineNumbers");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isFoldingOutlineShown(), true, "noFoldingOutline");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isWhitespacesShown() && es.isLeadingWhitespacesShown(), false, "showLeadingWhitespace");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isWhitespacesShown() && es.isInnerWhitespacesShown(), false, "showInnerWhitespace");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isWhitespacesShown() && es.isTrailingWhitespacesShown(), false, "showTrailingWhitespace");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isIndentGuidesShown(), true, "noIndentGuides");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isSmoothScrolling(), true, "noAnimatedScroll");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isDndEnabled(), false, "dragNDrop");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isWheelFontChangeEnabled(), false, "wheelZoom");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isMouseClickSelectionHonorsCamelWords(), true, "mouseNoCamel");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isVariableInplaceRenameEnabled(), true, "noInplaceRename");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isPreselectRename(), true, "noPreselectOnRename");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isShowInlineLocalDialog(), true, "noInlineDialog");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isRefrainFromScrolling(), false, "minimizeScrolling");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.getOptions().SHOW_NOTIFICATION_AFTER_REFORMAT_CODE_ACTION, true, "afterReformatNotification");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.getOptions().SHOW_NOTIFICATION_AFTER_OPTIMIZE_IMPORTS_ACTION, true, "afterOptimizeNotification");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isSmartHome(), true, "noSmartHome");
        EditorSettingsStatisticsCollector.addIfDiffers(set, es.isCamelWords(), false, "camelWords");
        RichCopySettings rcs = RichCopySettings.getInstance();
        EditorSettingsStatisticsCollector.addIfDiffers(set, rcs.isEnabled(), true, "noRichCopy");
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.AUTO_POPUP_PARAMETER_INFO, true, "noParameterAutoPopup");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.AUTO_POPUP_JAVADOC_INFO, false, "javadocAutoPopup");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.AUTO_POPUP_COMPLETION_LOOKUP, true, "noCompletionAutoPopup");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.COMPLETION_CASE_SENSITIVE, 3, "completionCaseSensitivity");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS, false, "autoPopupCharComplete");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.AUTOCOMPLETE_ON_CODE_COMPLETION, true, "noAutoCompleteBasic");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION, true, "noAutoCompleteSmart");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO, false, "parameterInfoFullSignature");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.getBackspaceMode(), SmartBackspaceMode.AUTOINDENT, "smartBackspace");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.SMART_INDENT_ON_ENTER, true, "noIndentOnEnter");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.INSERT_BRACE_ON_ENTER, true, "noBraceOnEnter");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.JAVADOC_STUB_ON_ENTER, true, "noJavadocOnEnter");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.SMART_END_ACTION, true, "noSmartEnd");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.JAVADOC_GENERATE_CLOSING_TAG, true, "noAutoCloseJavadocTags");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.SURROUND_SELECTION_ON_QUOTE_TYPED, false, "surroundByQuoteOrBrace");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.AUTOINSERT_PAIR_BRACKET, true, "noPairBracketAutoInsert");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.AUTOINSERT_PAIR_QUOTE, true, "noPairQuoteAutoInsert");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.REFORMAT_BLOCK_ON_RBRACE, true, "noReformatOnRBrace");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.REFORMAT_ON_PASTE, 3, "reformatOnPaste");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.ADD_IMPORTS_ON_PASTE, 3, "importsOnPaste");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.HIGHLIGHT_BRACES, true, "noBracesHighlight");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.HIGHLIGHT_SCOPE, false, "scopeHighlight");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.HIGHLIGHT_IDENTIFIER_UNDER_CARET, true, "noIdentifierUnderCaretHighlight");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.OPTIMIZE_IMPORTS_ON_THE_FLY, false, "autoOptimizeImports");
        EditorSettingsStatisticsCollector.addIfDiffers(set, cis.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY, false, "autoAddImports");
        HashSet<UsageDescriptor> hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/editor/EditorSettingsStatisticsCollector", "getUsages"));
        }
        return hashSet;
    }

    private static void addIfDiffers(Set<UsageDescriptor> set, boolean value, boolean defaultValue, String featureId) {
        if (value != defaultValue) {
            set.add(new UsageDescriptor(featureId, 1));
        }
    }

    private static void addIfDiffers(Set<UsageDescriptor> set, Object value, Object defaultValue, String featureIdPrefix) {
        if (!Comparing.equal((Object)value, (Object)defaultValue)) {
            set.add(new UsageDescriptor(featureIdPrefix + "." + value, 1));
        }
    }
}

