/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.external;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.impl.external.ArchiveDiffTool;
import com.intellij.openapi.diff.impl.external.BinaryDiffTool;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompositeDiffTool
implements DiffTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.external.CompositeDiffTool");
    private final List<DiffTool> myTools;

    public CompositeDiffTool(@NotNull List<DiffTool> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/openapi/diff/impl/external/CompositeDiffTool", "<init>"));
        }
        this.myTools = new ArrayList<DiffTool>(tools);
    }

    public CompositeDiffTool(@NotNull DiffTool[] tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/openapi/diff/impl/external/CompositeDiffTool", "<init>"));
        }
        this.myTools = Arrays.asList(tools);
    }

    public void show(DiffRequest data) {
        CompositeDiffTool.checkDiffData(data);
        DiffTool tool = this.chooseTool(data);
        if (tool != null) {
            tool.show(data);
        } else {
            LOG.error("No diff tool found which is able to handle request " + data);
        }
    }

    public boolean canShow(DiffRequest data) {
        CompositeDiffTool.checkDiffData(data);
        return this.chooseTool(data) != null;
    }

    public DiffViewer createComponent(String title, DiffRequest request, Window window, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/external/CompositeDiffTool", "createComponent"));
        }
        throw new IllegalStateException();
    }

    @Nullable
    private DiffTool chooseTool(DiffRequest data) {
        DiffContent[] contents = data.getContents();
        if (contents.length == 2) {
            FileType type2;
            FileType type1 = contents[0].getContentType();
            if (type1 == (type2 = contents[1].getContentType()) && type1 instanceof UIBasedFileType) {
                return BinaryDiffTool.INSTANCE;
            }
            if (type1 == type2 && type1 instanceof ArchiveFileType) {
                return ArchiveDiffTool.INSTANCE;
            }
        }
        for (DiffTool tool : this.myTools) {
            if (!tool.canShow(data)) continue;
            return tool;
        }
        return null;
    }

    private static void checkDiffData(@NotNull DiffRequest data) {
        DiffContent[] contents;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/diff/impl/external/CompositeDiffTool", "checkDiffData"));
        }
        for (DiffContent content : contents = data.getContents()) {
            LOG.assertTrue(content != null, (Object)"Null content in diff request");
        }
    }
}

