/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.Banner;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsSearch;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.options.newEditor.SpotlightPainter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedHashMap;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

final class SettingsEditor
extends AbstractEditor
implements DataProvider {
    private static final String SELECTED_CONFIGURABLE = "settings.editor.selected.configurable";
    private static final String SPLITTER_PROPORTION = "settings.editor.splitter.proportion";
    private final PropertiesComponent myProperties;
    private final Settings mySettings;
    private final SettingsSearch mySearch;
    private final JPanel mySearchPanel;
    private final SettingsFilter myFilter;
    private final SettingsTreeView myTreeView;
    private final ConfigurableEditor myEditor;
    private final OnePixelSplitter mySplitter;
    private final SpotlightPainter mySpotlightPainter;
    private final Banner myBanner;

    SettingsEditor(Disposable parent, Project project, ConfigurableGroup[] groups, Configurable configurable, String filter) {
        super(parent);
        String id;
        this.myProperties = PropertiesComponent.getInstance((Project)project);
        this.mySettings = new Settings(groups){

            @Override
            protected ActionCallback selectImpl(Configurable configurable) {
                SettingsEditor.this.myFilter.update((String)null, false, true);
                return SettingsEditor.this.myTreeView.select(configurable);
            }
        };
        this.mySearch = new SettingsSearch(){

            @Override
            void onTextKeyEvent(KeyEvent event) {
                ((SettingsEditor)SettingsEditor.this).myTreeView.myTree.processKeyEvent(event);
            }
        };
        this.mySearchPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.mySearchPanel.add("CENTER", (Component)((Object)this.mySearch));
        this.myFilter = new SettingsFilter(project, groups, this.mySearch){

            @Override
            Configurable getConfigurable(SimpleNode node) {
                return SettingsTreeView.getConfigurable(node);
            }

            @Override
            SimpleNode findNode(Configurable configurable) {
                return SettingsEditor.this.myTreeView.findNode(configurable);
            }

            @Override
            void updateSpotlight(boolean now) {
                if (!SettingsEditor.this.myDisposed && SettingsEditor.this.mySpotlightPainter != null) {
                    if (!now) {
                        SettingsEditor.this.mySpotlightPainter.updateLater();
                    } else {
                        SettingsEditor.this.mySpotlightPainter.updateNow();
                    }
                }
            }
        };
        this.myFilter.myContext.addColleague(new OptionsEditorColleague(){

            @Override
            public ActionCallback onSelected(@Nullable Configurable configurable, Configurable oldConfigurable) {
                if (configurable != null) {
                    SettingsEditor.this.myProperties.setValue(SettingsEditor.SELECTED_CONFIGURABLE, ConfigurableVisitor.ByID.getID(configurable));
                }
                SettingsEditor.this.checkModified(oldConfigurable);
                return SettingsEditor.this.myEditor.select(configurable);
            }

            @Override
            public ActionCallback onModifiedAdded(Configurable configurable) {
                return this.updateIfCurrent(configurable);
            }

            @Override
            public ActionCallback onModifiedRemoved(Configurable configurable) {
                return this.updateIfCurrent(configurable);
            }

            @Override
            public ActionCallback onErrorsChanged() {
                return this.updateIfCurrent(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
            }

            private ActionCallback updateIfCurrent(Configurable configurable) {
                if (configurable != null && configurable == ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable()) {
                    SettingsEditor.this.updateStatus(configurable);
                    return ActionCallback.DONE;
                }
                return ActionCallback.REJECTED;
            }
        });
        this.myTreeView = new SettingsTreeView(this.myFilter, groups);
        this.myTreeView.myTree.addKeyListener((KeyListener)this.mySearch);
        this.myEditor = new ConfigurableEditor(this, null){

            @Override
            boolean apply() {
                SettingsEditor.this.checkModified(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                if (((SettingsEditor)SettingsEditor.this).myFilter.myContext.getModified().isEmpty()) {
                    return true;
                }
                LinkedHashMap<Configurable, ConfigurationException> map = new LinkedHashMap<Configurable, ConfigurationException>();
                for (Configurable configurable : ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getModified()) {
                    ConfigurationException exception = ConfigurableEditor.apply(configurable);
                    if (exception != null) {
                        map.put(configurable, exception);
                        continue;
                    }
                    if (configurable.isModified()) continue;
                    ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireModifiedRemoved(configurable, null);
                }
                ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireErrorsChanged(map, null);
                if (!map.isEmpty()) {
                    SettingsEditor.this.myTreeView.select((Configurable)map.keySet().iterator().next());
                    return false;
                }
                SettingsEditor.this.updateStatus(((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable());
                return true;
            }

            @Override
            void updateCurrent(Configurable configurable, boolean reset) {
                if (reset && configurable != null) {
                    ((SettingsEditor)SettingsEditor.this).myFilter.myContext.fireReset(configurable);
                }
                SettingsEditor.this.checkModified(configurable);
            }

            @Override
            void openLink(Configurable configurable) {
                SettingsEditor.this.mySettings.select(configurable);
            }
        };
        this.myBanner = new Banner(this.myEditor.getResetAction());
        this.mySearchPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JComponent left = this.myTreeView;
        JPanel right = this.myEditor;
        if (Registry.is((String)"ide.settings.old.style")) {
            this.myBanner.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
            this.mySearch.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
            this.mySearchPanel.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
            this.mySearchPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    Dimension size = SettingsEditor.this.myBanner.getPreferredSize();
                    size.height = SettingsEditor.this.mySearchPanel.getHeight() - 5;
                    SettingsEditor.this.myBanner.setPreferredSize(size);
                    SettingsEditor.this.myBanner.setSize(size);
                    SettingsEditor.this.myBanner.revalidate();
                    SettingsEditor.this.myBanner.repaint();
                }
            });
            left = new JPanel(new BorderLayout());
            left.add("North", this.mySearchPanel);
            left.add("Center", this.myTreeView);
            right = new JPanel(new BorderLayout());
            right.add("North", this.myBanner);
            right.add("Center", this.myEditor);
        } else {
            this.myBanner.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.myTreeView.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    Dimension size = SettingsEditor.this.mySearchPanel.getPreferredSize();
                    size.width = SettingsEditor.this.myTreeView.getWidth();
                    SettingsEditor.this.mySearchPanel.setPreferredSize(size);
                    SettingsEditor.this.mySearchPanel.setSize(size);
                    SettingsEditor.this.mySearchPanel.revalidate();
                    SettingsEditor.this.mySearchPanel.repaint();
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            panel.add("West", this.mySearchPanel);
            panel.add("Center", this.myBanner);
            panel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
            this.add("North", panel);
        }
        this.mySplitter = new OnePixelSplitter(false, this.myProperties.getFloat(SPLITTER_PROPORTION, 0.2f));
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent(left);
        this.mySplitter.setSecondComponent((JComponent)right);
        this.mySpotlightPainter = new SpotlightPainter(this.myEditor, this){

            @Override
            void updateNow() {
                Configurable configurable = ((SettingsEditor)SettingsEditor.this).myFilter.myContext.getCurrentConfigurable();
                if (((SettingsEditor)SettingsEditor.this).myTreeView.myTree.hasFocus() || SettingsEditor.this.mySearch.getTextEditor().hasFocus()) {
                    this.update(SettingsEditor.this.myFilter, configurable, SettingsEditor.this.myEditor.getContent(configurable));
                }
            }
        };
        this.add("Center", (Component)this.mySplitter);
        if (configurable == null && (configurable = new ConfigurableVisitor.ByID((id = this.myProperties.getValue(SELECTED_CONFIGURABLE)) != null ? id : "preferences.lookFeel").find(groups)) == null) {
            configurable = ConfigurableVisitor.ALL.find(groups);
        }
        this.myFilter.update(filter, false, true);
        this.myTreeView.select(configurable);
        Disposer.register((Disposable)this, (Disposable)this.myTreeView);
        this.installSpotlightRemover();
    }

    private void installSpotlightRemover() {
        FocusAdapter spotlightRemover = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component comp = e.getOppositeComponent();
                if (comp == SettingsEditor.this.mySearch.getTextEditor() || comp == ((SettingsEditor)SettingsEditor.this).myTreeView.myTree) {
                    return;
                }
                SettingsEditor.this.mySpotlightPainter.update(null, null, null);
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (!StringUtil.isEmpty((String)SettingsEditor.this.mySearch.getText())) {
                    SettingsEditor.this.mySpotlightPainter.updateNow();
                }
            }
        };
        this.myTreeView.myTree.addFocusListener((FocusListener)spotlightRemover);
        this.mySearch.getTextEditor().addFocusListener(spotlightRemover);
    }

    public Object getData(@NonNls String dataId) {
        return Settings.KEY.is(dataId) ? this.mySettings : null;
    }

    @Override
    void disposeOnce() {
        this.myProperties.setValue(SPLITTER_PROPORTION, Float.toString(this.mySplitter.getProportion()));
    }

    @Override
    Action getApplyAction() {
        return this.myEditor.getApplyAction();
    }

    @Override
    Action getResetAction() {
        return null;
    }

    @Override
    String getHelpTopic() {
        Configurable configurable = this.myFilter.myContext.getCurrentConfigurable();
        while (configurable != null) {
            String topic = configurable.getHelpTopic();
            if (topic != null) {
                return topic;
            }
            configurable = this.myFilter.myContext.getParentConfigurable(configurable);
        }
        return null;
    }

    @Override
    boolean apply() {
        return this.myEditor.apply();
    }

    @Override
    boolean cancel() {
        if (this.myFilter.myContext.isHoldingFilter()) {
            this.mySearch.setText("");
            return false;
        }
        return super.cancel();
    }

    @Override
    JComponent getPreferredFocusedComponent() {
        return this.myTreeView != null ? this.myTreeView.myTree : this.myEditor;
    }

    void updateStatus(Configurable configurable) {
        this.myFilter.updateSpotlight(configurable == null);
        if (this.myBanner != null) {
            this.myBanner.setProject(this.myTreeView.findConfigurableProject(configurable));
            this.myBanner.setText(this.myTreeView.getPathNames(configurable));
        }
        if (this.myEditor != null) {
            ConfigurationException exception = this.myFilter.myContext.getErrors().get(configurable);
            this.myEditor.getApplyAction().setEnabled(!this.myFilter.myContext.getModified().isEmpty());
            this.myEditor.getResetAction().setEnabled(this.myFilter.myContext.isModified(configurable) || exception != null);
            this.myEditor.setError(exception);
        }
        if (configurable != null) {
            new Alarm().addRequest(new Runnable(){

                @Override
                public void run() {
                    if (!SettingsEditor.this.myDisposed && SettingsEditor.this.mySpotlightPainter != null) {
                        SettingsEditor.this.mySpotlightPainter.updateNow();
                    }
                }
            }, 300);
        }
    }

    void checkModified(Configurable configurable) {
        Configurable parent = this.myFilter.myContext.getParentConfigurable(configurable);
        if (ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)parent)) {
            this.checkModifiedForItem(parent);
            for (Configurable child : this.myFilter.myContext.getChildren(parent)) {
                this.checkModifiedForItem(child);
            }
        } else if (configurable != null) {
            this.checkModifiedForItem(configurable);
        }
        this.updateStatus(configurable);
    }

    private void checkModifiedForItem(Configurable configurable) {
        if (configurable != null) {
            JComponent component = this.myEditor.getContent(configurable);
            if (component == null && ConfigurableWrapper.hasOwnContent((UnnamedConfigurable)configurable)) {
                component = this.myEditor.readContent(configurable);
            }
            if (component != null) {
                this.checkModifiedInternal(configurable);
            }
        }
    }

    private void checkModifiedInternal(Configurable configurable) {
        if (configurable.isModified()) {
            this.myFilter.myContext.fireModifiedAdded(configurable, null);
        } else if (!this.myFilter.myContext.getErrors().containsKey(configurable)) {
            this.myFilter.myContext.fireModifiedRemoved(configurable, null);
        }
    }
}

