/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.DirtBuilderReader;
import com.intellij.openapi.vcs.changes.FilePathUnderVcs;
import com.intellij.openapi.vcs.changes.Scopes;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeManagerImpl
extends VcsDirtyScopeManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl");
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final DirtBuilder myDirtBuilder;
    private final VcsGuess myGuess;
    private final SynchronizedLife myLife;
    private final MyProgressHolder myProgressHolder;

    public VcsDirtyScopeManagerImpl(Project project, ChangeListManager changeListManager, ProjectLevelVcsManager vcsManager) {
        this.myProject = project;
        this.myChangeListManager = changeListManager;
        this.myVcsManager = vcsManager;
        this.myLife = new SynchronizedLife();
        this.myGuess = new VcsGuess(this.myProject);
        this.myDirtBuilder = new DirtBuilder(this.myGuess);
        this.myProgressHolder = new MyProgressHolder();
        ((ChangeListManagerImpl)this.myChangeListManager).setDirtyScopeManager(this);
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myLife.born();
            AbstractVcs[] vcss = this.myVcsManager.getAllActiveVcss();
            if (vcss.length > 0) {
                this.markEverythingDirty();
            }
        } else {
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

                public void run() {
                    VcsDirtyScopeManagerImpl.this.myLife.born();
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        @Override
                        public void run() {
                            VcsDirtyScopeManagerImpl.this.markEverythingDirty();
                        }
                    });
                }
            });
        }
    }

    public void suspendMe() {
        this.myLife.suspendMe();
    }

    public void reanimate() {
        final Ref wasNotEmptyRef = new Ref();
        this.myLife.releaseMe(new Runnable(){

            @Override
            public void run() {
                wasNotEmptyRef.set((Object)(!VcsDirtyScopeManagerImpl.this.myDirtBuilder.isEmpty() ? 1 : 0));
            }
        });
        if (Boolean.TRUE.equals(wasNotEmptyRef.get())) {
            this.myChangeListManager.scheduleUpdate();
        }
    }

    public void markEverythingDirty() {
        LifeDrop lifeDrop;
        if (!this.myProject.isOpen() || this.myProject.isDisposed() || this.myVcsManager.getAllActiveVcss().length == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("everything dirty: " + ReflectionUtil.findCallerClass((int)2));
        }
        if ((lifeDrop = this.myLife.doIfAlive(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManagerImpl.this.myDirtBuilder.everythingDirty();
            }
        })).isDone() && !lifeDrop.isSuspened()) {
            this.myChangeListManager.scheduleUpdate();
        }
    }

    public void projectClosed() {
        this.killSelf();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("VcsDirtyScopeManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "getComponentName"));
        }
        return "VcsDirtyScopeManager";
    }

    public void initComponent() {
    }

    private void killSelf() {
        this.myLife.kill(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManagerImpl.this.myDirtBuilder.reset();
            }
        });
    }

    public void disposeComponent() {
        this.killSelf();
    }

    private void convertPaths(@Nullable Collection<FilePath> from, Collection<FilePathUnderVcs> to) {
        if (from != null) {
            for (FilePath fp : from) {
                AbstractVcs vcs = this.myGuess.getVcsForDirty(fp);
                if (vcs == null) continue;
                to.add(new FilePathUnderVcs(fp, vcs));
            }
        }
    }

    public void filePathsDirty(final @Nullable Collection<FilePath> filesDirty, final @Nullable Collection<FilePath> dirsRecursivelyDirty) {
        try {
            boolean haveStuff;
            final ArrayList filesConverted = filesDirty == null ? null : new ArrayList(filesDirty.size());
            final ArrayList dirsConverted = dirsRecursivelyDirty == null ? null : new ArrayList(dirsRecursivelyDirty.size());
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    VcsDirtyScopeManagerImpl.this.convertPaths(filesDirty, filesConverted);
                    VcsDirtyScopeManagerImpl.this.convertPaths(dirsRecursivelyDirty, dirsConverted);
                }
            });
            boolean bl = haveStuff = filesConverted != null && !filesConverted.isEmpty() || dirsConverted != null && !dirsConverted.isEmpty();
            if (!haveStuff) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("paths dirty: " + filesConverted + "; " + dirsConverted + "; " + ReflectionUtil.findCallerClass((int)2));
            }
            this.takeDirt(new Consumer<DirtBuilder>(){

                public void consume(DirtBuilder dirt) {
                    if (filesConverted != null) {
                        for (FilePathUnderVcs root : filesConverted) {
                            dirt.addDirtyFile(root);
                        }
                    }
                    if (dirsConverted != null) {
                        for (FilePathUnderVcs root : dirsConverted) {
                            dirt.addDirtyDirRecursively(root);
                        }
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private void takeDirt(final Consumer<DirtBuilder> filler) {
        final Ref wasNotEmptyRef = new Ref();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                filler.consume((Object)VcsDirtyScopeManagerImpl.this.myDirtBuilder);
                wasNotEmptyRef.set((Object)(!VcsDirtyScopeManagerImpl.this.myDirtBuilder.isEmpty() ? 1 : 0));
            }
        };
        LifeDrop lifeDrop = this.myLife.doIfAlive(runnable);
        if (lifeDrop.isDone() && !lifeDrop.isSuspened() && Boolean.TRUE.equals(wasNotEmptyRef.get())) {
            this.myChangeListManager.scheduleUpdate();
        }
    }

    private void convert(@Nullable Collection<VirtualFile> from, Collection<VcsRoot> to) {
        if (from != null) {
            for (VirtualFile vf : from) {
                AbstractVcs vcs = this.myGuess.getVcsForDirty(vf);
                if (vcs == null) continue;
                to.add(new VcsRoot(vcs, vf));
            }
        }
    }

    public void filesDirty(final @Nullable Collection<VirtualFile> filesDirty, final @Nullable Collection<VirtualFile> dirsRecursivelyDirty) {
        try {
            boolean haveStuff;
            final ArrayList filesConverted = filesDirty == null ? null : new ArrayList(filesDirty.size());
            final ArrayList dirsConverted = dirsRecursivelyDirty == null ? null : new ArrayList(dirsRecursivelyDirty.size());
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    VcsDirtyScopeManagerImpl.this.convert(filesDirty, filesConverted);
                    VcsDirtyScopeManagerImpl.this.convert(dirsRecursivelyDirty, dirsConverted);
                }
            });
            boolean bl = haveStuff = filesConverted != null && !filesConverted.isEmpty() || dirsConverted != null && !dirsConverted.isEmpty();
            if (!haveStuff) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("files dirty: " + filesConverted + "; " + dirsConverted + "; " + ReflectionUtil.findCallerClass((int)2));
            }
            this.takeDirt(new Consumer<DirtBuilder>(){

                public void consume(DirtBuilder dirt) {
                    if (filesConverted != null) {
                        for (VcsRoot root : filesConverted) {
                            dirt.addDirtyFile(root);
                        }
                    }
                    if (dirsConverted != null) {
                        for (VcsRoot root : dirsConverted) {
                            dirt.addDirtyDirRecursively(root);
                        }
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void fileDirty(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "fileDirty"));
        }
        try {
            AbstractVcs vcs = this.myGuess.getVcsForDirty(file);
            if (vcs == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("file dirty: " + file + "; " + ReflectionUtil.findCallerClass((int)2));
            }
            final VcsRoot root = new VcsRoot(vcs, file);
            this.takeDirt(new Consumer<DirtBuilder>(){

                public void consume(DirtBuilder dirtBuilder) {
                    dirtBuilder.addDirtyFile(root);
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void fileDirty(@NotNull FilePath file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "fileDirty"));
        }
        try {
            AbstractVcs vcs = this.myGuess.getVcsForDirty(file);
            if (vcs == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("file dirty: " + file + "; " + ReflectionUtil.findCallerClass((int)1));
            }
            final FilePathUnderVcs root = new FilePathUnderVcs(file, vcs);
            this.takeDirt(new Consumer<DirtBuilder>(){

                public void consume(DirtBuilder dirtBuilder) {
                    dirtBuilder.addDirtyFile(root);
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void dirDirtyRecursively(VirtualFile dir, boolean scheduleUpdate) {
        this.dirDirtyRecursively(dir);
    }

    public void dirDirtyRecursively(VirtualFile dir) {
        try {
            AbstractVcs vcs = this.myGuess.getVcsForDirty(dir);
            if (vcs == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("dir dirty recursively: " + dir + "; " + ReflectionUtil.findCallerClass((int)2));
            }
            final VcsRoot root = new VcsRoot(vcs, dir);
            this.takeDirt(new Consumer<DirtBuilder>(){

                public void consume(DirtBuilder dirtBuilder) {
                    dirtBuilder.addDirtyDirRecursively(root);
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    public void dirDirtyRecursively(FilePath path) {
        try {
            AbstractVcs vcs = this.myGuess.getVcsForDirty(path);
            if (vcs == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("dir dirty recursively: " + path + "; " + ReflectionUtil.findCallerClass((int)2));
            }
            final FilePathUnderVcs root = new FilePathUnderVcs(path, vcs);
            this.takeDirt(new Consumer<DirtBuilder>(){

                public void consume(DirtBuilder dirtBuilder) {
                    dirtBuilder.addDirtyDirRecursively(root);
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    @Nullable
    public VcsInvalidated retrieveScopes() {
        LifeDrop lifeDrop = this.myLife.doIfAlive(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManagerImpl.this.myProgressHolder.takeNext(new DirtBuilder(VcsDirtyScopeManagerImpl.this.myDirtBuilder));
                VcsDirtyScopeManagerImpl.this.myDirtBuilder.reset();
            }
        });
        if (lifeDrop.isDone()) {
            final VcsInvalidated invalidated = this.myProgressHolder.calculateInvalidated();
            this.myLife.doIfAlive(new Runnable(){

                @Override
                public void run() {
                    VcsDirtyScopeManagerImpl.this.myProgressHolder.takeInvalidated(invalidated);
                }
            });
            return invalidated;
        }
        return null;
    }

    public void changesProcessed() {
        this.myLife.doIfAlive(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManagerImpl.this.myProgressHolder.processed();
            }
        });
    }

    @NotNull
    public Collection<FilePath> whatFilesDirty(@NotNull Collection<FilePath> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "whatFilesDirty"));
        }
        ArrayList<FilePath> result = new ArrayList<FilePath>();
        final Ref inProgressHolderRef = new Ref();
        final Ref currentHolderRef = new Ref();
        this.myLife.doIfAlive(new Runnable(){

            @Override
            public void run() {
                inProgressHolderRef.set((Object)VcsDirtyScopeManagerImpl.this.myProgressHolder.copy());
                currentHolderRef.set((Object)new MyProgressHolder(new DirtBuilder(VcsDirtyScopeManagerImpl.this.myDirtBuilder), null));
            }
        });
        VcsInvalidated inProgressInvalidated = inProgressHolderRef.get() == null ? null : ((MyProgressHolder)inProgressHolderRef.get()).calculateInvalidated();
        VcsInvalidated currentInvalidated = currentHolderRef.get() == null ? null : ((MyProgressHolder)currentHolderRef.get()).calculateInvalidated();
        for (FilePath fp : files) {
            if ((inProgressInvalidated == null || !inProgressInvalidated.isFileDirty(fp)) && (currentInvalidated == null || !currentInvalidated.isFileDirty(fp))) continue;
            result.add(fp);
        }
        ArrayList<FilePath> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "whatFilesDirty"));
        }
        return arrayList;
    }

    private String toStringScopes(VcsInvalidated vcsInvalidated) {
        StringBuilder sb = new StringBuilder();
        sb.append("is everything dirty: ").append(vcsInvalidated.isEverythingDirty()).append(";\n");
        for (VcsDirtyScope scope : vcsInvalidated.getScopes()) {
            sb.append("|\nFiles: ");
            for (FilePath path : scope.getDirtyFiles()) {
                sb.append(path).append('\n');
            }
            sb.append("\nDirs: ");
            for (FilePath filePath : scope.getRecursivelyDirtyDirectories()) {
                sb.append(filePath).append('\n');
            }
        }
        sb.append("-------------");
        return sb.toString();
    }

    private static class SynchronizedLife {
        private LifeStages myStage = LifeStages.NOT_BORN;
        private final Object myLock = new Object();
        private boolean mySuspended;

        private SynchronizedLife() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void born() {
            Object object = this.myLock;
            synchronized (object) {
                this.myStage = LifeStages.ALIVE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill(Runnable runnable) {
            Object object = this.myLock;
            synchronized (object) {
                this.myStage = LifeStages.DEAD;
                runnable.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendMe() {
            Object object = this.myLock;
            synchronized (object) {
                if (LifeStages.ALIVE.equals((Object)this.myStage)) {
                    this.mySuspended = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseMe(Runnable runnable) {
            Object object = this.myLock;
            synchronized (object) {
                if (LifeStages.ALIVE.equals((Object)this.myStage)) {
                    this.mySuspended = false;
                    runnable.run();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LifeDrop doIfAliveAndNotSuspended(Runnable runnable) {
            Object object = this.myLock;
            synchronized (object) {
                Object object2 = this.myLock;
                synchronized (object2) {
                    if (LifeStages.ALIVE.equals((Object)this.myStage) && !this.mySuspended) {
                        runnable.run();
                        return new LifeDrop(true, this.mySuspended);
                    }
                    return new LifeDrop(false, this.mySuspended);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LifeDrop doIfAlive(Runnable runnable) {
            Object object = this.myLock;
            synchronized (object) {
                if (LifeStages.ALIVE.equals((Object)this.myStage)) {
                    runnable.run();
                    return new LifeDrop(true, this.mySuspended);
                }
                return new LifeDrop(false, this.mySuspended);
            }
        }

        private static enum LifeStages {
            NOT_BORN,
            ALIVE,
            DEAD;

        }
    }

    private static class LifeDrop {
        private final boolean myDone;
        private final boolean mySuspened;

        private LifeDrop(boolean done, boolean suspened) {
            this.myDone = done;
            this.mySuspened = suspened;
        }

        public boolean isDone() {
            return this.myDone;
        }

        public boolean isSuspened() {
            return this.mySuspened;
        }
    }

    private class MyProgressHolder {
        private VcsInvalidated myInProgressState;
        private DirtBuilderReader myInProgressDirtBuilder;

        public MyProgressHolder() {
            this.myInProgressDirtBuilder = new DirtBuilder(VcsDirtyScopeManagerImpl.this.myGuess);
            this.myInProgressState = null;
        }

        public void takeNext(DirtBuilderReader dirtBuilder) {
            this.myInProgressDirtBuilder = dirtBuilder;
            this.myInProgressState = null;
        }

        private MyProgressHolder(DirtBuilderReader dirtBuilder, VcsInvalidated vcsInvalidated) {
            this.myInProgressDirtBuilder = dirtBuilder;
            this.myInProgressState = vcsInvalidated;
        }

        public VcsInvalidated calculateInvalidated() {
            if (this.myInProgressDirtBuilder != null) {
                return (VcsInvalidated)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VcsInvalidated>(){

                    public VcsInvalidated compute() {
                        Scopes scopes = new Scopes(VcsDirtyScopeManagerImpl.this.myProject, VcsDirtyScopeManagerImpl.this.myGuess);
                        scopes.takeDirt(MyProgressHolder.this.myInProgressDirtBuilder);
                        return scopes.retrieveAndClear();
                    }
                });
            }
            return this.myInProgressState;
        }

        public void takeInvalidated(VcsInvalidated invalidated) {
            this.myInProgressState = invalidated;
            this.myInProgressDirtBuilder = null;
        }

        public void processed() {
            this.myInProgressState = null;
            this.myInProgressDirtBuilder = null;
        }

        public MyProgressHolder copy() {
            return new MyProgressHolder(this.myInProgressDirtBuilder, this.myInProgressState);
        }
    }
}

