/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.CumulativeStubVersion;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateData;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StubUpdatingIndex
extends CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree, FileContent>
implements PsiDependentIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubUpdatingIndex");
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 2, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    private static final DataExternalizer<SerializedStubTree> KEY_EXTERNALIZER = new DataExternalizer<SerializedStubTree>(){

        public void save(@NotNull DataOutput out, @NotNull SerializedStubTree v) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/stubs/StubUpdatingIndex$1", "save"));
            }
            if (v == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "com/intellij/psi/stubs/StubUpdatingIndex$1", "save"));
            }
            v.write(out);
        }

        @NotNull
        public SerializedStubTree read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/stubs/StubUpdatingIndex$1", "read"));
            }
            SerializedStubTree serializedStubTree = new SerializedStubTree(in);
            if (serializedStubTree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$1", "read"));
            }
            return serializedStubTree;
        }
    };
    private static final FileBasedIndex.InputFilter INPUT_FILTER = new FileBasedIndex.InputFilter(){

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubUpdatingIndex$2", "acceptInput"));
            }
            return StubUpdatingIndex.canHaveStub(file);
        }
    };
    private static final KeyDescriptor<Integer> DATA_DESCRIPTOR = new IntInlineKeyDescriptor();

    public static boolean canHaveStub(@NotNull VirtualFile file) {
        BinaryFileStubBuilder builder;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubUpdatingIndex", "canHaveStub"));
        }
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType) {
                if (((IStubFileElementType)elementType).shouldBuildStubFor(file)) {
                    return true;
                }
                if (IndexingStamp.isFileIndexedStateCurrent(file, INDEX_ID)) {
                    return true;
                }
            }
        }
        return (builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder.acceptsFile(file);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        ID<Integer, SerializedStubTree> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getName"));
        }
        return iD;
    }

    public int getCacheSize() {
        return 5;
    }

    public boolean keyIsUniqueForIndexedFile() {
        return true;
    }

    @NotNull
    public DataIndexer<Integer, SerializedStubTree, FileContent> getIndexer() {
        DataIndexer<Integer, SerializedStubTree, FileContent> dataIndexer = new DataIndexer<Integer, SerializedStubTree, FileContent>(){

            @NotNull
            public Map<Integer, SerializedStubTree> map(final @NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/stubs/StubUpdatingIndex$3", "map"));
                }
                final HashMap<Integer, SerializedStubTree> result = new HashMap<Integer, SerializedStubTree>();
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        Stub rootStub = StubTreeBuilder.buildStubTree(inputData);
                        if (rootStub == null) {
                            return;
                        }
                        VirtualFile file = inputData.getFile();
                        int contentLength = file.getFileType().isBinary() ? -1 : ((FileContentImpl)inputData).getPsiFileForPsiDependentIndex().getTextLength();
                        StubUpdatingIndex.rememberIndexingStamp(file, contentLength);
                        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
                        SerializationManagerEx.getInstanceEx().serialize(rootStub, (OutputStream)bytes);
                        int key = Math.abs(FileBasedIndex.getFileId((VirtualFile)file));
                        result.put(key, new SerializedStubTree(bytes.getInternalBuffer(), bytes.size(), rootStub, file.getLength(), contentLength));
                    }
                });
                HashMap<Integer, SerializedStubTree> hashMap = result;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$3", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    private static void rememberIndexingStamp(VirtualFile file, long contentLength) {
        try {
            DataOutputStream stream = INDEXED_STAMP.writeAttribute(file);
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)file.getTimeStamp());
            DataInputOutputUtil.writeLONG((DataOutput)stream, (long)contentLength);
            stream.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public static String getIndexingStampInfo(VirtualFile file) {
        try {
            DataInputStream stream = INDEXED_STAMP.readAttribute(file);
            if (stream == null) {
                return "no data";
            }
            long stamp = DataInputOutputUtil.readTIME((DataInput)stream);
            long size = DataInputOutputUtil.readLONG((DataInput)stream);
            stream.close();
            return "indexed at " + stamp + " with size " + size;
        }
        catch (IOException e) {
            return ExceptionUtil.getThrowableText((Throwable)e);
        }
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        KeyDescriptor<Integer> keyDescriptor = DATA_DESCRIPTOR;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        DataExternalizer<SerializedStubTree> dataExternalizer = KEY_EXTERNALIZER;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return CumulativeStubVersion.getCumulativeVersion();
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(@NotNull ID<Integer, SerializedStubTree> indexId, @NotNull FileBasedIndex owner, @NotNull IndexStorage<Integer, SerializedStubTree> storage) throws StorageException, IOException {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/psi/stubs/StubUpdatingIndex", "createIndexImplementation"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/psi/stubs/StubUpdatingIndex", "createIndexImplementation"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/psi/stubs/StubUpdatingIndex", "createIndexImplementation"));
        }
        if (storage instanceof MemoryIndexStorage) {
            MemoryIndexStorage memStorage = (MemoryIndexStorage)storage;
            memStorage.addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        MyIndex myIndex = new MyIndex(indexId, storage, this.getIndexer());
        if (myIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "createIndexImplementation"));
        }
        return myIndex;
    }

    private static void updateStubIndices(@NotNull Collection<StubIndexKey> indexKeys, int inputId, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (indexKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKeys", "com/intellij/psi/stubs/StubUpdatingIndex", "updateStubIndices"));
        }
        if (oldStubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStubTree", "com/intellij/psi/stubs/StubUpdatingIndex", "updateStubIndices"));
        }
        if (newStubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStubTree", "com/intellij/psi/stubs/StubUpdatingIndex", "updateStubIndices"));
        }
        StubIndexImpl stubIndex = (StubIndexImpl)StubIndex.getInstance();
        for (StubIndexKey key : indexKeys) {
            Map<Object, StubIdList> oldMap = oldStubTree.get(key);
            Map<Object, StubIdList> newMap = newStubTree.get(key);
            Map<Object, StubIdList> _oldMap = oldMap != null ? oldMap : Collections.emptyMap();
            Map<Object, StubIdList> _newMap = newMap != null ? newMap : Collections.emptyMap();
            stubIndex.updateIndex(key, inputId, _oldMap, _newMap);
        }
    }

    @NotNull
    private static Collection<StubIndexKey> getAffectedIndices(@NotNull Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree, @NotNull Map<StubIndexKey, Map<Object, StubIdList>> newStubTree) {
        if (oldStubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldStubTree", "com/intellij/psi/stubs/StubUpdatingIndex", "getAffectedIndices"));
        }
        if (newStubTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStubTree", "com/intellij/psi/stubs/StubUpdatingIndex", "getAffectedIndices"));
        }
        HashSet<StubIndexKey> allIndices = new HashSet<StubIndexKey>();
        allIndices.addAll(oldStubTree.keySet());
        allIndices.addAll(newStubTree.keySet());
        HashSet<StubIndexKey> hashSet = allIndices;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex", "getAffectedIndices"));
        }
        return hashSet;
    }

    private class MyIndex
    extends MapReduceIndex<Integer, SerializedStubTree, FileContent> {
        private StubIndexImpl myStubIndex;

        public MyIndex(ID<Integer, SerializedStubTree> indexId, IndexStorage<Integer, SerializedStubTree> storage, DataIndexer<Integer, SerializedStubTree, FileContent> indexer) throws StorageException, IOException {
            super(indexId, indexer, storage);
            this.checkNameStorage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws StorageException {
            StubIndexImpl stubIndex = this.getStubIndex();
            try {
                for (StubIndexKey key : stubIndex.getAllStubIndexKeys()) {
                    stubIndex.flush(key);
                }
            }
            finally {
                super.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateWithMap(int inputId, @NotNull UpdateData<Integer, SerializedStubTree> updateData) throws StorageException {
            Map<StubIndexKey, Map<Object, StubIdList>> newStubTree;
            if (updateData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateData", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex", "updateWithMap"));
            }
            this.checkNameStorage();
            try {
                newStubTree = this.getStubTree(((MapReduceIndex.SimpleUpdateData)updateData).getNewData());
            }
            catch (SerializerNotFoundException e) {
                throw new StorageException(e);
            }
            StubIndexImpl stubIndex = this.getStubIndex();
            Collection<StubIndexKey> allStubIndices = stubIndex.getAllStubIndexKeys();
            try {
                for (StubIndexKey key : allStubIndices) {
                    stubIndex.getWriteLock(key).lock();
                }
                try {
                    Map<StubIndexKey, Map<Object, StubIdList>> oldStubTree;
                    this.getWriteLock().lock();
                    Map<Integer, SerializedStubTree> oldData = this.readOldData(inputId);
                    try {
                        oldStubTree = this.getStubTree(oldData);
                    }
                    catch (SerializerNotFoundException e) {
                        throw new StorageException(e);
                    }
                    super.updateWithMap(inputId, updateData);
                    StubUpdatingIndex.updateStubIndices(StubUpdatingIndex.getAffectedIndices(oldStubTree, newStubTree), inputId, oldStubTree, newStubTree);
                }
                finally {
                    this.getWriteLock().unlock();
                }
            }
            finally {
                for (StubIndexKey key : allStubIndices) {
                    stubIndex.getWriteLock(key).unlock();
                }
            }
        }

        private StubIndexImpl getStubIndex() {
            StubIndexImpl index = this.myStubIndex;
            if (index == null) {
                index = this.myStubIndex = (StubIndexImpl)StubIndex.getInstance();
            }
            return index;
        }

        private void checkNameStorage() throws StorageException {
            SerializationManagerEx serializationManager = SerializationManagerEx.getInstanceEx();
            if (serializationManager.isNameStorageCorrupted()) {
                serializationManager.repairNameStorage();
                throw new StorageException("NameStorage for stubs serialization has been corrupted");
            }
        }

        private Map<StubIndexKey, Map<Object, StubIdList>> getStubTree(@NotNull Map<Integer, SerializedStubTree> data) throws SerializerNotFoundException {
            Map<StubIndexKey, Map<Object, StubIdList>> stubTree;
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex", "getStubTree"));
            }
            if (!data.isEmpty()) {
                SerializedStubTree stub = data.values().iterator().next();
                ObjectStubBase root = (ObjectStubBase)stub.getStub(true);
                ObjectStubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree(root, false);
                Map<StubIndexKey, Map<Object, int[]>> map = objectStubTree.indexStubTree();
                stubTree = map;
                for (StubIndexKey key : map.keySet()) {
                    Map<Object, int[]> value = map.get(key);
                    for (Object k : value.keySet()) {
                        int[] ints = value.get(k);
                        StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                        value.put(k, (int[])stubList);
                    }
                }
            } else {
                stubTree = Collections.emptyMap();
            }
            return stubTree;
        }

        @NotNull
        private Map<Integer, SerializedStubTree> readOldData(int key) throws StorageException {
            ValueContainer valueContainer;
            THashMap result;
            block7: {
                THashMap tHashMap;
                MemoryIndexStorage memIndexStorage;
                result = new THashMap();
                IndexStorage indexStorage = this.myStorage;
                if (indexStorage instanceof MemoryIndexStorage && !(memIndexStorage = (MemoryIndexStorage)indexStorage).isBufferingEnabled()) {
                    indexStorage = memIndexStorage.getBackendStorage();
                }
                try {
                    valueContainer = indexStorage.read(key);
                    if (valueContainer.size() == 1) break block7;
                    LOG.assertTrue(valueContainer.size() == 0);
                    tHashMap = result;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw new StorageException(cause);
                    }
                    throw e;
                }
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex", "readOldData"));
                }
                return tHashMap;
            }
            result.put(key, valueContainer.getValueIterator().next());
            THashMap tHashMap = result;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$MyIndex", "readOldData"));
            }
            return tHashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() throws StorageException {
            StubIndexImpl stubIndex = StubIndexImpl.getInstanceOrInvalidate();
            Collection<Object> allStubIndexKeys = stubIndex != null ? stubIndex.getAllStubIndexKeys() : Collections.emptyList();
            try {
                for (StubIndexKey stubIndexKey : allStubIndexKeys) {
                    stubIndex.getWriteLock(stubIndexKey).lock();
                }
                this.getWriteLock().lock();
                if (stubIndex != null) {
                    stubIndex.clearAllIndices();
                }
                super.clear();
            }
            finally {
                this.getWriteLock().unlock();
                for (StubIndexKey stubIndexKey : allStubIndexKeys) {
                    stubIndex.getWriteLock(stubIndexKey).unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            try {
                super.dispose();
            }
            finally {
                this.getStubIndex().dispose();
            }
        }
    }
}

