/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderSelectorAction
extends DumbAwareAction {
    @NotNull
    private final Configuration myConfiguration;

    public SliderSelectorAction(@Nullable String text, @Nullable String description, @Nullable Icon icon, @NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/ui/components/SliderSelectorAction", "<init>"));
        }
        super(text, description, icon);
        this.myConfiguration = configuration;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/components/SliderSelectorAction", "update"));
        }
        super.update(e);
        String tooltip = this.myConfiguration.getTooltip();
        if (tooltip != null) {
            e.getPresentation().setText(this.getTemplatePresentation().getText() + " (" + tooltip + ")");
            e.getPresentation().setDescription(this.getTemplatePresentation().getDescription() + " (" + tooltip + ")");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/components/SliderSelectorAction", "actionPerformed"));
        }
        JPanel result = new JPanel(new BorderLayout());
        JLabel label = new JLabel(this.myConfiguration.getSelectText());
        label.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0));
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)label, "North");
        final JSlider slider = new JSlider(0, this.myConfiguration.getMin(), this.myConfiguration.getMax(), this.myConfiguration.getSelected());
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setSnapToTicks(true);
        UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
        slider.setPaintLabels(true);
        slider.setLabelTable(this.myConfiguration.getDictionary());
        if (!this.myConfiguration.isShowOk()) {
            result.add((Component)wrapper, "West");
            result.add((Component)slider, "Center");
        } else {
            result.add((Component)wrapper, "West");
            result.add((Component)slider, "Center");
        }
        final Runnable saveSelection = new Runnable(){

            @Override
            public void run() {
                int value = slider.getModel().getValue();
                SliderSelectorAction.this.myConfiguration.getResultConsumer().consume((Object)value);
            }
        };
        final Ref popupRef = new Ref(null);
        final JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)result, (JComponent)slider).setMovable(true).setCancelOnWindowDeactivation(true).setCancelKeyEnabled(this.myConfiguration.isShowOk()).setKeyboardActions(Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                saveSelection.run();
                ((JBPopup)popupRef.get()).closeOk(null);
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)))).createPopup();
        popupRef.set((Object)popup);
        if (this.myConfiguration.isShowOk()) {
            JButton done = new JButton("Done");
            JBPanel doneWrapper = new JBPanel((LayoutManager)new BorderLayout());
            doneWrapper.add((Component)done, (Object)"North");
            result.add((Component)doneWrapper, "East");
            done.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    saveSelection.run();
                    popup.closeOk(null);
                }
            });
        } else {
            popup.setFinalRunnable(saveSelection);
        }
        InputEvent inputEvent = e.getInputEvent();
        this.show(e, result, popup, inputEvent);
    }

    protected void show(AnActionEvent e, JPanel result, JBPopup popup, InputEvent inputEvent) {
        if (inputEvent instanceof MouseEvent) {
            int width = result.getPreferredSize().width;
            MouseEvent inputEvent1 = (MouseEvent)inputEvent;
            Point point1 = new Point(inputEvent1.getX() - width / 2, inputEvent1.getY());
            RelativePoint point = new RelativePoint(inputEvent1.getComponent(), point1);
            popup.show(point);
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    public static class Configuration {
        @NotNull
        private final String mySelectText;
        @NotNull
        private final Dictionary myDictionary;
        private final int mySelected;
        private final int myMin;
        private final int myMax;
        @NotNull
        private final Consumer<Integer> myResultConsumer;
        private boolean showOk;

        public Configuration(int selected, @NotNull Dictionary dictionary, @NotNull String selectText, @NotNull Consumer<Integer> consumer) {
            if (dictionary == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dictionary", "com/intellij/ui/components/SliderSelectorAction$Configuration", "<init>"));
            }
            if (selectText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectText", "com/intellij/ui/components/SliderSelectorAction$Configuration", "<init>"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ui/components/SliderSelectorAction$Configuration", "<init>"));
            }
            this.showOk = false;
            this.mySelected = selected;
            this.myDictionary = new Hashtable();
            this.mySelectText = selectText;
            this.myResultConsumer = consumer;
            int min = 1;
            int max = 0;
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                String value = (String)dictionary.get(key);
                this.myDictionary.put(key, Configuration.markLabel(value));
                min = Math.min(min, key);
                max = Math.max(max, key);
            }
            this.myMin = min;
            this.myMax = max;
        }

        private static JLabel markLabel(String text) {
            JLabel label = new JLabel(text);
            label.setFont(UIUtil.getLabelFont());
            return label;
        }

        @NotNull
        public String getSelectText() {
            String string = this.mySelectText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/SliderSelectorAction$Configuration", "getSelectText"));
            }
            return string;
        }

        @NotNull
        public Dictionary getDictionary() {
            Dictionary dictionary = this.myDictionary;
            if (dictionary == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/SliderSelectorAction$Configuration", "getDictionary"));
            }
            return dictionary;
        }

        @NotNull
        public Consumer<Integer> getResultConsumer() {
            Consumer<Integer> consumer = this.myResultConsumer;
            if (consumer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/SliderSelectorAction$Configuration", "getResultConsumer"));
            }
            return consumer;
        }

        public int getSelected() {
            return this.mySelected;
        }

        public int getMin() {
            return this.myMin;
        }

        public int getMax() {
            return this.myMax;
        }

        public boolean isShowOk() {
            return this.showOk;
        }

        public void setShowOk(boolean showOk) {
            this.showOk = showOk;
        }

        public String getTooltip() {
            return null;
        }
    }
}

