/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.graph.VisibleGraph;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUtil {
    @NotNull
    public static MultiMap<VirtualFile, VcsRef> groupRefsByRoot(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/impl/VcsLogUtil", "groupRefsByRoot"));
        }
        MultiMap<VirtualFile, VcsRef> map = new MultiMap<VirtualFile, VcsRef>(){

            @NotNull
            protected Map<VirtualFile, Collection<VcsRef>> createMap() {
                TreeMap<VirtualFile, Collection<VcsRef>> treeMap = new TreeMap<VirtualFile, Collection<VcsRef>>(new Comparator<VirtualFile>(){

                    @Override
                    public int compare(VirtualFile o1, VirtualFile o2) {
                        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
                    }
                });
                if (treeMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil$1", "createMap"));
                }
                return treeMap;
            }
        };
        for (VcsRef ref : refs) {
            map.putValue((Object)ref.getRoot(), (Object)ref);
        }
        MultiMap<VirtualFile, VcsRef> multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "groupRefsByRoot"));
        }
        return multiMap;
    }

    @NotNull
    public static List<Integer> getVisibleCommits(final @NotNull VisibleGraph<Integer> visibleGraph) {
        if (visibleGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleCommits"));
        }
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return (Integer)visibleGraph.getRowInfo(index).getCommit();
            }

            @Override
            public int size() {
                return visibleGraph.getVisibleCommitCount();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getVisibleCommits"));
        }
        return abstractList;
    }

    public static int compareRoots(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
        if (root1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root1", "com/intellij/vcs/log/impl/VcsLogUtil", "compareRoots"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root2", "com/intellij/vcs/log/impl/VcsLogUtil", "compareRoots"));
        }
        return root1.getPresentableUrl().compareTo(root2.getPresentableUrl());
    }

    @NotNull
    private static Pair<Set<VirtualFile>, MultiMap<VirtualFile, VirtualFile>> collectRoots(@NotNull Collection<VirtualFile> files, @NotNull Set<VirtualFile> roots) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        HashSet<VirtualFile> selectedRoots = new HashSet<VirtualFile>();
        MultiMap selectedFiles = new MultiMap();
        for (VirtualFile file : files) {
            if (roots.contains(file)) {
                selectedRoots.add(file);
            }
            VirtualFile candidateAncestorRoot = null;
            for (VirtualFile root : roots) {
                if (root.equals(file)) continue;
                if (VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
                    if (candidateAncestorRoot != null && !VfsUtilCore.isAncestor((VirtualFile)candidateAncestorRoot, (VirtualFile)root, (boolean)false)) continue;
                    candidateAncestorRoot = root;
                    continue;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)root, (boolean)false)) continue;
                selectedRoots.add(root);
            }
            if (candidateAncestorRoot == null) continue;
            selectedFiles.putValue(candidateAncestorRoot, (Object)file);
        }
        Pair pair = Pair.create(selectedRoots, (Object)selectedFiles);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "collectRoots"));
        }
        return pair;
    }

    @NotNull
    public static Set<VirtualFile> getAllVisibleRoots(@NotNull Collection<VirtualFile> roots, @Nullable VcsLogRootFilter rootFilter, @Nullable VcsLogStructureFilter structureFilter) {
        Collection fromStructureFilter;
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
        }
        if (rootFilter == null && structureFilter == null) {
            HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(roots);
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
            }
            return hashSet;
        }
        Collection fromRootFilter = rootFilter != null ? rootFilter.getRoots() : roots;
        if (structureFilter != null) {
            Pair<Set<VirtualFile>, MultiMap<VirtualFile, VirtualFile>> rootsAndFiles = VcsLogUtil.collectRoots(structureFilter.getFiles(), new HashSet<VirtualFile>(roots));
            fromStructureFilter = ContainerUtil.union((Set)((Set)rootsAndFiles.first), (Set)((MultiMap)rootsAndFiles.second).keySet());
        } else {
            fromStructureFilter = roots;
        }
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(ContainerUtil.intersection((Collection)fromRootFilter, (Collection)fromStructureFilter));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getAllVisibleRoots"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getFilteredFilesForRoot(@NotNull VirtualFile root, VcsLogFilterCollection filterCollection) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
        }
        if (filterCollection.getStructureFilter() == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
            }
            return set;
        }
        Pair<Set<VirtualFile>, MultiMap<VirtualFile, VirtualFile>> rootsAndFiles = VcsLogUtil.collectRoots(filterCollection.getStructureFilter().getFiles(), Collections.singleton(root));
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>(((MultiMap)rootsAndFiles.second).get((Object)root));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogUtil", "getFilteredFilesForRoot"));
        }
        return hashSet;
    }
}

