/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBufUtf8Writer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.ssi.SsiCommand;
import org.jetbrains.builtInWebServer.ssi.SsiConditional;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.SsiFsize;
import org.jetbrains.builtInWebServer.ssi.SsiProcessingState;
import org.jetbrains.builtInWebServer.ssi.SsiStopProcessingException;
import org.jetbrains.builtInWebServer.ssi.Strftime;

public class SsiProcessor {
    static final Logger LOG = Logger.getInstance(SsiProcessor.class);
    protected static final String COMMAND_START = "<!--#";
    protected static final String COMMAND_END = "-->";
    protected final Map<String, SsiCommand> commands = new THashMap();

    public SsiProcessor(boolean allowExec) {
        this.commands.put("config", new SsiCommand(){

            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$1", "process"));
                }
                if (commandName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$1", "process"));
                }
                if (paramNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$1", "process"));
                }
                if (paramValues == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramValues", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$1", "process"));
                }
                if (writer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$1", "process"));
                }
                for (int i = 0; i < paramNames.size(); ++i) {
                    String paramName = paramNames.get(i);
                    String paramValue = paramValues[i];
                    String substitutedValue = state.substituteVariables(paramValue);
                    if (paramName.equalsIgnoreCase("errmsg")) {
                        state.configErrorMessage = substitutedValue;
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("sizefmt")) {
                        state.configSizeFmt = substitutedValue;
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("timefmt")) {
                        state.setConfigTimeFormat(substitutedValue, false);
                        continue;
                    }
                    LOG.info("#config--Invalid attribute: " + paramName);
                    writer.write(state.configErrorMessage);
                }
                return 0L;
            }
        });
        this.commands.put("echo", new SsiCommand(){

            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$2", "process"));
                }
                if (commandName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$2", "process"));
                }
                if (paramNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$2", "process"));
                }
                if (paramValues == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramValues", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$2", "process"));
                }
                if (writer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$2", "process"));
                }
                String encoding = "entity";
                String originalValue = null;
                String errorMessage = state.configErrorMessage;
                for (int i = 0; i < paramNames.size(); ++i) {
                    String paramName = paramNames.get(i);
                    String paramValue = paramValues[i];
                    if (paramName.equalsIgnoreCase("var")) {
                        originalValue = paramValue;
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("encoding")) {
                        if (paramValue.equalsIgnoreCase("url") || paramValue.equalsIgnoreCase("entity") || paramValue.equalsIgnoreCase("none")) {
                            encoding = paramValue;
                            continue;
                        }
                        LOG.info("#echo--Invalid encoding: " + paramValue);
                        writer.write(errorMessage);
                        continue;
                    }
                    LOG.info("#echo--Invalid attribute: " + paramName);
                    writer.write(errorMessage);
                }
                assert (originalValue != null);
                String variableValue = state.getVariableValue(originalValue, encoding);
                writer.write(variableValue == null ? "(none)" : variableValue);
                return System.currentTimeMillis();
            }
        });
        if (allowExec) {
            // empty if block
        }
        this.commands.put("include", new SsiCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$3", "process"));
                }
                if (commandName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$3", "process"));
                }
                if (paramNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$3", "process"));
                }
                if (paramValues == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramValues", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$3", "process"));
                }
                if (writer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$3", "process"));
                }
                long lastModified = 0L;
                String configErrorMessage = state.configErrorMessage;
                for (int i = 0; i < paramNames.size(); ++i) {
                    String paramName = paramNames.get(i);
                    if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                        String substitutedValue = state.substituteVariables(paramValues[i]);
                        try {
                            boolean virtual = paramName.equalsIgnoreCase("virtual");
                            lastModified = state.ssiExternalResolver.getFileLastModified(substitutedValue, virtual);
                            VirtualFile file = state.ssiExternalResolver.findFile(substitutedValue, virtual);
                            if (file == null) {
                                LOG.warn("#include-- Couldn't find file: " + substitutedValue);
                                return 0L;
                            }
                            InputStream in = file.getInputStream();
                            try {
                                writer.write(in, (int)file.getLength());
                            }
                            finally {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            LOG.warn("#include--Couldn't include file: " + substitutedValue, (Throwable)e);
                            writer.write(configErrorMessage);
                        }
                        continue;
                    }
                    LOG.info("#include--Invalid attribute: " + paramName);
                    writer.write(configErrorMessage);
                }
                return lastModified;
            }
        });
        this.commands.put("flastmod", new SsiCommand(){

            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$4", "process"));
                }
                if (commandName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$4", "process"));
                }
                if (paramNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$4", "process"));
                }
                if (paramValues == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramValues", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$4", "process"));
                }
                if (writer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$4", "process"));
                }
                long lastModified = 0L;
                String configErrMsg = state.configErrorMessage;
                for (int i = 0; i < paramNames.size(); ++i) {
                    String paramName = paramNames.get(i);
                    String paramValue = paramValues[i];
                    String substitutedValue = state.substituteVariables(paramValue);
                    if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                        boolean virtual = paramName.equalsIgnoreCase("virtual");
                        lastModified = state.ssiExternalResolver.getFileLastModified(substitutedValue, virtual);
                        Strftime strftime = new Strftime(state.configTimeFmt, Locale.US);
                        writer.write(strftime.format(new Date(lastModified)));
                        continue;
                    }
                    LOG.info("#flastmod--Invalid attribute: " + paramName);
                    writer.write(configErrMsg);
                }
                return lastModified;
            }
        });
        this.commands.put("fsize", new SsiFsize());
        this.commands.put("printenv", new SsiCommand(){

            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$5", "process"));
                }
                if (commandName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$5", "process"));
                }
                if (paramNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$5", "process"));
                }
                if (paramValues == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramValues", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$5", "process"));
                }
                if (writer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$5", "process"));
                }
                long lastModified = 0L;
                if (paramNames.isEmpty()) {
                    LinkedHashSet<String> variableNames = new LinkedHashSet<String>();
                    variableNames.add("DATE_GMT");
                    variableNames.add("DATE_LOCAL");
                    variableNames.add("LAST_MODIFIED");
                    state.ssiExternalResolver.addVariableNames(variableNames);
                    for (String variableName : variableNames) {
                        String variableValue = state.getVariableValue(variableName);
                        if (variableValue == null) {
                            variableValue = "(none)";
                        }
                        writer.write(variableName);
                        writer.write(61);
                        writer.write(variableValue);
                        writer.write(10);
                        lastModified = System.currentTimeMillis();
                    }
                } else {
                    writer.write(state.configErrorMessage);
                }
                return lastModified;
            }
        });
        this.commands.put("set", new SsiCommand(){

            @Override
            public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$6", "process"));
                }
                if (commandName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$6", "process"));
                }
                if (paramNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNames", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$6", "process"));
                }
                if (paramValues == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramValues", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$6", "process"));
                }
                if (writer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/builtInWebServer/ssi/SsiProcessor$6", "process"));
                }
                long lastModified = 0L;
                String errorMessage = state.configErrorMessage;
                String variableName = null;
                for (int i = 0; i < paramNames.size(); ++i) {
                    String paramName = paramNames.get(i);
                    String paramValue = paramValues[i];
                    if (paramName.equalsIgnoreCase("var")) {
                        variableName = paramValue;
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("value")) {
                        if (variableName != null) {
                            String substitutedValue = state.substituteVariables(paramValue);
                            state.ssiExternalResolver.setVariableValue(variableName, substitutedValue);
                            lastModified = System.currentTimeMillis();
                            continue;
                        }
                        LOG.info("#set--no variable specified");
                        writer.write(errorMessage);
                        throw new SsiStopProcessingException();
                    }
                    LOG.info("#set--Invalid attribute: " + paramName);
                    writer.write(errorMessage);
                    throw new SsiStopProcessingException();
                }
                return lastModified;
            }
        });
        SsiConditional ssiConditional = new SsiConditional();
        this.commands.put("if", ssiConditional);
        this.commands.put("elif", ssiConditional);
        this.commands.put("endif", ssiConditional);
        this.commands.put("else", ssiConditional);
    }

    /*
     * WARNING - void declaration
     */
    public long process(@NotNull SsiExternalResolver ssiExternalResolver, @NotNull String fileContents, long lastModifiedDate, @NotNull ByteBufUtf8Writer byteBufUtf8Writer) {
        if (ssiExternalResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ssiExternalResolver", "org/jetbrains/builtInWebServer/ssi/SsiProcessor", "process"));
        }
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "org/jetbrains/builtInWebServer/ssi/SsiProcessor", "process"));
        }
        if (byteBufUtf8Writer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/builtInWebServer/ssi/SsiProcessor", "process"));
        }
        SsiProcessingState ssiProcessingState = new SsiProcessingState(ssiExternalResolver, lastModifiedDate);
        int index = 0;
        boolean inside = false;
        StringBuilder command = new StringBuilder();
        try {
            while (index < fileContents.length()) {
                void writer;
                char c = fileContents.charAt(index);
                if (inside) {
                    if (c == COMMAND_END.charAt(0) && this.charCmp(fileContents, index, COMMAND_END)) {
                        long newLastModified;
                        inside = false;
                        index += COMMAND_END.length();
                        String commandName = this.parseCommand(command);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("SSIProcessor.process -- processing command: " + commandName);
                        }
                        List<String> paramNames = this.parseParamNames(command, commandName.length());
                        String[] paramValues = this.parseParamValues(command, commandName.length(), paramNames.size());
                        String configErrMsg = ssiProcessingState.configErrorMessage;
                        SsiCommand ssiCommand = this.commands.get(commandName.toLowerCase(Locale.ENGLISH));
                        String errorMessage = null;
                        if (ssiCommand == null) {
                            errorMessage = "Unknown command: " + commandName;
                        } else if (paramValues == null) {
                            errorMessage = "Error parsing directive parameters.";
                        } else if (paramNames.size() != paramValues.length) {
                            errorMessage = "Parameter names count does not match parameter values count on command: " + commandName;
                        } else if ((!ssiProcessingState.conditionalState.processConditionalCommandsOnly || ssiCommand instanceof SsiConditional) && (newLastModified = ssiCommand.process(ssiProcessingState, commandName, paramNames, paramValues, (ByteBufUtf8Writer)writer)) > lastModifiedDate) {
                            lastModifiedDate = newLastModified;
                        }
                        if (errorMessage == null) continue;
                        LOG.warn(errorMessage);
                        writer.write(configErrMsg);
                        continue;
                    }
                    command.append(c);
                    ++index;
                    continue;
                }
                if (c == COMMAND_START.charAt(0) && this.charCmp(fileContents, index, COMMAND_START)) {
                    inside = true;
                    index += COMMAND_START.length();
                    command.setLength(0);
                    continue;
                }
                if (!ssiProcessingState.conditionalState.processConditionalCommandsOnly) {
                    writer.write(c);
                }
                ++index;
            }
        }
        catch (SsiStopProcessingException e) {
            // empty catch block
        }
        return lastModifiedDate;
    }

    @NotNull
    protected List<String> parseParamNames(@NotNull StringBuilder command, int start) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/builtInWebServer/ssi/SsiProcessor", "parseParamNames"));
        }
        int bIdx = start;
        SmartList values = new SmartList();
        boolean inside = false;
        StringBuilder builder = new StringBuilder();
        while (bIdx < command.length()) {
            if (inside) {
                while (bIdx < command.length() && command.charAt(bIdx) != '=') {
                    builder.append(command.charAt(bIdx));
                    ++bIdx;
                }
                values.add(builder.toString());
                builder.setLength(0);
                inside = false;
                int quotes = 0;
                boolean escaped = false;
                while (bIdx < command.length() && quotes != 2) {
                    char c = command.charAt(bIdx);
                    if (c == '\\' && !escaped) {
                        escaped = true;
                    } else {
                        if (c == '\"' && !escaped) {
                            ++quotes;
                        }
                        escaped = false;
                    }
                    ++bIdx;
                }
                continue;
            }
            while (bIdx < command.length() && this.isSpace(command.charAt(bIdx))) {
                ++bIdx;
            }
            if (bIdx >= command.length()) break;
            inside = true;
        }
        SmartList smartList = values;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/ssi/SsiProcessor", "parseParamNames"));
        }
        return smartList;
    }

    protected String[] parseParamValues(@NotNull StringBuilder command, int start, int count) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/builtInWebServer/ssi/SsiProcessor", "parseParamValues"));
        }
        int valueIndex = 0;
        boolean inside = false;
        String[] values = new String[count];
        StringBuilder builder = new StringBuilder();
        char endQuote = '\u0000';
        for (int bIdx = start; bIdx < command.length(); ++bIdx) {
            if (!inside) {
                while (bIdx < command.length() && !this.isQuote(command.charAt(bIdx))) {
                    ++bIdx;
                }
                if (bIdx >= command.length()) break;
                inside = true;
                endQuote = command.charAt(bIdx);
                continue;
            }
            boolean escaped = false;
            while (bIdx < command.length()) {
                char c = command.charAt(bIdx);
                if (c == '\\' && !escaped) {
                    escaped = true;
                } else {
                    if (c == endQuote && !escaped) break;
                    if (c == '$' && escaped) {
                        builder.append('\\');
                    }
                    escaped = false;
                    builder.append(c);
                }
                ++bIdx;
            }
            if (bIdx == command.length()) {
                return null;
            }
            values[valueIndex++] = builder.toString();
            builder.setLength(0);
            inside = false;
        }
        return values;
    }

    @NotNull
    private String parseCommand(@NotNull StringBuilder instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/builtInWebServer/ssi/SsiProcessor", "parseCommand"));
        }
        int firstLetter = -1;
        int lastLetter = -1;
        for (int i = 0; i < instruction.length(); ++i) {
            char c = instruction.charAt(i);
            if (Character.isLetter(c)) {
                if (firstLetter == -1) {
                    firstLetter = i;
                }
                lastLetter = i;
                continue;
            }
            if (!this.isSpace(c) || lastLetter > -1) break;
        }
        String string = firstLetter == -1 ? "" : instruction.substring(firstLetter, lastLetter + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/ssi/SsiProcessor", "parseCommand"));
        }
        return string;
    }

    protected boolean charCmp(String buf, int index, String command) {
        return buf.regionMatches(index, command, 0, command.length());
    }

    protected boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    protected boolean isQuote(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }
}

