/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.PlatformUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

class AboutHttpService
extends RestService {
    AboutHttpService() {
    }

    @Override
    @NotNull
    protected String getServiceName() {
        if ("about" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/AboutHttpService", "getServiceName"));
        }
        return "about";
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/ide/AboutHttpService", "isMethodSupported"));
        }
        return method == HttpMethod.GET;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        String productName;
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/AboutHttpService", "execute"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/AboutHttpService", "execute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/AboutHttpService", "execute"));
        }
        BuildNumber build = ApplicationInfo.getInstance().getBuild();
        BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
        JsonWriter writer = AboutHttpService.createJsonWriter(byteOut);
        writer.beginObject();
        String appName = ApplicationInfoEx.getInstanceEx().getFullApplicationName();
        if (!PlatformUtils.isIdeaUltimate() && (appName = appName.replace((productName = ApplicationNamesInfo.getInstance().getProductName()) + " (" + productName + ")", productName)).startsWith("JetBrains ")) {
            appName = appName.substring("JetBrains ".length());
        }
        writer.name("name").value(appName);
        writer.name("productName").value(ApplicationNamesInfo.getInstance().getProductName());
        writer.name("baselineVersion").value((long)build.getBaselineVersion());
        if (build.getBuildNumber() != Integer.MAX_VALUE) {
            writer.name("buildNumber").value((long)build.getBuildNumber());
        }
        if (AboutHttpService.getBooleanParameter("registeredFileTypes", urlDecoder)) {
            writer.name("registeredFileTypes").beginArray();
            for (FileType fileType : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
                writer.beginObject();
                writer.name("name").value(fileType.getName());
                writer.name("description").value(fileType.getDescription());
                writer.name("isBinary").value(fileType.isBinary());
                writer.endObject();
            }
            writer.endArray();
        }
        writer.endObject();
        writer.close();
        AboutHttpService.send(byteOut, request, context);
        return null;
    }
}

