/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.ide.PowerSaveMode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.lang.UrlClassLoader;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.PowerSupplyKitCallback;

public class PowerSupplyKit {
    private static final String POWER_SUPPLY_GROUP_ID = "Power Supply Integration";
    private static boolean shouldCheckCordUnplug;
    private static boolean automaticallySwitchInPowerSaveModeOnUnpluggedCordEvent;
    private static boolean powerSupplyKitHasBeenInitialized;

    private static native void startListenPowerSupply(PowerSupplyKitCallback var0);

    private static native boolean isPlugged();

    private static native String[] getInfo();

    private static boolean hasDiscreteCard() {
        String[] models = PowerSupplyKit.getInfo();
        return models.length > 1;
    }

    public static void checkPowerSupply() {
        if (!shouldCheckCordUnplug) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                PowerSupplyKit.startListenPowerSupply(new PowerSupplyKitCallback(){

                    @Override
                    public void call() {
                        PowerSupplyKit.initializeIfNeeded();
                        PowerSaveMode.setEnabled(automaticallySwitchInPowerSaveModeOnUnpluggedCordEvent && PowerSupplyKit.isPlugged());
                    }
                });
            }
        }.start();
        shouldCheckCordUnplug = false;
    }

    private static void initializeIfNeeded() {
        if (powerSupplyKitHasBeenInitialized) {
            return;
        }
        NotificationsConfiguration.getNotificationsConfiguration().register(POWER_SUPPLY_GROUP_ID, NotificationDisplayType.STICKY_BALLOON, false);
        NotificationType type = NotificationType.INFORMATION;
        NotificationListener listener = new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "org/jetbrains/io/PowerSupplyKit$2", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/io/PowerSupplyKit$2", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String description = event.getDescription();
                    if ("doNotShow".equals(description)) {
                        NotificationsConfiguration.getNotificationsConfiguration().changeSettings(PowerSupplyKit.POWER_SUPPLY_GROUP_ID, NotificationDisplayType.NONE, false, false);
                        notification.expire();
                    }
                    if ("automatically".equals(description)) {
                        automaticallySwitchInPowerSaveModeOnUnpluggedCordEvent = true;
                    }
                }
            }
        };
        String automaticPowerSafeModeSwitchMessage = "We have noticed that your computer power cord is disconnected. On unplugging your power cord we can <a href=\"automatically\">automatically</a> switch your Mac Book in a <b>Power Save</b> mode . This can extend your battery life. <a href=\"doNotShow\">Do no show</a> this message anymore";
        final Notification automaticPowerSafeModeSwitchNotification = new Notification(POWER_SUPPLY_GROUP_ID, "Automatically enable <b>Power Save</b> mode", "We have noticed that your computer power cord is disconnected. On unplugging your power cord we can <a href=\"automatically\">automatically</a> switch your Mac Book in a <b>Power Save</b> mode . This can extend your battery life. <a href=\"doNotShow\">Do no show</a> this message anymore", type, listener);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ((Notifications)ApplicationManager.getApplication().getMessageBus().syncPublisher(Notifications.TOPIC)).notify(automaticPowerSafeModeSwitchNotification);
            }
        });
        powerSupplyKitHasBeenInitialized = true;
    }

    static {
        boolean bl = shouldCheckCordUnplug = Registry.is((String)"check.power.supply.for.mbp") && SystemInfo.isMacIntel64;
        if (shouldCheckCordUnplug) {
            UrlClassLoader.loadPlatformLibrary((String)"MacNativeKit");
        }
    }
}

