/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

public class MavenProjectsTree {
    private static final Logger LOG = Logger.getInstance(MavenProjectsTree.class);
    private static final String STORAGE_VERSION = MavenProjectsTree.class.getSimpleName() + ".6";
    private final Object myStateLock = new Object();
    private final ReentrantReadWriteLock myStructureLock = new ReentrantReadWriteLock();
    private final Lock myStructureReadLock = this.myStructureLock.readLock();
    private final Lock myStructureWriteLock = this.myStructureLock.writeLock();
    private volatile Set<String> myManagedFilesPaths = new LinkedHashSet<String>();
    private volatile List<String> myIgnoredFilesPaths = new ArrayList<String>();
    private volatile List<String> myIgnoredFilesPatterns = new ArrayList<String>();
    private volatile Pattern myIgnoredFilesPatternsCache;
    private MavenExplicitProfiles myExplicitProfiles = MavenExplicitProfiles.NONE;
    private final MavenExplicitProfiles myTemporarilyRemovedExplicitProfiles = new MavenExplicitProfiles(new HashSet(), new HashSet());
    private final List<MavenProject> myRootProjects = new ArrayList<MavenProject>();
    private final Map<MavenProject, MavenProjectTimestamp> myTimestamps = new HashMap<MavenProject, MavenProjectTimestamp>();
    private final MavenWorkspaceMap myWorkspaceMap = new MavenWorkspaceMap();
    private final Map<MavenId, MavenProject> myMavenIdToProjectMapping = new HashMap<MavenId, MavenProject>();
    private final Map<VirtualFile, MavenProject> myVirtualFileToProjectMapping = new HashMap<VirtualFile, MavenProject>();
    private final Map<MavenProject, List<MavenProject>> myAggregatorToModuleMapping = new HashMap<MavenProject, List<MavenProject>>();
    private final Map<MavenProject, MavenProject> myModuleToAggregatorMapping = new HashMap<MavenProject, MavenProject>();
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final MavenProjectReaderProjectLocator myProjectLocator = new MavenProjectReaderProjectLocator(){

        @Override
        public VirtualFile findProjectFile(MavenId coordinates) {
            MavenProject project = MavenProjectsTree.this.findProject(coordinates);
            return project == null ? null : project.getFile();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static MavenProjectsTree read(File file) throws IOException {
        MavenProjectsTree result = new MavenProjectsTree();
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            if (!STORAGE_VERSION.equals(in.readUTF())) {
                MavenProjectsTree mavenProjectsTree = null;
                return mavenProjectsTree;
            }
            try {
                result.myManagedFilesPaths = MavenProjectsTree.readCollection(in, new LinkedHashSet());
                result.myIgnoredFilesPaths = MavenProjectsTree.readCollection(in, new ArrayList());
                result.myIgnoredFilesPatterns = MavenProjectsTree.readCollection(in, new ArrayList());
                result.myExplicitProfiles = new MavenExplicitProfiles((Collection)MavenProjectsTree.readCollection(in, new THashSet()), (Collection)MavenProjectsTree.readCollection(in, new THashSet()));
                result.myRootProjects.addAll(MavenProjectsTree.readProjectsRecursively(in, result));
            }
            catch (IOException e) {
                in.close();
                file.delete();
                throw e;
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    private static <T extends Collection<String>> T readCollection(DataInputStream in, T result) throws IOException {
        int count = in.readInt();
        while (count-- > 0) {
            result.add((String)in.readUTF());
        }
        return result;
    }

    private static void writeCollection(DataOutputStream out, Collection<String> list) throws IOException {
        out.writeInt(list.size());
        for (String each : list) {
            out.writeUTF(each);
        }
    }

    private static List<MavenProject> readProjectsRecursively(DataInputStream in, MavenProjectsTree tree) throws IOException {
        int count = in.readInt();
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(count);
        while (count-- > 0) {
            MavenProject project = MavenProject.read(in);
            MavenProjectTimestamp timestamp = MavenProjectTimestamp.read(in);
            List<MavenProject> modules = MavenProjectsTree.readProjectsRecursively(in, tree);
            if (project == null) continue;
            result.add(project);
            tree.myTimestamps.put(project, timestamp);
            tree.myVirtualFileToProjectMapping.put(project.getFile(), project);
            tree.fillIDMaps(project);
            tree.myAggregatorToModuleMapping.put(project, modules);
            for (MavenProject eachModule : modules) {
                tree.myModuleToAggregatorMapping.put(eachModule, project);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        Object object = this.myStateLock;
        synchronized (object) {
            this.readLock();
            try {
                file.getParentFile().mkdirs();
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                try {
                    out.writeUTF(STORAGE_VERSION);
                    MavenProjectsTree.writeCollection(out, this.myManagedFilesPaths);
                    MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPaths);
                    MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPatterns);
                    MavenProjectsTree.writeCollection(out, this.myExplicitProfiles.getEnabledProfiles());
                    MavenProjectsTree.writeCollection(out, this.myExplicitProfiles.getDisabledProfiles());
                    this.writeProjectsRecursively(out, this.myRootProjects);
                }
                finally {
                    out.close();
                }
            }
            finally {
                this.readUnlock();
            }
        }
    }

    private void writeProjectsRecursively(DataOutputStream out, List<MavenProject> list) throws IOException {
        out.writeInt(list.size());
        for (MavenProject each : list) {
            each.write(out);
            this.myTimestamps.get(each).write(out);
            this.writeProjectsRecursively(out, this.getModules(each));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getManagedFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myManagedFilesPaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetManagedFilesPathsAndProfiles(List<String> paths, MavenExplicitProfiles profiles) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths = new LinkedHashSet<String>(paths);
        }
        this.setExplicitProfiles(profiles);
    }

    public void resetManagedFilesAndProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles) {
        this.resetManagedFilesPathsAndProfiles(MavenUtil.collectPaths(files), profiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedFilesWithProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles) {
        MavenExplicitProfiles newProfiles;
        ArrayList<String> newFiles;
        Object object = this.myStateLock;
        synchronized (object) {
            newFiles = new ArrayList<String>(this.myManagedFilesPaths);
            newFiles.addAll(MavenUtil.collectPaths(files));
            newProfiles = this.myExplicitProfiles.clone();
            newProfiles.getEnabledProfiles().addAll(profiles.getEnabledProfiles());
            newProfiles.getDisabledProfiles().addAll(profiles.getDisabledProfiles());
        }
        this.resetManagedFilesPathsAndProfiles(newFiles, newProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedFiles(List<VirtualFile> files) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths.removeAll(MavenUtil.collectPaths(files));
        }
    }

    public List<VirtualFile> getExistingManagedFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : this.getManagedFilesPaths()) {
            VirtualFile f = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPaths);
        }
    }

    public void setIgnoredFilesPaths(final List<String> paths) {
        this.doChangeIgnoreStatus(new Runnable(){

            @Override
            public void run() {
                MavenProjectsTree.this.myIgnoredFilesPaths = new ArrayList(paths);
            }
        });
    }

    public void removeIgnoredFilesPaths(final Collection<String> paths) {
        this.doChangeIgnoreStatus(new Runnable(){

            @Override
            public void run() {
                MavenProjectsTree.this.myIgnoredFilesPaths.removeAll(paths);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIgnoredState(MavenProject project) {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(project.getPath());
        }
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored) {
        this.setIgnoredState(projects, ignored, false);
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored, boolean fromImport) {
        this.doSetIgnoredState(projects, ignored, fromImport);
    }

    private void doSetIgnoredState(List<MavenProject> projects, final boolean ignored, boolean fromImport) {
        final List<String> paths = MavenUtil.collectPaths(MavenUtil.collectFiles(projects));
        this.doChangeIgnoreStatus(new Runnable(){

            @Override
            public void run() {
                if (ignored) {
                    MavenProjectsTree.this.myIgnoredFilesPaths.addAll(paths);
                } else {
                    MavenProjectsTree.this.myIgnoredFilesPaths.removeAll(paths);
                }
            }
        }, fromImport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPatterns() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPatterns);
        }
    }

    public void setIgnoredFilesPatterns(final List<String> patterns) {
        this.doChangeIgnoreStatus(new Runnable(){

            @Override
            public void run() {
                MavenProjectsTree.this.myIgnoredFilesPatternsCache = null;
                MavenProjectsTree.this.myIgnoredFilesPatterns = new ArrayList(patterns);
            }
        });
    }

    private void doChangeIgnoreStatus(Runnable runnable) {
        this.doChangeIgnoreStatus(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeIgnoreStatus(Runnable runnable, boolean fromImport) {
        List<MavenProject> ignoredAfter;
        List<MavenProject> ignoredBefore;
        Object object = this.myStateLock;
        synchronized (object) {
            ignoredBefore = this.getIgnoredProjects();
            runnable.run();
            ignoredAfter = this.getIgnoredProjects();
        }
        ArrayList<MavenProject> ignored = new ArrayList<MavenProject>(ignoredAfter);
        ignored.removeAll(ignoredBefore);
        ArrayList<MavenProject> unignored = new ArrayList<MavenProject>(ignoredBefore);
        unignored.removeAll(ignoredAfter);
        if (ignored.isEmpty() && unignored.isEmpty()) {
            return;
        }
        this.fireProjectsIgnoredStateChanged(ignored, unignored, fromImport);
    }

    private List<MavenProject> getIgnoredProjects() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject each : this.getProjects()) {
            if (!this.isIgnored(each)) continue;
            result.add(each);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnored(MavenProject project) {
        String path = project.getPath();
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(path) || this.matchesIgnoredFilesPatterns(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesIgnoredFilesPatterns(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            if (this.myIgnoredFilesPatternsCache == null) {
                this.myIgnoredFilesPatternsCache = Pattern.compile(Strings.translateMasks(this.myIgnoredFilesPatterns));
            }
            return this.myIgnoredFilesPatternsCache.matcher(path).matches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExplicitProfiles getExplicitProfiles() {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myExplicitProfiles.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitProfiles(MavenExplicitProfiles explicitProfiles) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myExplicitProfiles = explicitProfiles.clone();
        }
        this.fireProfilesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExplicitProfiles() {
        Collection<String> available = this.getAvailableProfiles();
        Object object = this.myStateLock;
        synchronized (object) {
            this.updateExplicitProfiles(this.myExplicitProfiles.getEnabledProfiles(), this.myTemporarilyRemovedExplicitProfiles.getEnabledProfiles(), available);
            this.updateExplicitProfiles(this.myExplicitProfiles.getDisabledProfiles(), this.myTemporarilyRemovedExplicitProfiles.getDisabledProfiles(), available);
        }
    }

    private void updateExplicitProfiles(Collection<String> explicitProfiles, Collection<String> temporarilyRemovedExplicitProfiles, Collection<String> available) {
        THashSet removedProfiles = new THashSet(explicitProfiles);
        removedProfiles.removeAll(available);
        temporarilyRemovedExplicitProfiles.addAll((Collection<String>)removedProfiles);
        THashSet restoredProfiles = new THashSet(temporarilyRemovedExplicitProfiles);
        restoredProfiles.retainAll(available);
        temporarilyRemovedExplicitProfiles.removeAll((Collection<?>)restoredProfiles);
        explicitProfiles.removeAll((Collection<?>)removedProfiles);
        explicitProfiles.addAll((Collection<String>)restoredProfiles);
    }

    public Collection<String> getAvailableProfiles() {
        THashSet res = new THashSet();
        for (MavenProject each : this.getProjects()) {
            res.addAll(each.getProfilesIds());
        }
        return res;
    }

    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        ArrayListSet result = new ArrayListSet();
        THashSet available = new THashSet();
        THashSet active = new THashSet();
        for (MavenProject each : this.getProjects()) {
            available.addAll(each.getProfilesIds());
            active.addAll(each.getActivatedProfilesIds().getEnabledProfiles());
        }
        Collection enabledProfiles = this.getExplicitProfiles().getEnabledProfiles();
        Collection disabledProfiles = this.getExplicitProfiles().getDisabledProfiles();
        for (String each : available) {
            MavenProfileKind state = disabledProfiles.contains(each) ? MavenProfileKind.NONE : (enabledProfiles.contains(each) ? MavenProfileKind.EXPLICIT : (active.contains(each) ? MavenProfileKind.IMPLICIT : MavenProfileKind.NONE));
            result.add(Pair.create((Object)each, (Object)state));
        }
        return result;
    }

    public void updateAll(boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        List<VirtualFile> managedFiles = this.getExistingManagedFiles();
        MavenExplicitProfiles explicitProfiles = this.getExplicitProfiles();
        MavenProjectReader projectReader = new MavenProjectReader();
        this.update(managedFiles, true, force, explicitProfiles, projectReader, generalSettings, process);
        List<VirtualFile> obsoleteFiles = this.getRootProjectsFiles();
        obsoleteFiles.removeAll(managedFiles);
        this.delete(projectReader, obsoleteFiles, explicitProfiles, generalSettings, process);
    }

    public void update(Collection<VirtualFile> files, boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        this.update(files, false, force, this.getExplicitProfiles(), new MavenProjectReader(), generalSettings, process);
    }

    private void update(Collection<VirtualFile> files, boolean recursive, boolean force, MavenExplicitProfiles explicitProfiles, MavenProjectReader projectReader, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        if (files.isEmpty()) {
            return;
        }
        UpdateContext updateContext = new UpdateContext();
        Stack updateStack = new Stack();
        for (VirtualFile each : files) {
            MavenProject mavenProject = this.findProject(each);
            if (mavenProject == null) {
                this.doAdd(each, recursive, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process);
                continue;
            }
            this.doUpdate(mavenProject, this.findAggregator(mavenProject), false, recursive, force, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary();
    }

    private void doAdd(VirtualFile f, boolean recursuve, MavenExplicitProfiles explicitProfiles, UpdateContext updateContext, Stack<MavenProject> updateStack, MavenProjectReader reader, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        MavenProject newMavenProject = new MavenProject(f);
        MavenProject intendedAggregator = null;
        for (MavenProject each : this.getProjects()) {
            if (!each.getExistingModuleFiles().contains(f)) continue;
            intendedAggregator = each;
            break;
        }
        this.doUpdate(newMavenProject, intendedAggregator, true, recursuve, false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(MavenProject mavenProject, MavenProject aggregator, boolean isNew, boolean recursive, boolean force, MavenExplicitProfiles explicitProfiles, UpdateContext updateContext, Stack<MavenProject> updateStack, MavenProjectReader reader, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        MavenProjectChanges changes;
        if (updateStack.contains((Object)mavenProject)) {
            MavenLog.LOG.info("Recursion detected in " + mavenProject.getFile());
            return;
        }
        updateStack.push((Object)mavenProject);
        process.setText(ProjectBundle.message("maven.reading.pom", mavenProject.getPath()));
        process.setText2("");
        List<MavenProject> prevModules = this.getModules(mavenProject);
        HashSet<MavenProject> prevInheritors = new HashSet<MavenProject>();
        if (!isNew) {
            prevInheritors.addAll(this.findInheritors(mavenProject));
        }
        MavenProjectTimestamp timestamp = this.calculateTimestamp(mavenProject, explicitProfiles, generalSettings);
        boolean isChanged = force || !timestamp.equals(this.myTimestamps.get(mavenProject));
        MavenProjectChanges mavenProjectChanges = changes = force ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
        if (isChanged) {
            this.writeLock();
            try {
                if (!isNew) {
                    this.clearIDMaps(mavenProject);
                }
            }
            finally {
                this.writeUnlock();
            }
            MavenId oldParentId = mavenProject.getParentId();
            changes = changes.mergedWith(mavenProject.read(generalSettings, explicitProfiles, reader, this.myProjectLocator));
            this.writeLock();
            try {
                this.myVirtualFileToProjectMapping.put(mavenProject.getFile(), mavenProject);
                this.fillIDMaps(mavenProject);
            }
            finally {
                this.writeUnlock();
            }
            if (!Comparing.equal((Object)oldParentId, (Object)mavenProject.getParentId())) {
                timestamp = this.calculateTimestamp(mavenProject, explicitProfiles, generalSettings);
            }
            this.myTimestamps.put(mavenProject, timestamp);
        }
        boolean reconnected = isNew;
        if (isNew) {
            this.connect(aggregator, mavenProject);
        } else {
            reconnected = this.reconnect(aggregator, mavenProject);
        }
        if (isChanged || reconnected) {
            updateContext.update(mavenProject, changes);
        }
        List<VirtualFile> existingModuleFiles = mavenProject.getExistingModuleFiles();
        ArrayList<MavenProject> modulesToRemove = new ArrayList<MavenProject>();
        ArrayList<MavenProject> modulesToBecomeRoots = new ArrayList<MavenProject>();
        for (MavenProject mavenProject2 : prevModules) {
            VirtualFile moduleFile = mavenProject2.getFile();
            if (existingModuleFiles.contains(moduleFile)) continue;
            if (this.isManagedFile(moduleFile)) {
                modulesToBecomeRoots.add(mavenProject2);
                continue;
            }
            modulesToRemove.add(mavenProject2);
        }
        for (MavenProject mavenProject3 : modulesToRemove) {
            this.removeModule(mavenProject, mavenProject3);
            this.doDelete(mavenProject, mavenProject3, updateContext);
            prevInheritors.removeAll(updateContext.deletedProjects);
        }
        for (MavenProject mavenProject4 : modulesToBecomeRoots) {
            if (!this.reconnect(null, mavenProject4)) continue;
            updateContext.update(mavenProject4, MavenProjectChanges.NONE);
        }
        for (VirtualFile virtualFile : existingModuleFiles) {
            boolean isNewModule;
            MavenProject module = this.findProject(virtualFile);
            boolean bl = isNewModule = module == null;
            if (isNewModule) {
                module = new MavenProject(virtualFile);
            } else {
                MavenProject currentAggregator = this.findAggregator(module);
                if (currentAggregator != null && currentAggregator != mavenProject) {
                    MavenLog.LOG.info("Module " + virtualFile + " is already included into " + mavenProject.getFile());
                    continue;
                }
            }
            if (isChanged || isNewModule || recursive) {
                this.doUpdate(module, mavenProject, isNewModule, recursive, recursive ? force : false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process);
                continue;
            }
            if (!this.reconnect(mavenProject, module)) continue;
            updateContext.update(module, MavenProjectChanges.NONE);
        }
        prevInheritors.addAll(this.findInheritors(mavenProject));
        for (MavenProject mavenProject5 : prevInheritors) {
            this.doUpdate(mavenProject5, this.findAggregator(mavenProject5), false, false, false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process);
        }
        updateStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenProjectTimestamp calculateTimestamp(MavenProject mavenProject, MavenExplicitProfiles explicitProfiles, MavenGeneralSettings generalSettings) {
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            long pomTimestamp = MavenProjectsTree.getFileTimestamp(mavenProject.getFile());
            MavenProject parent = this.findParent(mavenProject);
            long parentLastReadStamp = parent == null ? -1L : parent.getLastReadStamp();
            VirtualFile profilesXmlFile = mavenProject.getProfilesXmlFile();
            long profilesTimestamp = MavenProjectsTree.getFileTimestamp(profilesXmlFile);
            long userSettingsTimestamp = MavenProjectsTree.getFileTimestamp(generalSettings.getEffectiveUserSettingsFile());
            long globalSettingsTimestamp = MavenProjectsTree.getFileTimestamp(generalSettings.getEffectiveGlobalSettingsFile());
            int profilesHashCode = explicitProfiles.hashCode();
            MavenProjectTimestamp mavenProjectTimestamp = new MavenProjectTimestamp(pomTimestamp, parentLastReadStamp, profilesTimestamp, userSettingsTimestamp, globalSettingsTimestamp, profilesHashCode);
            return mavenProjectTimestamp;
        }
        finally {
            accessToken.finish();
        }
    }

    private static long getFileTimestamp(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return -1L;
        }
        return file.getTimeStamp();
    }

    public boolean isManagedFile(VirtualFile moduleFile) {
        return this.isManagedFile(moduleFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManagedFile(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            for (String each : this.myManagedFilesPaths) {
                if (!FileUtil.pathsEqual((String)each, (String)path)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isPotentialProject(String path) {
        if (this.isManagedFile(path)) {
            return true;
        }
        for (MavenProject each : this.getProjects()) {
            if (FileUtil.pathsEqual((String)path, (String)each.getPath())) {
                return true;
            }
            if (!each.getModulePaths().contains(path)) continue;
            return true;
        }
        return false;
    }

    public void delete(List<VirtualFile> files, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        this.delete(new MavenProjectReader(), files, this.getExplicitProfiles(), generalSettings, process);
    }

    private void delete(MavenProjectReader projectReader, List<VirtualFile> files, MavenExplicitProfiles explicitProfiles, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        if (files.isEmpty()) {
            return;
        }
        UpdateContext updateContext = new UpdateContext();
        Stack updateStack = new Stack();
        THashSet inheritorsToUpdate = new THashSet();
        for (Object each : files) {
            MavenProject mavenProject = this.findProject((VirtualFile)each);
            if (mavenProject == null) {
                return;
            }
            inheritorsToUpdate.addAll(this.findInheritors(mavenProject));
            this.doDelete(this.findAggregator(mavenProject), mavenProject, updateContext);
        }
        inheritorsToUpdate.removeAll(updateContext.deletedProjects);
        for (Object each : inheritorsToUpdate) {
            this.doUpdate((MavenProject)each, null, false, false, false, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(MavenProject aggregator, MavenProject project, UpdateContext updateContext) {
        for (MavenProject each : this.getModules(project)) {
            if (this.isManagedFile(each.getPath())) {
                if (!this.reconnect(null, each)) continue;
                updateContext.update(each, MavenProjectChanges.NONE);
                continue;
            }
            this.doDelete(project, each, updateContext);
        }
        this.writeLock();
        try {
            if (aggregator != null) {
                this.removeModule(aggregator, project);
            } else {
                this.myRootProjects.remove(project);
            }
            this.myTimestamps.remove(project);
            this.myVirtualFileToProjectMapping.remove(project.getFile());
            this.clearIDMaps(project);
            this.myAggregatorToModuleMapping.remove(project);
            this.myModuleToAggregatorMapping.remove(project);
        }
        finally {
            this.writeUnlock();
        }
        updateContext.deleted(project);
    }

    private void fillIDMaps(MavenProject mavenProject) {
        MavenId id = mavenProject.getMavenId();
        this.myWorkspaceMap.register(id, new File(mavenProject.getFile().getPath()));
        this.myMavenIdToProjectMapping.put(id, mavenProject);
    }

    private void clearIDMaps(MavenProject mavenProject) {
        MavenId id = mavenProject.getMavenId();
        this.myWorkspaceMap.unregister(id);
        this.myMavenIdToProjectMapping.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(MavenProject newAggregator, MavenProject project) {
        this.writeLock();
        try {
            if (newAggregator != null) {
                this.addModule(newAggregator, project);
            } else {
                this.myRootProjects.add(project);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconnect(MavenProject newAggregator, MavenProject project) {
        MavenProject prevAggregator = this.findAggregator(project);
        if (prevAggregator == newAggregator) {
            return false;
        }
        this.writeLock();
        try {
            if (prevAggregator != null) {
                this.removeModule(prevAggregator, project);
            } else {
                this.myRootProjects.remove(project);
            }
            if (newAggregator != null) {
                this.addModule(newAggregator, project);
            } else {
                this.myRootProjects.add(project);
            }
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProjects() {
        this.readLock();
        try {
            boolean bl = !this.myRootProjects.isEmpty();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getRootProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>(this.myRootProjects);
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private static void updateCrc(CRC32 crc, int x) {
        crc.update(x & 0xFF);
        crc.update((x >>>= 8) & 0xFF);
        crc.update((x >>>= 8) & 0xFF);
        crc.update(x >>>= 8);
    }

    private static void updateCrc(CRC32 crc, long l) {
        MavenProjectsTree.updateCrc(crc, (int)l);
        MavenProjectsTree.updateCrc(crc, (int)(l >>> 32));
    }

    private static void updateCrc(CRC32 crc, @Nullable String s) {
        if (s == null) {
            crc.update(111);
        } else {
            MavenProjectsTree.updateCrc(crc, s.hashCode());
            crc.update(s.length() & 0xFF);
        }
    }

    @NotNull
    public static Collection<String> getFilterExclusions(MavenProject mavenProject) {
        Element config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (config == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsTree", "getFilterExclusions"));
            }
            return set;
        }
        List<String> customNonFilteredExtensions = MavenJDOMUtil.findChildrenValuesByPath(config, "nonFilteredFileExtensions", "nonFilteredFileExtension");
        if (customNonFilteredExtensions.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsTree", "getFilterExclusions"));
            }
            return set;
        }
        Collection<String> collection = Collections.unmodifiableCollection(customNonFilteredExtensions);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/project/MavenProjectsTree", "getFilterExclusions"));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilterConfigCrc(ProjectFileIndex fileIndex) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.readLock();
        try {
            final CRC32 crc = new CRC32();
            MavenExplicitProfiles profiles = this.myExplicitProfiles;
            if (profiles != null) {
                MavenProjectsTree.updateCrc(crc, profiles.hashCode());
            }
            Collection<MavenProject> allProjects = this.myVirtualFileToProjectMapping.values();
            crc.update(allProjects.size() & 0xFF);
            for (MavenProject mavenProject : allProjects) {
                VirtualFile pomFile = mavenProject.getFile();
                Module module = fileIndex.getModuleForFile(pomFile);
                if (module == null || !Comparing.equal((Object)fileIndex.getContentRootForFile(pomFile), (Object)pomFile.getParent())) continue;
                MavenProjectsTree.updateCrc(crc, module.getName());
                MavenId mavenId = mavenProject.getMavenId();
                MavenProjectsTree.updateCrc(crc, mavenId.getGroupId());
                MavenProjectsTree.updateCrc(crc, mavenId.getArtifactId());
                MavenProjectsTree.updateCrc(crc, mavenId.getVersion());
                MavenId parentId = mavenProject.getParentId();
                if (parentId != null) {
                    MavenProjectsTree.updateCrc(crc, parentId.getGroupId());
                    MavenProjectsTree.updateCrc(crc, parentId.getArtifactId());
                    MavenProjectsTree.updateCrc(crc, parentId.getVersion());
                }
                MavenProjectsTree.updateCrc(crc, mavenProject.getDirectory());
                MavenProjectsTree.updateCrc(crc, MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject).pattern());
                MavenProjectsTree.updateCrc(crc, ((Object)mavenProject.getModelMap()).hashCode());
                MavenProjectsTree.updateCrc(crc, ((Object)mavenProject.getResources()).hashCode());
                MavenProjectsTree.updateCrc(crc, ((Object)mavenProject.getTestResources()).hashCode());
                MavenProjectsTree.updateCrc(crc, ((Object)MavenProjectsTree.getFilterExclusions(mavenProject)).hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject.getProperties().hashCode());
                for (String each : mavenProject.getFilterPropertiesFiles()) {
                    File file = new File(each);
                    MavenProjectsTree.updateCrc(crc, file.lastModified());
                }
                XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
                Writer crcWriter = new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        int end = off + len;
                        for (int i = off; i < end; ++i) {
                            crc.update(cbuf[i]);
                        }
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                    }
                };
                try {
                    Element warPluginCfg;
                    Element resourcePluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
                    if (resourcePluginCfg != null) {
                        outputter.output(resourcePluginCfg, crcWriter);
                    }
                    if ((warPluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin")) == null) continue;
                    outputter.output(warPluginCfg, crcWriter);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            int n = (int)crc.getValue();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<VirtualFile> getRootProjectsFiles() {
        return MavenUtil.collectFiles(this.getRootProjects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>(this.myVirtualFileToProjectMapping.values());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getNonIgnoredProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> result = new ArrayList<MavenProject>();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (this.isIgnored(each)) continue;
                result.add(each);
            }
            ArrayList<MavenProject> arrayList = result;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VirtualFile> getProjectsFiles() {
        this.readLock();
        try {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myVirtualFileToProjectMapping.keySet());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MavenProject findProject(VirtualFile f) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myVirtualFileToProjectMapping.get(f);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MavenProject findProject(MavenId id) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myMavenIdToProjectMapping.get(id);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    @Nullable
    public MavenProject findProject(MavenArtifact artifact) {
        return this.findProject(artifact.getMavenId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenWorkspaceMap getWorkspaceMap() {
        this.readLock();
        try {
            MavenWorkspaceMap mavenWorkspaceMap = this.myWorkspaceMap.copy();
            return mavenWorkspaceMap;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProject findAggregator(MavenProject project) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myModuleToAggregatorMapping.get(project);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    public MavenProject findRootProject(@NotNull MavenProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsTree", "findRootProject"));
        }
        this.readLock();
        try {
            MavenProject rootProject = project;
            while (true) {
                MavenProject aggregator;
                if ((aggregator = this.myModuleToAggregatorMapping.get(rootProject)) == null) {
                    MavenProject mavenProject = rootProject;
                    return mavenProject;
                }
                rootProject = aggregator;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRootProject(@NotNull MavenProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsTree", "isRootProject"));
        }
        this.readLock();
        try {
            boolean bl = this.myModuleToAggregatorMapping.get(project) == null;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getModules(MavenProject aggregator) {
        this.readLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            ArrayList<MavenProject> arrayList = modules == null ? Collections.emptyList() : new ArrayList<MavenProject>(modules);
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModule(MavenProject aggregator, MavenProject module) {
        this.writeLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules == null) {
                modules = new ArrayList<MavenProject>();
                this.myAggregatorToModuleMapping.put(aggregator, modules);
            }
            modules.add(module);
            this.myModuleToAggregatorMapping.put(module, aggregator);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModule(MavenProject aggregator, MavenProject module) {
        this.writeLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules == null) {
                return;
            }
            modules.remove(module);
            this.myModuleToAggregatorMapping.remove(module);
        }
        finally {
            this.writeUnlock();
        }
    }

    private MavenProject findParent(MavenProject project) {
        return this.findProject(project.getParentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MavenProject> findInheritors(MavenProject project) {
        this.readLock();
        try {
            ArrayList<MavenProject> result = null;
            MavenId id = project.getMavenId();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (each == project || !id.equals((Object)each.getParentId())) continue;
                if (result == null) {
                    result = new ArrayList<MavenProject>();
                }
                result.add(each);
            }
            List<MavenProject> list = result == null ? Collections.emptyList() : result;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getDependentProjects(Collection<MavenProject> projects) {
        this.readLock();
        try {
            ArrayList<MavenProject> result = null;
            THashSet projectIds = new THashSet((TObjectHashingStrategy)new MavenCoordinateHashCodeStrategy());
            for (MavenProject project : projects) {
                projectIds.add(project.getMavenId());
            }
            THashSet projectPaths = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (MavenProject project : projects) {
                projectPaths.add(new File(project.getFile().getPath()));
            }
            for (MavenProject project : this.myVirtualFileToProjectMapping.values()) {
                boolean isDependent = false;
                Set<String> pathsInStack = project.getModulePaths();
                for (String path : pathsInStack) {
                    if (!projectPaths.contains(new File(path))) continue;
                    isDependent = true;
                    break;
                }
                if (!isDependent) {
                    for (MavenArtifact dep : project.getDependencies()) {
                        if (!projectIds.contains(dep)) continue;
                        isDependent = true;
                        break;
                    }
                }
                if (!isDependent) continue;
                if (result == null) {
                    result = new ArrayList<MavenProject>();
                }
                result.add(project);
            }
            List<MavenProject> list = result == null ? Collections.emptyList() : result;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public void resolve(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull MavenProgressIndicator process) throws MavenProcessCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (generalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalSettings", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (embeddersManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embeddersManager", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        this.resolve(project, mavenProject, generalSettings, embeddersManager, console, new ResolveContext(), process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull ResolveContext context, @NotNull MavenProgressIndicator process) throws MavenProcessCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (generalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalSettings", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (embeddersManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embeddersManager", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolve"));
        }
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_DEPENDENCIES_RESOLVE);
        embedder.customizeForResolve(this.getWorkspaceMap(), console, process, generalSettings.isAlwaysUpdateSnapshots());
        try {
            process.checkCanceled();
            process.setText(ProjectBundle.message("maven.resolving.pom", mavenProject.getDisplayName()));
            process.setText2("");
            Pair<MavenProjectChanges, NativeMavenProjectHolder> resolveResult = mavenProject.resolve(project, generalSettings, embedder, new MavenProjectReader(), this.myProjectLocator, context);
            this.fireProjectResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProject, (Object)resolveResult.first), (NativeMavenProjectHolder)resolveResult.second);
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolvePlugins(@NotNull MavenProject mavenProject, @NotNull NativeMavenProjectHolder nativeMavenProject, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull MavenProgressIndicator process) throws MavenProcessCanceledException {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolvePlugins"));
        }
        if (nativeMavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeMavenProject", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolvePlugins"));
        }
        if (embeddersManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embeddersManager", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolvePlugins"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolvePlugins"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolvePlugins"));
        }
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_PLUGINS_RESOLVE);
        embedder.customizeForResolve(console, process);
        embedder.clearCachesFor(mavenProject.getMavenId());
        HashSet<File> filesToRefresh = new HashSet<File>();
        try {
            process.setText(ProjectBundle.message("maven.downloading.pom.plugins", mavenProject.getDisplayName()));
            for (MavenPlugin each : mavenProject.getDeclaredPlugins()) {
                process.checkCanceled();
                Collection<MavenArtifact> artifacts = embedder.resolvePlugin(each, mavenProject.getRemoteRepositories(), nativeMavenProject, false);
                for (MavenArtifact artifact : artifacts) {
                    File pluginJar = artifact.getFile();
                    File pluginDir = pluginJar.getParentFile();
                    if (pluginDir == null) continue;
                    filesToRefresh.add(pluginDir);
                }
            }
            mavenProject.resetCache();
            this.firePluginsResolved(mavenProject);
        }
        finally {
            if (filesToRefresh.size() > 0) {
                LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
            }
            embeddersManager.release(embedder);
        }
    }

    public void resolveFolders(final @NotNull MavenProject mavenProject, final @NotNull MavenImportingSettings importingSettings, @NotNull MavenEmbeddersManager embeddersManager, final @NotNull MavenConsole console, final @NotNull MavenProgressIndicator process) throws MavenProcessCanceledException {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolveFolders"));
        }
        if (importingSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importingSettings", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolveFolders"));
        }
        if (embeddersManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embeddersManager", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolveFolders"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolveFolders"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/maven/project/MavenProjectsTree", "resolveFolders"));
        }
        this.executeWithEmbedder(mavenProject, embeddersManager, MavenEmbeddersManager.FOR_FOLDERS_RESOLVE, console, process, new EmbedderTask(){

            @Override
            public void run(MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
                process.checkCanceled();
                process.setText(ProjectBundle.message("maven.updating.folders.pom", mavenProject.getDisplayName()));
                process.setText2("");
                Pair<Boolean, MavenProjectChanges> resolveResult = mavenProject.resolveFolders(embedder, importingSettings, console);
                if (((Boolean)resolveResult.first).booleanValue()) {
                    MavenProjectsTree.this.fireFoldersResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProject, (Object)resolveResult.second));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenArtifactDownloader.DownloadResult downloadSourcesAndJavadocs(@NotNull Project project, @NotNull Collection<MavenProject> projects, @Nullable Collection<MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull MavenProgressIndicator process) throws MavenProcessCanceledException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/project/MavenProjectsTree", "downloadSourcesAndJavadocs"));
        }
        if (projects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projects", "org/jetbrains/idea/maven/project/MavenProjectsTree", "downloadSourcesAndJavadocs"));
        }
        if (embeddersManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embeddersManager", "org/jetbrains/idea/maven/project/MavenProjectsTree", "downloadSourcesAndJavadocs"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/project/MavenProjectsTree", "downloadSourcesAndJavadocs"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/maven/project/MavenProjectsTree", "downloadSourcesAndJavadocs"));
        }
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_DOWNLOAD);
        embedder.customizeForResolve(console, process);
        try {
            MavenArtifactDownloader.DownloadResult result = MavenArtifactDownloader.download(project, this, projects, artifacts, downloadSources, downloadDocs, embedder, process);
            for (MavenProject each : projects) {
                this.fireArtifactsDownloaded(each);
            }
            MavenArtifactDownloader.DownloadResult downloadResult = result;
            return downloadResult;
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithEmbedder(@NotNull MavenProject mavenProject, @NotNull MavenEmbeddersManager embeddersManager, @NotNull Key embedderKind, @NotNull MavenConsole console, @NotNull MavenProgressIndicator process, @NotNull EmbedderTask task) throws MavenProcessCanceledException {
        if (mavenProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/project/MavenProjectsTree", "executeWithEmbedder"));
        }
        if (embeddersManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embeddersManager", "org/jetbrains/idea/maven/project/MavenProjectsTree", "executeWithEmbedder"));
        }
        if (embedderKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embedderKind", "org/jetbrains/idea/maven/project/MavenProjectsTree", "executeWithEmbedder"));
        }
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "org/jetbrains/idea/maven/project/MavenProjectsTree", "executeWithEmbedder"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/idea/maven/project/MavenProjectsTree", "executeWithEmbedder"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/idea/maven/project/MavenProjectsTree", "executeWithEmbedder"));
        }
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(embedderKind);
        embedder.customizeForResolve(this.getWorkspaceMap(), console, process, false);
        embedder.clearCachesFor(mavenProject.getMavenId());
        try {
            task.run(embedder);
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    public <Result> Result visit(Visitor<Result> visitor) {
        for (MavenProject each : this.getRootProjects()) {
            if (visitor.isDone()) break;
            this.doVisit(each, visitor);
        }
        return visitor.getResult();
    }

    private <Result> void doVisit(MavenProject project, Visitor<Result> visitor) {
        if (!visitor.isDone() && visitor.shouldVisit(project)) {
            visitor.visit(project);
            for (MavenProject each : this.getModules(project)) {
                if (visitor.isDone()) break;
                this.doVisit(each, visitor);
            }
            visitor.leave(project);
        }
    }

    private void writeLock() {
        this.myStructureWriteLock.lock();
    }

    private void writeUnlock() {
        this.myStructureWriteLock.unlock();
    }

    private void readLock() {
        this.myStructureReadLock.lock();
    }

    private void readUnlock() {
        this.myStructureReadLock.unlock();
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    private void fireProfilesChanged() {
        for (Listener each : this.myListeners) {
            each.profilesChanged();
        }
    }

    private void fireProjectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, boolean fromImport) {
        for (Listener each : this.myListeners) {
            each.projectsIgnoredStateChanged(ignored, unignored, fromImport);
        }
    }

    private void fireProjectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
        for (Listener each : this.myListeners) {
            each.projectsUpdated(updated, deleted);
        }
    }

    private void fireProjectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
        for (Listener each : this.myListeners) {
            each.projectResolved(projectWithChanges, nativeMavenProject);
        }
    }

    private void firePluginsResolved(MavenProject project) {
        for (Listener each : this.myListeners) {
            each.pluginsResolved(project);
        }
    }

    private void fireFoldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        for (Listener each : this.myListeners) {
            each.foldersResolved(projectWithChanges);
        }
    }

    private void fireArtifactsDownloaded(MavenProject project) {
        for (Listener each : this.myListeners) {
            each.artifactsDownloaded(project);
        }
    }

    private static class MavenCoordinateHashCodeStrategy
    implements TObjectHashingStrategy<MavenCoordinate> {
        private MavenCoordinateHashCodeStrategy() {
        }

        public int computeHashCode(MavenCoordinate object) {
            String artifactId = object.getArtifactId();
            return artifactId == null ? 0 : artifactId.hashCode();
        }

        public boolean equals(MavenCoordinate o1, MavenCoordinate o2) {
            return Comparing.equal((String)o1.getArtifactId(), (String)o2.getArtifactId()) && Comparing.equal((String)o1.getVersion(), (String)o2.getVersion()) && Comparing.equal((String)o1.getGroupId(), (String)o2.getGroupId());
        }
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void profilesChanged() {
        }

        @Override
        public void projectsIgnoredStateChanged(List<MavenProject> ignored, List<MavenProject> unignored, boolean fromImport) {
        }

        @Override
        public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> updated, List<MavenProject> deleted) {
        }

        @Override
        public void projectResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
        }

        @Override
        public void pluginsResolved(MavenProject project) {
        }

        @Override
        public void foldersResolved(Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        }

        @Override
        public void artifactsDownloaded(MavenProject project) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void profilesChanged();

        public void projectsIgnoredStateChanged(List<MavenProject> var1, List<MavenProject> var2, boolean var3);

        public void projectsUpdated(List<Pair<MavenProject, MavenProjectChanges>> var1, List<MavenProject> var2);

        public void projectResolved(Pair<MavenProject, MavenProjectChanges> var1, @Nullable NativeMavenProjectHolder var2);

        public void pluginsResolved(MavenProject var1);

        public void foldersResolved(Pair<MavenProject, MavenProjectChanges> var1);

        public void artifactsDownloaded(MavenProject var1);
    }

    private static class MavenProjectTimestamp {
        private final long myPomTimestamp;
        private final long myParentLastReadStamp;
        private final long myProfilesTimestamp;
        private final long myUserSettingsTimestamp;
        private final long myGlobalSettingsTimestamp;
        private final long myExplicitProfilesHashCode;

        private MavenProjectTimestamp(long pomTimestamp, long parentLastReadStamp, long profilesTimestamp, long userSettingsTimestamp, long globalSettingsTimestamp, long explicitProfilesHashCode) {
            this.myPomTimestamp = pomTimestamp;
            this.myParentLastReadStamp = parentLastReadStamp;
            this.myProfilesTimestamp = profilesTimestamp;
            this.myUserSettingsTimestamp = userSettingsTimestamp;
            this.myGlobalSettingsTimestamp = globalSettingsTimestamp;
            this.myExplicitProfilesHashCode = explicitProfilesHashCode;
        }

        public static MavenProjectTimestamp read(DataInputStream in) throws IOException {
            return new MavenProjectTimestamp(in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong());
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeLong(this.myPomTimestamp);
            out.writeLong(this.myParentLastReadStamp);
            out.writeLong(this.myProfilesTimestamp);
            out.writeLong(this.myUserSettingsTimestamp);
            out.writeLong(this.myGlobalSettingsTimestamp);
            out.writeLong(this.myExplicitProfilesHashCode);
        }

        public String toString() {
            return "(" + this.myPomTimestamp + ":" + this.myParentLastReadStamp + ":" + this.myProfilesTimestamp + ":" + this.myUserSettingsTimestamp + ":" + this.myGlobalSettingsTimestamp + ":" + this.myExplicitProfilesHashCode + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenProjectTimestamp timestamp = (MavenProjectTimestamp)o;
            if (this.myPomTimestamp != timestamp.myPomTimestamp) {
                return false;
            }
            if (this.myParentLastReadStamp != timestamp.myParentLastReadStamp) {
                return false;
            }
            if (this.myProfilesTimestamp != timestamp.myProfilesTimestamp) {
                return false;
            }
            if (this.myUserSettingsTimestamp != timestamp.myUserSettingsTimestamp) {
                return false;
            }
            if (this.myGlobalSettingsTimestamp != timestamp.myGlobalSettingsTimestamp) {
                return false;
            }
            return this.myExplicitProfilesHashCode == timestamp.myExplicitProfilesHashCode;
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (int)(this.myPomTimestamp ^ this.myPomTimestamp >>> 32);
            result = 31 * result + (int)(this.myParentLastReadStamp ^ this.myParentLastReadStamp >>> 32);
            result = 31 * result + (int)(this.myProfilesTimestamp ^ this.myProfilesTimestamp >>> 32);
            result = 31 * result + (int)(this.myUserSettingsTimestamp ^ this.myUserSettingsTimestamp >>> 32);
            result = 31 * result + (int)(this.myGlobalSettingsTimestamp ^ this.myGlobalSettingsTimestamp >>> 32);
            result = 31 * result + (int)(this.myExplicitProfilesHashCode ^ this.myExplicitProfilesHashCode >>> 32);
            return result;
        }
    }

    public static abstract class SimpleVisitor
    extends Visitor<Object> {
    }

    public static abstract class Visitor<Result> {
        private Result result;

        public boolean shouldVisit(MavenProject project) {
            return true;
        }

        public abstract void visit(MavenProject var1);

        public void leave(MavenProject node) {
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }

        public boolean isDone() {
            return this.result != null;
        }
    }

    public static interface EmbedderTask {
        public void run(MavenEmbedderWrapper var1) throws MavenProcessCanceledException;
    }

    private class UpdateContext {
        public final Map<MavenProject, MavenProjectChanges> updatedProjectsWithChanges = new LinkedHashMap<MavenProject, MavenProjectChanges>();
        public final Set<MavenProject> deletedProjects = new LinkedHashSet<MavenProject>();

        private UpdateContext() {
        }

        public void update(MavenProject project, MavenProjectChanges changes) {
            this.deletedProjects.remove(project);
            this.updatedProjectsWithChanges.put(project, changes.mergedWith(this.updatedProjectsWithChanges.get(project)));
        }

        public void deleted(MavenProject project) {
            this.updatedProjectsWithChanges.remove(project);
            this.deletedProjects.add(project);
        }

        public void deleted(Collection<MavenProject> projects) {
            for (MavenProject each : projects) {
                this.deleted(each);
            }
        }

        public void fireUpdatedIfNecessary() {
            if (this.updatedProjectsWithChanges.isEmpty() && this.deletedProjects.isEmpty()) {
                return;
            }
            ArrayList<MavenProject> mavenProjects = this.deletedProjects.isEmpty() ? Collections.emptyList() : new ArrayList<MavenProject>(this.deletedProjects);
            List updated = this.updatedProjectsWithChanges.isEmpty() ? Collections.emptyList() : MavenUtil.mapToList(this.updatedProjectsWithChanges);
            MavenProjectsTree.this.fireProjectsUpdated(updated, mavenProjects);
        }
    }
}

