/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.ide.IconProvider;
import com.intellij.psi.PsiElement;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class GroovyIconProvider
extends IconProvider {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/GroovyIconProvider", "getIcon"));
        }
        if (element instanceof GroovyFile) {
            GroovyFile file = (GroovyFile)element;
            if (!file.isScript()) {
                GrTypeDefinition[] typeDefinitions = file.getTypeDefinitions();
                if (typeDefinitions.length > 0) {
                    return typeDefinitions[0].getIcon(flags);
                }
                return JetgroovyIcons.Groovy.Groovy_16x16;
            }
            return GroovyScriptTypeDetector.getIcon(file);
        }
        return null;
    }
}

