/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.wizard.ComboBoxItem;
import com.android.tools.idea.wizard.NewModuleWizardState;
import com.android.tools.idea.wizard.NewProjectWizardState;
import com.android.tools.idea.wizard.TemplateWizardState;
import com.android.tools.idea.wizard.TemplateWizardStep;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ConfigureAndroidModuleStep
extends TemplateWizardStep {
    private static final String SAMPLE_PACKAGE_PREFIX = "com.example.";
    private static final String INVALID_FILENAME_CHARS = "[/\\\\?%*:|\"<>]";
    private static final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>]");
    static final Set<String> INVALID_MSFT_FILENAMES = ImmutableSet.of((Object)"con", (Object)"prn", (Object)"aux", (Object)"clock$", (Object)"nul", (Object)"com1", (Object[])new String[]{"com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "$mft", "$mftmirr", "$logfile", "$volume", "$attrdef", "$bitmap", "$boot", "$badclus", "$secure", "$upcase", "$extend", "$quota", "$objid", "$reparse"});
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JTextField myPackageName;
    JComboBox myMinSdk;
    JComboBox myTargetSdk;
    JComboBox myCompileWith;
    private JComboBox myTheme;
    JCheckBox myCreateCustomLauncherIconCheckBox;
    private JCheckBox myCreateActivityCheckBox;
    private JCheckBox myLibraryCheckBox;
    private JCheckBox myFragmentCheckBox;
    private JCheckBox myActionBarCheckBox;
    private JPanel myPanel;
    private JTextField myModuleName;
    private JLabel myDescription;
    private JLabel myError;
    private JLabel myProjectLocationLabel;
    private JLabel myModuleNameLabel;
    private JCheckBox myGridLayoutCheckBox;
    private JCheckBox myNavigationDrawerCheckBox;
    private JComboBox mySourceCombo;
    private JLabel mySourceVersionLabel;
    private JLabel myAppNameLabel;
    boolean myInitializedPackageNameText = false;
    private boolean myInitialized = false;
    private boolean myInitializing = false;
    private String myPackagePrefix = "com.example.";
    @Nullable
    private WizardContext myWizardContext;

    public ConfigureAndroidModuleStep(TemplateWizardState state, @Nullable Project project, @Nullable Icon sidePanelIcon, TemplateWizardStep.UpdateListener updateListener) {
        super(state, project, null, sidePanelIcon, updateListener);
        this.$$$setupUI$$$();
    }

    private void initialize() {
        IAndroidTarget[] targets = this.getCompilationTargets();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(knownVersions[i], i + 1);
                this.myMinSdk.addItem(targetInfo);
                this.myTargetSdk.addItem(targetInfo);
            }
            this.myTemplateState.put("targetApi", 21);
            this.myTemplateState.put("targetApiString", Integer.toString(21));
            this.myTemplateState.myModified.add("targetApi");
            this.myTemplateState.myModified.add("targetApiString");
        }
        AndroidVersion highest = null;
        for (IAndroidTarget target : targets) {
            if (highest == null || target.getVersion().getApiLevel() >= highest.getApiLevel()) {
                highest = target.getVersion();
            }
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            this.myCompileWith.addItem(targetInfo);
            if (!target.getVersion().isPreview()) continue;
            this.myMinSdk.addItem(targetInfo);
            this.myTargetSdk.addItem(targetInfo);
        }
        if (highest != null) {
            this.myTemplateState.put("buildApi", ConfigureAndroidModuleStep.getItemId(highest));
            this.myTemplateState.put("buildApiString", TemplateMetadata.getBuildApiString(highest));
            this.myTemplateState.myModified.add("targetApi");
            this.myTemplateState.myModified.add("targetApiString");
            this.myTemplateState.put("targetApi", ConfigureAndroidModuleStep.getItemId(highest));
            this.myTemplateState.put("targetApiString", TemplateMetadata.getBuildApiString(highest));
            this.myTemplateState.myModified.add("buildApi");
            this.myTemplateState.myModified.add("buildApiString");
        }
        if (ConfigureAndroidModuleStep.isJdk7Supported(this.getSdkData())) {
            this.mySourceCombo.addItem(new SourceLevelComboBoxItem(LanguageLevel.JDK_1_5));
            this.mySourceCombo.addItem(new SourceLevelComboBoxItem(LanguageLevel.JDK_1_6));
            this.mySourceCombo.addItem(new SourceLevelComboBoxItem(LanguageLevel.JDK_1_7));
            if (!this.myTemplateState.hasAttr("javaVersion")) {
                LanguageLevel defaultLevel = LanguageLevel.JDK_1_6;
                this.myTemplateState.put("javaVersion", ConfigureAndroidModuleStep.languageLevelToString(defaultLevel));
            }
        } else {
            this.hide(this.mySourceVersionLabel, this.mySourceCombo);
        }
        if (!this.myTemplateState.hasAttr("projectLocation") && this.myWizardContext != null && this.myProject == null) {
            this.myTemplateState.put("projectLocation", this.myWizardContext.getProjectFileDirectory());
        }
        if (this.myWizardContext == null) {
            this.computeUniqueProjectLocation();
        }
        if (!this.myTemplateState.hasAttr("appTitle") && this.myProject != null) {
            this.myTemplateState.put("appTitle", this.myProject.getName());
        }
        this.preselectTargetAndBuildApi();
        this.registerUiElements();
        this.myProjectLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileSaverDescriptor fileSaverDescriptor = new FileSaverDescriptor("Project location", "Please choose a location for your project", new String[0]);
                File currentPath = new File(ConfigureAndroidModuleStep.this.myProjectLocation.getText());
                File parentPath = currentPath.getParentFile();
                if (parentPath == null) {
                    parentPath = new File("/");
                }
                VirtualFile parent = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
                String filename = currentPath.getName();
                VirtualFileWrapper fileWrapper = FileChooserFactory.getInstance().createSaveFileDialog(fileSaverDescriptor, (Project)null).save(parent, filename);
                if (fileWrapper != null) {
                    ConfigureAndroidModuleStep.this.myProjectLocation.setText(fileWrapper.getFile().getAbsolutePath());
                }
            }
        });
        this.myProjectLocation.getTextField().addFocusListener(this);
        this.myProjectLocation.getTextField().getDocument().addDocumentListener(this);
        if (this.myTemplateState.myHidden.contains("projectLocation")) {
            this.myProjectLocation.setVisible(false);
            this.myProjectLocationLabel.setVisible(false);
        }
        if (this.myTemplateState.myHidden.contains("isLibraryProject")) {
            this.myLibraryCheckBox.setVisible(false);
        }
        if (this.myTemplateState.myHidden.contains("projectName")) {
            this.myModuleName.setVisible(false);
            this.myModuleNameLabel.setVisible(false);
        }
        if (this.myTemplateState.myHidden.contains("appTitle")) {
            this.myAppNameLabel.setVisible(false);
            this.myAppName.setVisible(false);
        }
    }

    private void preselectTargetAndBuildApi() {
        ProjectBuilder builder;
        if (this.myWizardContext != null && (builder = this.myWizardContext.getProjectBuilder()) instanceof ModuleBuilder) {
            AndroidPlatform platform;
            Sdk sdk = ((ModuleBuilder)builder).getModuleJdk();
            if (sdk == null) {
                sdk = this.myWizardContext.getProjectJdk();
            }
            if (sdk != null && sdk.getSdkType() instanceof AndroidSdkType && (platform = AndroidPlatform.getInstance(sdk)) != null) {
                AndroidVersion version = platform.getTarget().getVersion();
                int apiLevel = version.getFeatureLevel();
                this.myTemplateState.put("targetApi", apiLevel);
                this.myTemplateState.put("targetApiString", version.getApiString());
                this.myTemplateState.put("buildApi", apiLevel);
                this.myTemplateState.put("buildApiString", TemplateMetadata.getBuildApiString(version));
                this.myCompileWith.setEnabled(false);
            }
        }
    }

    private void registerUiElements() {
        Parameter param;
        TemplateMetadata metadata = this.myTemplateState.getTemplateMetadata();
        if (metadata != null && (param = metadata.getParameter("baseTheme")) != null) {
            ConfigureAndroidModuleStep.populateComboBox(this.myTheme, param);
            this.register("baseTheme", this.myTheme);
        }
        this.register("projectName", this.myModuleName);
        this.register("projectLocation", this.myProjectLocation);
        this.register("appTitle", this.myAppName);
        this.register("packageName", this.myPackageName);
        this.register("minApiLevel", this.myMinSdk);
        this.register("targetApi", this.myTargetSdk);
        this.register("buildApi", this.myCompileWith);
        this.register("createActivity", this.myCreateActivityCheckBox);
        this.register("createIcons", this.myCreateCustomLauncherIconCheckBox);
        this.register("isLibraryProject", this.myLibraryCheckBox);
        this.register("usesFragments", this.myFragmentCheckBox);
        this.register("usesNavigationDrawer", this.myNavigationDrawerCheckBox);
        this.register("usesActionBar", this.myActionBarCheckBox);
        this.register("usesGridLayout", this.myGridLayoutCheckBox);
        if (this.mySourceCombo.isVisible()) {
            this.register("javaVersion", this.mySourceCombo);
        }
    }

    @Override
    public void refreshUiFromParameters() {
        if (!this.myVisible) {
            return;
        }
        this.registerUiElements();
        super.refreshUiFromParameters();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getComponent"));
        }
        return jPanel;
    }

    public void updateStep() {
        if (!this.myInitializing && AndroidSdkUtils.isAndroidSdkAvailable()) {
            this.myInitializing = true;
            this.initialize();
            this.myInitialized = true;
        }
        this.myCreateCustomLauncherIconCheckBox.setVisible(!this.myTemplateState.myHidden.contains("createIcons"));
    }

    public String getHelpId() {
        return "Android-Gradle_Page";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAppName;
    }

    @NotNull
    IAndroidTarget[] getCompilationTargets() {
        AndroidSdkData sdkData = this.getSdkData();
        if (sdkData == null) {
            IAndroidTarget[] iAndroidTargetArray = new IAndroidTarget[]{};
            if (iAndroidTargetArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getCompilationTargets"));
            }
            return iAndroidTargetArray;
        }
        IAndroidTarget[] iAndroidTargetArray = ConfigureAndroidModuleStep.getCompilationTargets(sdkData);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    @NotNull
    public static IAndroidTarget[] getCompilationTargets(@NotNull AndroidSdkData sdkData) {
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getCompilationTargets"));
        }
        IAndroidTarget[] targets = sdkData.getTargets();
        ArrayList<IAndroidTarget> list = new ArrayList<IAndroidTarget>();
        for (IAndroidTarget target : targets) {
            if (!target.isPlatform() && (target.getOptionalLibraries() == null || target.getOptionalLibraries().length == 0)) continue;
            list.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = list.toArray(new IAndroidTarget[list.size()]);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    @Override
    @Nullable
    public String getHelpText(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getHelpText"));
        }
        if (param.equals("projectName")) {
            return "This module name is used only by the IDE. It can typically be the same as the application name.";
        }
        if (param.equals("appTitle")) {
            return "The application name is shown in the Play store, as well as in the Manage Applications list in Settings.";
        }
        if (param.equals("packageName")) {
            return "The package name must be a unique identifier for your application.\n It is typically not shown to users, but it <b>must</b> stay the same for the lifetime of your application; it is how multiple versions of the same application are considered the \"same app\".\nThis is typically the reverse domain name of your organization plus one or more application identifiers, and it must be a valid Java package name.";
        }
        if (param.equals("minApi")) {
            return "Choose the lowest version of Android that your application will support. Lower API levels target more devices, but means fewer features are available. By targeting API 8 and later, you reach approximately 95% of the market.";
        }
        if (param.equals("targetApi")) {
            return "Choose the highest API level that the application is known to work with. This attribute informs the system that you have tested against the target version and the system should not enable any compatibility behaviors to maintain your app's forward-compatibility with the target version. The application is still able to run on older versions (down to minSdkVersion). Your application may look dated if you are not targeting the current version.";
        }
        if (param.equals("buildApi")) {
            return "Choose a target API to compile your code against, from your installed SDKs. This is typically the most recent version, or the first version that supports all the APIs you want to directly access without reflection.";
        }
        if (param.equals("baseTheme")) {
            return "Choose the base theme to use for the application";
        }
        if (param.equals("usesFragments")) {
            return "Select this box if you plan to use Fragments and will need the Support Library.";
        }
        if (param.equals("usesActionBar")) {
            return "Select this box if you plan to use the Action Bar and will need the AppCompat Library.";
        }
        if (param.equals("usesGridLayout")) {
            return "Select this box if you plan to use the new GridLayout and will need the GridLayout Support Library.";
        }
        if (param.equals("usesNavigationDrawer")) {
            return "Select this box if you plan to use the Navigation Drawer and will need the Support Library.";
        }
        return null;
    }

    public void onStepLeaving() {
        ((NewModuleWizardState)this.myTemplateState).updateParameters();
    }

    @Override
    @NotNull
    protected JLabel getDescription() {
        JLabel jLabel = this.myDescription;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getDescription"));
        }
        return jLabel;
    }

    @Override
    @NotNull
    protected JLabel getError() {
        JLabel jLabel = this.myError;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getError"));
        }
        return jLabel;
    }

    @Override
    public void updateParams() {
        if (!this.myInitialized) {
            return;
        }
        super.updateParams();
        AndroidTargetComboBoxItem item = (AndroidTargetComboBoxItem)this.myMinSdk.getSelectedItem();
        if (item != null) {
            this.myTemplateState.put("minApiLevel", item.apiLevel);
            if (item.target != null) {
                this.myTemplateState.put("minApi", item.target.getVersion().getApiString());
            } else {
                this.myTemplateState.put("minApi", Integer.toString(item.apiLevel));
            }
        }
        if ((item = (AndroidTargetComboBoxItem)this.myTargetSdk.getSelectedItem()) != null) {
            this.myTemplateState.put("targetApi", item.apiLevel);
            if (item.target != null) {
                this.myTemplateState.put("targetApiString", item.target.getVersion().getApiString());
            } else {
                this.myTemplateState.put("targetApiString", Integer.toString(item.apiLevel));
            }
        }
        if ((item = (AndroidTargetComboBoxItem)this.myCompileWith.getSelectedItem()) != null) {
            this.myTemplateState.put("buildApi", item.apiLevel);
            if (item.target != null) {
                this.myTemplateState.put("buildApiString", item.target.getVersion().getApiString());
            } else {
                this.myTemplateState.put("buildApiString", Integer.toString(item.apiLevel));
            }
        }
        if (this.myTemplateState.myModified.contains("packageName") && !this.computePackagePrefix(this.myTemplateState.getString("packageName")).equals(this.myPackagePrefix)) {
            this.myPackagePrefix = this.computePackagePrefix(this.myTemplateState.getString("packageName"));
            PropertiesComponent.getInstance().setValue("LAST_USED_CLASS_PREFIX", this.myPackagePrefix);
        }
    }

    @Override
    protected void deriveValues() {
        this.updateDerivedValue("projectName", this.myModuleName, new Callable<String>(){

            @Override
            public String call() {
                return ConfigureAndroidModuleStep.this.computeModuleName();
            }
        });
        this.updateDerivedValue("packageName", this.myPackageName, new Callable<String>(){

            @Override
            public String call() {
                return ConfigureAndroidModuleStep.this.computePackageName();
            }
        });
        if (!this.myTemplateState.myHidden.contains("projectLocation")) {
            this.updateDerivedValue("projectLocation", this.myProjectLocation.getTextField(), new Callable<String>(){

                @Override
                public String call() {
                    return ConfigureAndroidModuleStep.this.computeProjectLocation();
                }
            });
        }
        if (!this.myInitializedPackageNameText) {
            this.myInitializedPackageNameText = true;
            String maybePackagePrefix = PropertiesComponent.getInstance().getValue("LAST_USED_CLASS_PREFIX");
            if (maybePackagePrefix != null && !maybePackagePrefix.isEmpty()) {
                this.myPackagePrefix = maybePackagePrefix;
            }
            if (this.myTemplateState.getString("packageName").startsWith(SAMPLE_PACKAGE_PREFIX)) {
                int length = SAMPLE_PACKAGE_PREFIX.length();
                if (SAMPLE_PACKAGE_PREFIX.endsWith(".")) {
                    --length;
                }
                this.myPackageName.select(0, length);
            }
        }
    }

    @Override
    public boolean validate() {
        String sourceVersion;
        String moduleName;
        String packageName;
        ((NewModuleWizardState)this.myTemplateState).updateParameters();
        if (!super.validate()) {
            return false;
        }
        this.setErrorHtml("");
        if (!this.myTemplateState.myHidden.contains("appTitle")) {
            String applicationName = this.myTemplateState.getString("appTitle");
            if (applicationName.isEmpty()) {
                this.setErrorHtml("Enter an application name (shown in launcher)");
                return false;
            }
            if (Character.isLowerCase(applicationName.charAt(0))) {
                this.setErrorHtml("The application name for most apps begins with an uppercase letter");
            }
        }
        if (!this.myTemplateState.hasAttr("packageName")) {
            this.myTemplateState.put("packageName", "com.example.." + this.myTemplateState.getString("projectName"));
        }
        if ((packageName = this.myTemplateState.getString("packageName")).startsWith(SAMPLE_PACKAGE_PREFIX)) {
            this.setErrorHtml(String.format("The prefix '%1$s' is meant as a placeholder and should not be used", SAMPLE_PACKAGE_PREFIX));
        }
        if ((moduleName = this.myTemplateState.getString("projectName")).isEmpty()) {
            this.setErrorHtml("Please specify a module name.");
            return false;
        }
        if (!ConfigureAndroidModuleStep.isValidModuleName(moduleName)) {
            this.setErrorHtml("Invalid module name.");
            return false;
        }
        Integer minSdk = (Integer)this.myTemplateState.get("minApiLevel");
        if (minSdk == null) {
            this.setErrorHtml("Select a minimum SDK version");
            return false;
        }
        if (this.myTemplateState.get("buildApi") == null) {
            this.setErrorHtml("Select a compile target");
            return false;
        }
        if (this.myTemplateState.get("targetApi") == null) {
            this.setErrorHtml("Select a target SDK");
            return false;
        }
        int minLevel = this.myTemplateState.getInt("minApiLevel");
        int buildLevel = this.myTemplateState.getInt("buildApi");
        int targetLevel = this.myTemplateState.getInt("targetApi");
        if (targetLevel < minLevel) {
            this.setErrorHtml("The target SDK version should be at least as high as the minimum SDK version");
            return false;
        }
        if (buildLevel < minLevel) {
            this.setErrorHtml("The build target version should be at least as high as the minimum SDK version");
            return false;
        }
        if (this.myTemplateState.hasAttr("javaVersion") && "1.7".equals(sourceVersion = this.myTemplateState.getString("javaVersion"))) {
            if (buildLevel < 19) {
                this.setErrorHtml("Using Java language level 7 requires compiling with API 19: Android 4.4 (KitKat)");
                return false;
            }
            if (minLevel < 19) {
                this.setErrorHtml("Note: With minSdkVersion less than 19, you cannot use try-with-resources, but other Java 7 language features are fine");
            }
        }
        ConfigureAndroidModuleStep.toggleVisibleOnApi(this.myFragmentCheckBox, 10, minLevel);
        ConfigureAndroidModuleStep.toggleVisibleOnApi(this.myNavigationDrawerCheckBox, 10, minLevel);
        ConfigureAndroidModuleStep.toggleVisibleOnApi(this.myActionBarCheckBox, 10, minLevel);
        ConfigureAndroidModuleStep.toggleVisibleOnApi(this.myGridLayoutCheckBox, 13, minLevel);
        if (!this.myTemplateState.myHidden.contains("projectLocation")) {
            String projectLocation = this.myTemplateState.getString("projectLocation");
            if (projectLocation.isEmpty()) {
                this.setErrorHtml("Please specify a project location");
                return false;
            }
            if (File.separatorChar == '/' && projectLocation.contains("\\") || File.separatorChar == '\\' && projectLocation.contains("/")) {
                this.setErrorHtml("Your project location contains incorrect slashes ('\\' vs '/')");
                return false;
            }
            for (File testFile = new File(projectLocation); testFile != null; testFile = testFile.getParentFile()) {
                String filename = testFile.getName();
                if (ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)filename)) {
                    char illegalChar = filename.charAt(ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)filename));
                    this.setErrorHtml(String.format("Illegal character in project location path: '%c' in filename: %s", Character.valueOf(illegalChar), filename));
                    return false;
                }
                if (CharMatcher.WHITESPACE.matchesAnyOf((CharSequence)filename)) {
                    this.setErrorHtml("Your project location contains whitespace. This can cause problems on some platforms and is not recommended.");
                }
                if (!CharMatcher.ASCII.matchesAllOf((CharSequence)filename)) {
                    this.setErrorHtml("Your project location contains non-ASCII characters. This can cause problems on Windows. Proceed with caution.");
                }
                if (testFile.exists() || testFile.getParentFile() == null || !testFile.getParentFile().exists() || testFile.getParentFile().canWrite()) continue;
                this.setErrorHtml(String.format("The path '%s' is not writeable. Please choose a new location.", testFile.getParentFile().getPath()));
                return false;
            }
            File file = new File(projectLocation);
            if (file.isFile()) {
                this.setErrorHtml("There must not already be a file at the project location");
                return false;
            }
            if (file.isDirectory() && TemplateUtils.listFiles(file).length > 0) {
                this.setErrorHtml("A non-empty directory already exists at the specified project location. Existing files may be overwritten. Proceed with caution.");
            }
            if (file.getParent() == null) {
                this.setErrorHtml("The project location can not be at the filesystem root");
                return false;
            }
            if (file.getParentFile().exists() && !file.getParentFile().isDirectory()) {
                this.setErrorHtml("The project location's parent directory must be a directory, not a plain file");
                return false;
            }
        } else if (!this.isUniqueModuleName(moduleName)) {
            this.setErrorHtml(String.format(Locale.getDefault(), "Module %1$s already exists", moduleName));
            return false;
        }
        return true;
    }

    private static void toggleVisibleOnApi(JCheckBox component, int maxApiLevel, int apiLevel) {
        component.setVisible(apiLevel <= maxApiLevel);
        if (!component.isVisible()) {
            component.setSelected(false);
        }
    }

    static String nameToPackage(String moduleName) {
        moduleName = moduleName.replace('-', '_');
        moduleName = moduleName.replaceAll("[^a-zA-Z0-9_]", "");
        moduleName = moduleName.toLowerCase();
        return moduleName;
    }

    @NotNull
    String computePackageName() {
        String moduleName = this.myTemplateState.getString("projectName");
        String projectName = this.myTemplateState.getString("appTitle");
        projectName = ConfigureAndroidModuleStep.nameToPackage(projectName);
        moduleName = ConfigureAndroidModuleStep.nameToPackage(moduleName);
        if (!this.myPackagePrefix.endsWith(".")) {
            this.myPackagePrefix = this.myPackagePrefix + '.';
        }
        if (moduleName.isEmpty() && projectName.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computePackageName"));
            }
            return "";
        }
        if (moduleName.isEmpty()) {
            String string = this.myPackagePrefix + projectName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computePackageName"));
            }
            return string;
        }
        if (projectName.isEmpty()) {
            String string = this.myPackagePrefix + moduleName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computePackageName"));
            }
            return string;
        }
        String string = this.myPackagePrefix + projectName + '.' + moduleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computePackageName"));
        }
        return string;
    }

    @NotNull
    String computePackagePrefix(String packageName) {
        int nameIndex;
        String moduleName = this.myTemplateState.getString("projectName");
        String projectName = this.myTemplateState.getString("appTitle");
        if (!projectName.isEmpty() && (nameIndex = packageName.lastIndexOf(projectName = ConfigureAndroidModuleStep.nameToPackage(projectName))) != -1) {
            String string = packageName.substring(0, nameIndex);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computePackagePrefix"));
            }
            return string;
        }
        if (!moduleName.isEmpty()) {
            nameIndex = packageName.lastIndexOf(moduleName = ConfigureAndroidModuleStep.nameToPackage(moduleName));
            if (nameIndex != -1) {
                String string = packageName.substring(0, nameIndex);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computePackagePrefix"));
                }
                return string;
            }
            String string = packageName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computePackagePrefix"));
            }
            return string;
        }
        String string = packageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computePackagePrefix"));
        }
        return string;
    }

    @NotNull
    String computeModuleName() {
        String name;
        String string = name = this.myTemplateState.getBoolean("isLibraryProject") ? "lib" : "app";
        if (!this.isUniqueModuleName(name)) {
            int i = 2;
            while (!this.isUniqueModuleName(name + Integer.toString(i))) {
                ++i;
            }
            name = name + Integer.toString(i);
        }
        String string2 = name;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computeModuleName"));
        }
        return string2;
    }

    static boolean isValidModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "isValidModuleName"));
        }
        if (!moduleName.replaceAll(INVALID_FILENAME_CHARS, "").equals(moduleName)) {
            return false;
        }
        for (String s : Splitter.on((char)'.').split((CharSequence)moduleName)) {
            if (!INVALID_MSFT_FILENAMES.contains(s.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    private boolean isUniqueModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "isUniqueModuleName"));
        }
        if (this.myProject == null) {
            return true;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module m : moduleManager.getModules()) {
            if (!m.getName().equalsIgnoreCase(moduleName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private String computeProjectLocation() {
        String name = this.myTemplateState.getString("appTitle");
        name = name.replaceAll("[^a-zA-Z0-9_\\-.]", "");
        String string = new File(NewProjectWizardState.getProjectFileDirectory(), name).getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "computeProjectLocation"));
        }
        return string;
    }

    public void setWizardContext(@Nullable WizardContext wizardContext) {
        this.myWizardContext = wizardContext;
    }

    public static boolean isJdk7Supported(@Nullable AndroidSdkData sdkData) {
        if (sdkData != null) {
            IPkgDesc d;
            LocalPkgInfo info = sdkData.getLocalSdk().getPkgInfo(PkgType.PKG_PLATFORM_TOOLS);
            IPkgDesc iPkgDesc = d = info == null ? null : info.getDesc();
            if (d != null && d.hasFullRevision()) {
                FullRevision fullRevision = d.getFullRevision();
                assert (fullRevision != null);
                if (fullRevision.getMajor() >= 19) {
                    JavaSdkVersion version;
                    JavaSdk jdk = JavaSdk.getInstance();
                    Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                    if (sdk != null && (version = jdk.getVersion(sdk)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Nullable
    private AndroidSdkData getSdkData() {
        Sdk projectJdk;
        AndroidSdkData sdkData = null;
        if (this.myWizardContext != null && (projectJdk = this.myWizardContext.getProjectJdk()) != null) {
            sdkData = AndroidSdkData.getSdkData(projectJdk);
        }
        if (sdkData == null) {
            sdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
        }
        return sdkData;
    }

    public static String languageLevelToString(LanguageLevel level) {
        switch (level) {
            case JDK_1_5: {
                return "1.5";
            }
            case JDK_1_6: {
                return "1.6";
            }
            case JDK_1_7: {
                return "1.7";
            }
        }
        return level.name().substring(4).replace('_', '.');
    }

    void computeUniqueProjectLocation() {
        File file;
        String projectLocation;
        String string = projectLocation = this.myTemplateState.hasAttr("projectLocation") ? this.myTemplateState.getString("projectLocation") : this.computeProjectLocation();
        if (!(projectLocation.isEmpty() || this.myProject != null && this.myProject.isInitialized() || !(file = new File(projectLocation)).exists())) {
            String appName = this.myTemplateState.getString("appTitle");
            int i = 2;
            while (file.exists()) {
                this.myTemplateState.put("appTitle", String.format(Locale.getDefault(), "%s %d", appName, i));
                file = new File(this.computeProjectLocation());
                ++i;
            }
            this.deriveValues();
        }
    }

    private static Object getItemId(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep", "getItemId"));
        }
        if (version.isPreview()) {
            String codename = version.getCodename();
            assert (codename != null);
            return codename;
        }
        return version.getFeatureLevel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JTextField jTextField;
        JLabel jLabel2;
        JTextField jTextField2;
        JLabel jLabel3;
        JLabel jLabel4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel5;
        JTextField jTextField3;
        JLabel jLabel6;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(16, 7, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myModuleNameLabel = jLabel6 = new JLabel();
        jLabel6.setText("Module name:");
        jPanel.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleName = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(1, 1, 1, 6, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProjectLocationLabel = jLabel5 = new JLabel();
        jLabel5.setText("Project location:");
        jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 1, 0, 1, 0, null, null, null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 6, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Minimum required SDK:");
        jPanel.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Target SDK:");
        jPanel.add((Component)jLabel8, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Compile with:");
        jPanel.add((Component)jLabel9, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Theme:");
        jPanel.add((Component)jLabel10, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMinSdk = jComboBox5 = new JComboBox();
        jPanel.add(jComboBox5, new GridConstraints(5, 1, 1, 3, 8, 1, 0, 0, null, new Dimension(241, 27), null));
        this.myTargetSdk = jComboBox4 = new JComboBox();
        jPanel.add(jComboBox4, new GridConstraints(6, 1, 1, 3, 8, 1, 0, 0, null, new Dimension(241, 27), null));
        this.myCompileWith = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(7, 1, 1, 3, 8, 1, 0, 0, null, new Dimension(241, 27), null));
        this.myTheme = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(9, 1, 1, 3, 8, 1, 0, 0, null, new Dimension(241, 27), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(10, 0, 1, 1, 1, 0, 1, 0, null, null, null));
        this.myCreateCustomLauncherIconCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Create custom launcher icon");
        jPanel.add((Component)jCheckBox7, new GridConstraints(11, 1, 1, 6, 8, 0, 3, 0, null, null, null));
        this.myCreateActivityCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Create activity");
        jPanel.add((Component)jCheckBox6, new GridConstraints(12, 1, 1, 6, 8, 0, 3, 0, null, null, null));
        this.myLibraryCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Mark this project as a library");
        jPanel.add((Component)jCheckBox5, new GridConstraints(13, 1, 1, 6, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(15, 0, 1, 7, 0, 3, 3, 2, new Dimension(-1, 175), null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Description", 0, 0, null, null));
        this.myDescription = jLabel4 = new JLabel();
        jLabel4.setVerticalTextPosition(1);
        jLabel4.setVerticalAlignment(1);
        jLabel4.setText("");
        ((Component)jLabel4).setBackground(new Color(-1118482));
        ((Component)jLabel4).setEnabled(true);
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        this.myError = jLabel3 = new JLabel();
        jLabel3.setVerticalTextPosition(3);
        jLabel3.setVerticalAlignment(3);
        jLabel3.setText("");
        ((Component)jLabel3).setBackground(new Color(-1118482));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 2, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 4, 1, 3, 0, 1, 6, 1, null, null, null));
        this.myAppName = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 6, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAppNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Application name:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Package name:");
        jPanel.add((Component)jLabel11, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 6, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Support Mode:");
        jPanel.add((Component)jLabel12, new GridConstraints(14, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFragmentCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Fragments");
        jPanel.add((Component)jCheckBox4, new GridConstraints(14, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGridLayoutCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("GridLayout");
        jPanel.add((Component)jCheckBox3, new GridConstraints(14, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNavigationDrawerCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Navigation Drawer");
        jPanel.add((Component)jCheckBox2, new GridConstraints(14, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myActionBarCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Action Bar");
        jPanel.add((Component)jCheckBox, new GridConstraints(14, 4, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySourceVersionLabel = jLabel = new JLabel();
        jLabel.setText("Language Level:");
        jPanel.add((Component)jLabel, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(8, 1, 1, 3, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static class AndroidTargetComboBoxItem
    extends ComboBoxItem {
        public int apiLevel;
        public IAndroidTarget target;

        public AndroidTargetComboBoxItem(@NotNull String label, int apiLevel) {
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep$AndroidTargetComboBoxItem", "<init>"));
            }
            super(apiLevel, label, 1, 1);
            this.apiLevel = -1;
            this.target = null;
            this.apiLevel = apiLevel;
        }

        public AndroidTargetComboBoxItem(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep$AndroidTargetComboBoxItem", "<init>"));
            }
            super(AndroidTargetComboBoxItem.getId(target), AndroidSdkUtils.getTargetLabel(target), 1, 1);
            this.apiLevel = -1;
            this.target = null;
            this.target = target;
            this.apiLevel = target.getVersion().getFeatureLevel();
        }

        @Override
        public String toString() {
            return this.label;
        }

        @NotNull
        private static Object getId(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep$AndroidTargetComboBoxItem", "getId"));
            }
            AndroidVersion version = target.getVersion();
            Object object = ConfigureAndroidModuleStep.getItemId(version);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep$AndroidTargetComboBoxItem", "getId"));
            }
            return object;
        }
    }

    public static class SourceLevelComboBoxItem
    extends ComboBoxItem {
        public final LanguageLevel level;

        public SourceLevelComboBoxItem(@NotNull LanguageLevel level) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/wizard/ConfigureAndroidModuleStep$SourceLevelComboBoxItem", "<init>"));
            }
            super(ConfigureAndroidModuleStep.languageLevelToString(level), level.getPresentableText(), 1, 1);
            this.level = level;
        }

        @Override
        public String toString() {
            return this.level.getPresentableText();
        }
    }
}

