/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class DeadCodeHelper {
    public static void removeDeadBlocks(ControlFlowGraph graph) {
        LinkedList<BasicBlock> stack = new LinkedList<BasicBlock>();
        HashSet<BasicBlock> setStacked = new HashSet<BasicBlock>();
        stack.add(graph.getFirst());
        setStacked.add(graph.getFirst());
        while (!stack.isEmpty()) {
            BasicBlock block = (BasicBlock)stack.removeFirst();
            ArrayList<BasicBlock> lstSuccs = new ArrayList<BasicBlock>(block.getSuccs());
            lstSuccs.addAll(block.getSuccExceptions());
            for (BasicBlock succ : lstSuccs) {
                if (setStacked.contains(succ)) continue;
                stack.add(succ);
                setStacked.add(succ);
            }
        }
        HashSet setAllBlocks = new HashSet(graph.getBlocks());
        setAllBlocks.removeAll(setStacked);
        for (BasicBlock block : setAllBlocks) {
            graph.removeBlock(block);
        }
    }

    public static void removeEmptyBlocks(ControlFlowGraph graph) {
        boolean cont;
        VBStyleCollection<BasicBlock, Integer> blocks = graph.getBlocks();
        block0: do {
            cont = false;
            for (int i = blocks.size() - 1; i >= 0; --i) {
                BasicBlock block = (BasicBlock)blocks.get(i);
                if (!DeadCodeHelper.removeEmptyBlock(graph, block, false)) continue;
                cont = true;
                continue block0;
            }
        } while (cont);
    }

    private static boolean removeEmptyBlock(ControlFlowGraph graph, BasicBlock block, boolean merging) {
        boolean deletedRanges = false;
        if (block.getSeq().isEmpty()) {
            if (block.getSuccs().size() > 1) {
                if (block.getPreds().size() > 1) {
                    throw new RuntimeException("ERROR: empty block with multiple predecessors and successors found");
                }
                if (!merging) {
                    throw new RuntimeException("ERROR: empty block with multiple successors found");
                }
            }
            HashSet<BasicBlock> setExits = new HashSet<BasicBlock>(graph.getLast().getPreds());
            if (block.getPredExceptions().isEmpty() && (!setExits.contains(block) || block.getPreds().size() == 1)) {
                Set<BasicBlock> setFinallyExits;
                BasicBlock pred;
                if (setExits.contains(block) && ((pred = block.getPreds().get(0)).getSuccs().size() != 1 || !pred.getSeq().isEmpty() && pred.getSeq().getLastInstr().group == 3)) {
                    return false;
                }
                HashSet<BasicBlock> setPreds = new HashSet<BasicBlock>(block.getPreds());
                HashSet<BasicBlock> setSuccs = new HashSet<BasicBlock>(block.getSuccs());
                HashSet<BasicBlock> setCommonExceptionHandlers = null;
                for (int i = 0; i < 2; ++i) {
                    for (BasicBlock pred2 : i == 0 ? setPreds : setSuccs) {
                        if (setCommonExceptionHandlers == null) {
                            setCommonExceptionHandlers = new HashSet<BasicBlock>(pred2.getSuccExceptions());
                            continue;
                        }
                        setCommonExceptionHandlers.retainAll(pred2.getSuccExceptions());
                    }
                }
                if (setCommonExceptionHandlers != null && !setCommonExceptionHandlers.isEmpty()) {
                    for (BasicBlock handler : setCommonExceptionHandlers) {
                        if (block.getSuccExceptions().contains(handler)) continue;
                        return false;
                    }
                }
                List<ExceptionRangeCFG> lstRanges = graph.getExceptions();
                for (int i = lstRanges.size() - 1; i >= 0; --i) {
                    ExceptionRangeCFG range = lstRanges.get(i);
                    List<BasicBlock> lst = range.getProtectedRange();
                    if (lst.size() != 1 || lst.get(0) != block) continue;
                    if (DecompilerContext.getOption("rer")) {
                        block.removeSuccessorException(range.getHandler());
                        lstRanges.remove(i);
                        deletedRanges = true;
                        continue;
                    }
                    return false;
                }
                if (merging) {
                    BasicBlock pred3 = block.getPreds().get(0);
                    pred3.removeSuccessor(block);
                    ArrayList<BasicBlock> lstSuccs = new ArrayList<BasicBlock>(block.getSuccs());
                    for (BasicBlock succ : lstSuccs) {
                        block.removeSuccessor(succ);
                        pred3.addSuccessor(succ);
                    }
                } else {
                    for (BasicBlock pred2 : setPreds) {
                        for (BasicBlock succ : setSuccs) {
                            pred2.replaceSuccessor(block, succ);
                        }
                    }
                }
                if ((setFinallyExits = graph.getFinallyExits()).contains(block)) {
                    setFinallyExits.remove(block);
                    setFinallyExits.add(setPreds.iterator().next());
                }
                if (graph.getFirst() == block) {
                    if (setSuccs.size() != 1) {
                        throw new RuntimeException("multiple or no entry blocks!");
                    }
                    graph.setFirst(setSuccs.iterator().next());
                }
                graph.removeBlock(block);
                if (deletedRanges) {
                    DeadCodeHelper.removeDeadBlocks(graph);
                }
            }
        }
        return deletedRanges;
    }

    public static boolean isDominator(ControlFlowGraph graph, BasicBlock block, BasicBlock dom) {
        HashSet<BasicBlock> marked = new HashSet<BasicBlock>();
        if (block == dom) {
            return true;
        }
        LinkedList<BasicBlock> lstNodes = new LinkedList<BasicBlock>();
        lstNodes.add(block);
        while (!lstNodes.isEmpty()) {
            BasicBlock pred;
            int i;
            BasicBlock node = (BasicBlock)lstNodes.remove(0);
            if (marked.contains(node)) continue;
            marked.add(node);
            if (node == graph.getFirst()) {
                return false;
            }
            for (i = 0; i < node.getPreds().size(); ++i) {
                pred = node.getPreds().get(i);
                if (marked.contains(pred) || pred == dom) continue;
                lstNodes.add(pred);
            }
            for (i = 0; i < node.getPredExceptions().size(); ++i) {
                pred = node.getPredExceptions().get(i);
                if (marked.contains(pred) || pred == dom) continue;
                lstNodes.add(pred);
            }
        }
        return true;
    }

    public static void removeGotos(ControlFlowGraph graph) {
        for (BasicBlock block : graph.getBlocks()) {
            Instruction instr = block.getLastInstruction();
            if (instr == null || instr.opcode != 167) continue;
            block.getSeq().removeInstruction(block.getSeq().length() - 1);
        }
        DeadCodeHelper.removeEmptyBlocks(graph);
    }

    public static void connectDummyExitBlock(ControlFlowGraph graph) {
        BasicBlock exit = graph.getLast();
        for (BasicBlock block : new HashSet<BasicBlock>(exit.getPreds())) {
            exit.removePredecessor(block);
            block.addSuccessor(exit);
        }
    }

    public static void incorporateValueReturns(ControlFlowGraph graph) {
        for (BasicBlock block : graph.getBlocks()) {
            ExceptionRangeCFG range;
            BasicBlock bpred;
            InstructionSequence seq = block.getSeq();
            int len = seq.length();
            if (len <= 0 || len >= 3) continue;
            boolean ok = false;
            if (seq.getLastInstr().opcode >= 172 && seq.getLastInstr().opcode <= 177) {
                if (len == 1) {
                    ok = true;
                } else if (seq.getLastInstr().opcode != 177) {
                    switch (seq.getInstr((int)0).opcode) {
                        case 1: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            ok = true;
                        }
                    }
                }
            }
            if (!ok) continue;
            if (!block.getPreds().isEmpty()) {
                HashSet<BasicBlock> setPredHandlersUnion = new HashSet<BasicBlock>();
                HashSet<BasicBlock> setPredHandlersIntersection = new HashSet<BasicBlock>();
                boolean firstpred = true;
                for (BasicBlock pred : block.getPreds()) {
                    if (firstpred) {
                        setPredHandlersIntersection.addAll(pred.getSuccExceptions());
                        firstpred = false;
                    } else {
                        setPredHandlersIntersection.retainAll(pred.getSuccExceptions());
                    }
                    setPredHandlersUnion.addAll(pred.getSuccExceptions());
                }
                setPredHandlersIntersection.removeAll(block.getSuccExceptions());
                BasicBlock predecessor = block.getPreds().get(0);
                for (BasicBlock handler : setPredHandlersIntersection) {
                    ExceptionRangeCFG range2 = graph.getExceptionRange(handler, predecessor);
                    range2.getProtectedRange().add(block);
                    block.addSuccessorException(handler);
                }
                HashSet<BasicBlock> setRangesToBeRemoved = new HashSet<BasicBlock>(block.getSuccExceptions());
                setRangesToBeRemoved.removeAll(setPredHandlersUnion);
                for (BasicBlock handler : setRangesToBeRemoved) {
                    ExceptionRangeCFG range3 = graph.getExceptionRange(handler, block);
                    if (range3.getProtectedRange().size() <= 1) continue;
                    range3.getProtectedRange().remove(block);
                    block.removeSuccessorException(handler);
                }
            }
            if (block.getPreds().size() != 1 || !block.getPredExceptions().isEmpty() || (bpred = block.getPreds().get(0)).getSuccs().size() != 1) continue;
            for (BasicBlock succ : bpred.getSuccExceptions()) {
                if (block.getSuccExceptions().contains(succ)) continue;
                range = graph.getExceptionRange(succ, bpred);
                range.getProtectedRange().add(block);
                block.addSuccessorException(succ);
            }
            for (BasicBlock succ : new HashSet<BasicBlock>(block.getSuccExceptions())) {
                if (bpred.getSuccExceptions().contains(succ) || (range = graph.getExceptionRange(succ, block)).getProtectedRange().size() <= 1) continue;
                range.getProtectedRange().remove(block);
                block.removeSuccessorException(succ);
            }
        }
    }

    public static void mergeBasicBlocks(ControlFlowGraph graph) {
        boolean merged;
        block0: do {
            merged = false;
            for (BasicBlock block : graph.getBlocks()) {
                BasicBlock next;
                InstructionSequence seq = block.getSeq();
                if (block.getSuccs().size() != 1 || (next = block.getSuccs().get(0)) == graph.getLast() || !seq.isEmpty() && seq.getLastInstr().group == 3 || next.getPreds().size() != 1 || !next.getPredExceptions().isEmpty() || next == graph.getFirst()) continue;
                boolean sameRanges = true;
                for (ExceptionRangeCFG range : graph.getExceptions()) {
                    if (!(range.getProtectedRange().contains(block) ^ range.getProtectedRange().contains(next))) continue;
                    sameRanges = false;
                    break;
                }
                if (!sameRanges) continue;
                seq.addSequence(next.getSeq());
                block.getInstrOldOffsets().addAll(next.getInstrOldOffsets());
                next.getSeq().clear();
                DeadCodeHelper.removeEmptyBlock(graph, next, true);
                merged = true;
                continue block0;
            }
        } while (merged);
    }
}

