/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationMenuAction;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.configurations.TranslationDialog;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.ProjectResourceRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.idea.rendering.multi.RenderPreviewManager;
import com.android.tools.idea.rendering.multi.RenderPreviewMode;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import icons.AndroidIcons;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocaleMenuAction
extends FlatComboAction {
    private final RenderContext myRenderContext;

    public LocaleMenuAction(RenderContext renderContext) {
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Locale to render layout with inside the IDE");
        this.updatePresentation(presentation);
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        List<Locale> locales = this.getRelevantLocales();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && locales.size() > 0) {
            group.add((AnAction)new SetLocaleAction(this.myRenderContext, LocaleMenuAction.getLocaleLabel(Locale.ANY, false), Locale.ANY));
            group.addSeparator();
            Collections.sort(locales, Locale.LANGUAGE_CODE_COMPARATOR);
            for (Locale locale : locales) {
                String title = LocaleMenuAction.getLocaleLabel(locale, false);
                VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, null, locale, null);
                if (better != null) {
                    title = ConfigurationAction.getBetterMatchLabel(LocaleMenuAction.getLocaleLabel(locale, true), better, configuration.getFile());
                }
                group.add((AnAction)new SetLocaleAction(this.myRenderContext, title, locale));
            }
            group.addSeparator();
        }
        if (locales.size() > 0) {
            group.add((AnAction)new EditTranslationAction());
        }
        group.add((AnAction)new AddTranslationAction());
        group.addSeparator();
        RenderPreviewMode currentMode = RenderPreviewMode.getCurrent();
        if (currentMode != RenderPreviewMode.LOCALES && currentMode != RenderPreviewMode.RTL) {
            if (locales.size() >= 1) {
                ConfigurationMenuAction.addLocalePreviewAction(this.myRenderContext, group, true);
            }
            ConfigurationMenuAction.addRtlPreviewAction(this.myRenderContext, group);
        } else {
            ConfigurationMenuAction.addRemovePreviewsAction(this.myRenderContext, group);
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    private List<Locale> getRelevantLocales() {
        ProjectResourceRepository projectResources;
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            List<Locale> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getRelevantLocales"));
            }
            return list;
        }
        Module module = configuration.getConfigurationManager().getModule();
        LanguageQualifier specificLanguage = configuration.getEditedConfig().getEffectiveLanguage();
        RegionQualifier specificRegion = configuration.getEditedConfig().getEffectiveRegion();
        if (specificLanguage != null || specificRegion != null) {
            List<VirtualFile> variations = ResourceHelper.getResourceVariations(configuration.getFile(), false);
            for (VirtualFile variation : variations) {
                FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)variation.getParent().getName());
                if (config == null || config.getEffectiveLanguage() != null) continue;
                specificLanguage = null;
                specificRegion = null;
                break;
            }
        }
        SortedSet languages = (projectResources = ProjectResourceRepository.getProjectResources(module, true)) != null ? projectResources.getLanguages() : Collections.emptySet();
        for (String language : languages) {
            if (specificLanguage != null && !language.equals(specificLanguage.getValue())) continue;
            LanguageQualifier languageQualifier = new LanguageQualifier(language);
            locales.add(Locale.create(languageQualifier));
            if (projectResources == null) continue;
            SortedSet regions = projectResources.getRegions(language);
            for (String region : regions) {
                if (specificRegion != null && !region.equals(specificRegion.getValue())) continue;
                locales.add(Locale.create(languageQualifier, new RegionQualifier(region)));
            }
        }
        ArrayList<Locale> arrayList = locales;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getRelevantLocales"));
        }
        return arrayList;
    }

    @NotNull
    public static List<Locale> getAllLocales() {
        List sorted = LocaleManager.getLanguageCodes((boolean)true);
        ArrayList<Locale> locales = new ArrayList<Locale>(sorted.size());
        for (String language : sorted) {
            Locale locale = Locale.create(new LanguageQualifier(language));
            locales.add(locale);
        }
        ArrayList<Locale> arrayList = locales;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getAllLocales"));
        }
        return arrayList;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Locale locale = configuration.getLocale();
            if (locale == Locale.ANY) {
                presentation.setIcon(AndroidIcons.Globe);
            } else {
                presentation.setIcon(locale.getFlagImage());
            }
            String brief = LocaleMenuAction.getLocaleLabel(locale, true);
            presentation.setText(brief);
        } else {
            presentation.setIcon(AndroidIcons.Globe);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    @Override
    protected int getMaxRows() {
        return 10;
    }

    @NotNull
    public static String getLocaleLabel(@Nullable Locale locale, boolean brief) {
        if (locale == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getLocaleLabel"));
            }
            return "";
        }
        if (!locale.hasLanguage()) {
            if (brief) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getLocaleLabel"));
                }
                return "";
            }
            if ("Default" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getLocaleLabel"));
            }
            return "Default";
        }
        String languageCode = locale.language.getValue();
        String languageName = LocaleManager.getLanguageName((String)languageCode);
        if (!locale.hasRegion()) {
            if (!brief && languageName != null) {
                String string = String.format("%1$s (%2$s)", languageName, languageCode);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getLocaleLabel"));
                }
                return string;
            }
            String string = languageCode;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getLocaleLabel"));
            }
            return string;
        }
        String regionCode = locale.region.getValue();
        if (!brief && languageName != null) {
            String regionName = LocaleManager.getRegionName((String)regionCode);
            if (regionName != null) {
                String string = String.format("%1$s (%2$s) in %3$s (%4$s)", languageName, languageCode, regionName, regionCode);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getLocaleLabel"));
                }
                return string;
            }
            String string = String.format("%1$s (%2$s) in %3$s", languageName, languageCode, regionCode);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getLocaleLabel"));
            }
            return string;
        }
        String string = String.format("%1$s / %2$s", languageCode, regionCode);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction", "getLocaleLabel"));
        }
        return string;
    }

    private class CreateLocaleAction
    extends AnAction {
        private final Locale myLocale;

        public CreateLocaleAction(@NotNull String title, Locale locale) {
            if (locale == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/configurations/LocaleMenuAction$CreateLocaleAction", "<init>"));
            }
            super(title, null, locale.getFlagImage());
            this.myLocale = locale;
        }

        public void actionPerformed(AnActionEvent e) {
            Module module = LocaleMenuAction.this.myRenderContext.getModule();
            if (module == null) {
                return;
            }
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null) {
                return;
            }
            TranslationDialog dialog = new TranslationDialog(facet, this.myLocale, true);
            if (dialog.showAndGet()) {
                if (dialog.createTranslation()) {
                    new SetLocaleAction(LocaleMenuAction.this.myRenderContext, "", this.myLocale).actionPerformed(e);
                }
                RenderPreviewManager.bumpRevision();
            }
        }
    }

    private class EditTranslationAction
    extends ActionGroup {
        public EditTranslationAction() {
            super("Edit Translation", true);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList children = Lists.newArrayList();
            List locales = LocaleMenuAction.this.getRelevantLocales();
            for (final Locale locale : locales) {
                children.add(new AnAction(LocaleMenuAction.getLocaleLabel(locale, true), null, locale.getFlagImage()){

                    public void actionPerformed(AnActionEvent e) {
                        Module module = LocaleMenuAction.this.myRenderContext.getModule();
                        if (module == null) {
                            return;
                        }
                        AndroidFacet facet = AndroidFacet.getInstance(module);
                        if (facet == null) {
                            return;
                        }
                        TranslationDialog dialog = new TranslationDialog(facet, locale, false);
                        if (dialog.showAndGet()) {
                            if (dialog.createTranslation()) {
                                new SetLocaleAction(LocaleMenuAction.this.myRenderContext, "", locale).actionPerformed(e);
                            }
                            RenderPreviewManager.bumpRevision();
                        }
                    }
                });
            }
            AnAction[] anActionArray = children.toArray(new AnAction[children.size()]);
            if (anActionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/LocaleMenuAction$EditTranslationAction", "getChildren"));
            }
            return anActionArray;
        }
    }

    private class AddTranslationAction
    extends AnAction {
        public AddTranslationAction() {
            super("Add Translation...", null, AndroidIcons.Globe);
        }

        public void actionPerformed(AnActionEvent e) {
            DataContext context = e.getDataContext();
            List<Locale> locales = LocaleMenuAction.getAllLocales();
            locales.removeAll(LocaleMenuAction.this.getRelevantLocales());
            Collections.sort(locales, Locale.LANGUAGE_NAME_COMPARATOR);
            DefaultActionGroup group = new DefaultActionGroup(null, true);
            for (Locale locale : locales) {
                String title = LocaleMenuAction.getLocaleLabel(locale, false);
                group.add((AnAction)new CreateLocaleAction(title, locale));
            }
            JBPopupFactory factory = JBPopupFactory.getInstance();
            ListPopup popup = factory.createActionGroupPopup("Select language to create (type to filter)", (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, null, 10);
            popup.setMinimumSize(new Dimension(LocaleMenuAction.this.getMinWidth(), LocaleMenuAction.this.getMinHeight()));
            JComponent content = popup.getContent();
            Dimension preferredSize = content.getPreferredSize();
            if (preferredSize.height > 300) {
                preferredSize.height = 300;
                content.setPreferredSize(preferredSize);
            }
            RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context);
            popup.show(relativePoint);
        }
    }

    private static class SetLocaleAction
    extends ConfigurationAction {
        private final Locale myLocale;

        public SetLocaleAction(RenderContext renderContext, String title, @NotNull Locale locale) {
            if (locale == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locale", "com/android/tools/idea/configurations/LocaleMenuAction$SetLocaleAction", "<init>"));
            }
            super(renderContext, title, locale.getFlagImage());
            this.myLocale = locale;
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/LocaleMenuAction$SetLocaleAction", "updateConfiguration"));
            }
            if (commit) {
                this.setProjectWideLocale();
            } else {
                configuration.getEditedConfig().setLayoutDirectionQualifier(null);
                configuration.setLocale(this.myLocale);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file, @NotNull VirtualFile old) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/configurations/LocaleMenuAction$SetLocaleAction", "pickedBetterMatch"));
            }
            if (old == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "old", "com/android/tools/idea/configurations/LocaleMenuAction$SetLocaleAction", "pickedBetterMatch"));
            }
            super.pickedBetterMatch(file, old);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideLocale();
            }
        }

        private void setProjectWideLocale() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setLocale(this.myLocale);
                this.myRenderContext.requestRender();
            }
        }
    }
}

