/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFakeFileSystem
extends DummyFileSystem {
    @NonNls
    public static final String PROTOCOL = "android-dummy";
    public static final VirtualFileSystem INSTANCE = new AndroidFakeFileSystem();
    public static final char SEPARATOR = '/';

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/AndroidFakeFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/AndroidFakeFileSystem", "findFileByPath"));
        }
        List components = ContainerUtil.collect(Splitter.on((char)'/').split((CharSequence)path).iterator());
        if (components.size() != 3) {
            return null;
        }
        Module m = AndroidFakeFileSystem.findModule(AndroidFakeFileSystem.findProject((String)components.get(0)), (String)components.get(1));
        if (m == null) {
            return null;
        }
        String name = (String)components.get(2);
        if ("Translations Editor".equals(name)) {
            return StringsVirtualFile.getStringsVirtualFile(m);
        }
        return null;
    }

    @NotNull
    public static String constructPathForFile(@NotNull String fileName, @NotNull Module module) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        String string = Joiner.on((char)'/').join((Object)module.getProject().getName(), (Object)module.getName(), new Object[]{fileName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/AndroidFakeFileSystem", "constructPathForFile"));
        }
        return string;
    }

    @Nullable
    private static Module findModule(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/AndroidFakeFileSystem", "findModule"));
        }
        if (project == null) {
            return null;
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    @Nullable
    private static Project findProject(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/AndroidFakeFileSystem", "findProject"));
        }
        for (Project p : ProjectManager.getInstance().getOpenProjects()) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }
}

