/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;

public class IdeaJavaProject {
    @NotNull
    private final String myModuleName;
    @NotNull
    private final Collection<? extends IdeaContentRoot> myContentRoots;
    @NotNull
    private final List<? extends IdeaDependency> myDependencies;
    @Nullable
    private final ExtIdeaCompilerOutput myCompilerOutput;
    @Nullable
    private final File myBuildFolderPath;

    public IdeaJavaProject(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel extendedModel) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/IdeaJavaProject", "<init>"));
        }
        this.myModuleName = ideaModule.getName();
        this.myContentRoots = IdeaJavaProject.getContentRoots(ideaModule, extendedModel);
        this.myDependencies = IdeaJavaProject.getDependencies(ideaModule);
        this.myCompilerOutput = extendedModel != null ? extendedModel.getCompilerOutput() : null;
        this.myBuildFolderPath = ideaModule.getGradleProject().getBuildDirectory();
    }

    @NotNull
    private static Collection<? extends IdeaContentRoot> getContentRoots(@NotNull IdeaModule ideaModule, @Nullable ModuleExtendedModel extendedModel) {
        if (ideaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaModule", "com/android/tools/idea/gradle/IdeaJavaProject", "getContentRoots"));
        }
        DomainObjectSet contentRoots = null;
        if (extendedModel != null) {
            contentRoots = extendedModel.getContentRoots();
        }
        if (contentRoots != null) {
            DomainObjectSet domainObjectSet = contentRoots;
            if (domainObjectSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaJavaProject", "getContentRoots"));
            }
            return domainObjectSet;
        }
        contentRoots = ideaModule.getContentRoots();
        Object object = contentRoots != null ? contentRoots : Collections.emptyList();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaJavaProject", "getContentRoots"));
        }
        return object;
    }

    @NotNull
    private static List<? extends IdeaDependency> getDependencies(IdeaModule ideaModule) {
        List dependencies = ideaModule.getDependencies().getAll();
        List list = dependencies != null ? dependencies : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaJavaProject", "getDependencies"));
        }
        return list;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaJavaProject", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public Collection<? extends IdeaContentRoot> getContentRoots() {
        Collection<? extends IdeaContentRoot> collection = this.myContentRoots;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaJavaProject", "getContentRoots"));
        }
        return collection;
    }

    @NotNull
    public List<? extends IdeaDependency> getDependencies() {
        List<? extends IdeaDependency> list = this.myDependencies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/IdeaJavaProject", "getDependencies"));
        }
        return list;
    }

    @Nullable
    public ExtIdeaCompilerOutput getCompilerOutput() {
        return this.myCompilerOutput;
    }

    @Nullable
    public File getBuildFolderPath() {
        return this.myBuildFolderPath;
    }
}

