/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.sdklib.repository.FullRevision;
import com.android.tools.idea.stats.Distribution;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DistributionService {
    private static final Logger LOG = Logger.getInstance(DistributionService.class);
    private List<Distribution> myDistributions = null;
    private static final DistributionService INSTANCE = new DistributionService();

    public static DistributionService getInstance() {
        return INSTANCE;
    }

    @Nullable
    public List<Distribution> getDistributions() {
        if (this.myDistributions == null) {
            return null;
        }
        return ImmutableList.copyOf(this.myDistributions);
    }

    public double getSupportedDistributionForApiLevel(int apiLevel) {
        double unsupportedSum = 0.0;
        for (Distribution d : this.myDistributions) {
            if (d.getApiLevel() >= apiLevel) break;
            unsupportedSum += d.getDistributionPercentage();
        }
        return 1.0 - unsupportedSum;
    }

    @Nullable
    public Distribution getDistributionForApiLevel(int apiLevel) {
        for (Distribution d : this.myDistributions) {
            if (d.getApiLevel() != apiLevel) continue;
            return d;
        }
        return null;
    }

    private DistributionService() {
        this.loadFromFile();
    }

    private void loadFromFile() {
        try {
            String jsonString = ResourceUtil.loadText((URL)ResourceUtil.getResource(this.getClass(), (String)"wizardData", (String)"distributions.json"));
            this.myDistributions = DistributionService.loadDistributionsFromJson(jsonString);
        }
        catch (IOException e) {
            LOG.error("Error while trying to load distributions file", (Throwable)e);
        }
    }

    @Nullable
    private static List<Distribution> loadDistributionsFromJson(String jsonString) {
        Type fullRevisionType = new TypeToken<FullRevision>(){}.getType();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(fullRevisionType, (Object)new JsonDeserializer<FullRevision>(){

            public FullRevision deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return FullRevision.parseRevision((String)json.getAsString());
            }
        });
        Gson gson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<Distribution>>(){}.getType();
        try {
            return (List)gson.fromJson(jsonString, listType);
        }
        catch (JsonParseException e) {
            LOG.error("Parse exception while reading distributions.json", (Throwable)e);
            return null;
        }
    }
}

