/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.sdk.SdkLoggerIntegration;
import com.android.tools.idea.welcome.InstallContext;
import com.google.common.base.Objects;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class SdkManagerProgressIndicatorIntegration
extends SdkLoggerIntegration {
    private final ProgressIndicator myIndicator;
    private final InstallContext myContext;
    private final int myComponentCount;
    private int myCompletedOperations;
    private String previousTitle;

    public SdkManagerProgressIndicatorIntegration(@NotNull ProgressIndicator indicator, @NotNull InstallContext context, int componentCount) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/SdkManagerProgressIndicatorIntegration", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/SdkManagerProgressIndicatorIntegration", "<init>"));
        }
        this.myCompletedOperations = -1;
        assert (componentCount > 0);
        this.myIndicator = indicator;
        this.myContext = context;
        this.myComponentCount = componentCount;
    }

    @Override
    protected void setProgress(int progress) {
        double completedOperations = (double)progress / 100.0 + (double)this.myCompletedOperations;
        double progressBar = completedOperations / (double)(this.myComponentCount * 2);
        this.myIndicator.setFraction(progressBar);
    }

    @Override
    protected void setDescription(String description) {
    }

    @Override
    protected void setTitle(String title) {
        if (!StringUtil.isEmptyOrSpaces((String)title) && !Objects.equal((Object)title, (Object)this.previousTitle)) {
            this.previousTitle = title;
            ++this.myCompletedOperations;
            this.myIndicator.setText(this.previousTitle);
            this.setProgress(0);
        }
    }

    @Override
    protected void lineAdded(String string) {
        this.myContext.print(string, ConsoleViewContentType.SYSTEM_OUTPUT);
    }
}

