/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallOperation;
import com.android.tools.idea.welcome.WelcomeUIUtils;
import com.android.tools.idea.welcome.WizardException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.templates.github.ZipUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class UnpackOperation
extends InstallOperation<File, File> {
    public static final String EXTRACT_OPERATION_OUTPUT = "x ";
    public static final String TAR_FLAGS_EXTRACT_UNPACK_VERBOSE_FILENAME_TARGETDIR = "xzvfC";
    public static final String DEFAULT_TAR_EXECUTABLE_PATH = "/usr/bin/tar";
    private final InstallContext myContext;

    public UnpackOperation(@NotNull InstallContext context, double progressShare) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/UnpackOperation", "<init>"));
        }
        super(context, progressShare);
        this.myContext = context;
    }

    @NotNull
    private static File unzip(File archive, File destination, @NotNull InstallContext context, ProgressIndicator progressIndicator) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/UnpackOperation", "unzip"));
        }
        ZipUtil.unzip((ProgressIndicator)progressIndicator, (File)destination, (File)archive, null, null, (boolean)true);
        if (archive.getCanonicalPath().startsWith(context.getTempDirectory().getCanonicalPath())) {
            FileUtil.delete((File)archive);
        }
        File file = destination;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/UnpackOperation", "unzip"));
        }
        return file;
    }

    @NotNull
    private static File untar(File archive, File destination, final InstallContext context, final ProgressIndicator indicator) throws IOException, WizardException {
        File file;
        if (!destination.mkdirs()) {
            throw new WizardException("Cannot create temporary directory to extract files");
        }
        indicator.start();
        indicator.setFraction(0.0);
        try {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{UnpackOperation.getTarExecutablePath(), TAR_FLAGS_EXTRACT_UNPACK_VERBOSE_FILENAME_TARGETDIR, archive.getAbsolutePath(), destination.getAbsolutePath()});
            CapturingAnsiEscapesAwareProcessHandler handler = new CapturingAnsiEscapesAwareProcessHandler(line);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    String string = event.getText();
                    if (!StringUtil.isEmptyOrSpaces((String)string)) {
                        if (string.startsWith(UnpackOperation.EXTRACT_OPERATION_OUTPUT)) {
                            String fileName = string.substring(UnpackOperation.EXTRACT_OPERATION_OUTPUT.length()).trim();
                            indicator.setText(fileName);
                        } else if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                            indicator.setText(string.trim());
                        } else {
                            context.print(string, ConsoleViewContentType.getConsoleViewType((Key)outputType));
                        }
                    }
                }
            });
            if (handler.runProcess().getExitCode() != 0) {
                throw new IOException("Unable to unpack archive file");
            }
            File file2 = destination;
            file = file2;
        }
        catch (ExecutionException e) {
            throw new WizardException("Unable to run tar utility");
        }
        finally {
            indicator.setFraction(1.0);
            indicator.stop();
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/UnpackOperation", "untar"));
        }
        return file;
    }

    @NotNull
    private static String getTarExecutablePath() {
        File file = new File(DEFAULT_TAR_EXECUTABLE_PATH);
        if (file.isFile()) {
            String string = file.getAbsolutePath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/UnpackOperation", "getTarExecutablePath"));
            }
            return string;
        }
        if ("tar" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/UnpackOperation", "getTarExecutablePath"));
        }
        return "tar";
    }

    @Override
    @NotNull
    protected File perform(@NotNull ProgressIndicator indicator, @NotNull File archive) throws WizardException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/UnpackOperation", "perform"));
        }
        if (archive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archive", "com/android/tools/idea/welcome/UnpackOperation", "perform"));
        }
        String fileName = archive.getName();
        ArchiveType archiveType = ArchiveType.fromFileName(fileName);
        this.myContext.print(String.format("Unpacking %s\n", fileName), ConsoleViewContentType.SYSTEM_OUTPUT);
        File dir = new File(this.myContext.getTempDirectory(), fileName + "-unpacked");
        while (true) {
            File file;
            try {
                file = archiveType.unpack(archive, dir, this.myContext, indicator);
            }
            catch (IOException e) {
                String failure = String.format("Unable to unpack file %1$s", fileName);
                String message = WelcomeUIUtils.getMessageWithDetails(failure, e.getMessage());
                this.promptToRetry(message + " Make sure you have enough disk space on destination drive and retry.", message, e);
                continue;
            }
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/UnpackOperation", "perform"));
            }
            return file;
        }
    }

    @Override
    public void cleanup(@NotNull File result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/welcome/UnpackOperation", "cleanup"));
        }
        if (result.exists()) {
            FileUtil.delete((File)result);
        }
    }

    private static enum ArchiveType {
        ZIP,
        TAR,
        NOT_AN_ARCHIVE;

        private static final String[] TAR_EXTENSIONS;
        private static final String[] ZIP_EXTENSIONS;

        @NotNull
        public static ArchiveType fromFileName(@NotNull String fileName) {
            if (fileName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "fromFileName"));
            }
            String lowerCaseName = fileName.toLowerCase();
            if (ArchiveType.extensionIsOneOf(lowerCaseName, TAR_EXTENSIONS)) {
                ArchiveType archiveType = TAR;
                if (archiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "fromFileName"));
                }
                return archiveType;
            }
            if (ArchiveType.extensionIsOneOf(lowerCaseName, ZIP_EXTENSIONS)) {
                ArchiveType archiveType = ZIP;
                if (archiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "fromFileName"));
                }
                return archiveType;
            }
            ArchiveType archiveType = NOT_AN_ARCHIVE;
            if (archiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "fromFileName"));
            }
            return archiveType;
        }

        private static boolean extensionIsOneOf(@NotNull String name, @NotNull String[] extensions) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "extensionIsOneOf"));
            }
            if (extensions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "extensionIsOneOf"));
            }
            for (String extension : extensions) {
                if (!FileUtilRt.extensionEquals((String)name, (String)extension)) continue;
                return true;
            }
            return false;
        }

        public File unpack(@NotNull File archive, @NotNull File destination, @NotNull InstallContext context, @NotNull ProgressIndicator indicator) throws IOException, WizardException {
            if (archive == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "archive", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "unpack"));
            }
            if (destination == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destination", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "unpack"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "unpack"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/welcome/UnpackOperation$ArchiveType", "unpack"));
            }
            switch (this) {
                case ZIP: {
                    return UnpackOperation.unzip(archive, destination, context, indicator);
                }
                case TAR: {
                    return UnpackOperation.untar(archive, destination, context, indicator);
                }
                case NOT_AN_ARCHIVE: {
                    throw new WizardException(String.format("Unrecognized archive file format for file %s", archive.getName()));
                }
            }
            throw new IllegalArgumentException(String.format("Archive %s has format %s", archive.getName(), this.name()));
        }

        static {
            TAR_EXTENSIONS = new String[]{"tgz", "tar", "tar.gz"};
            ZIP_EXTENSIONS = new String[]{"zip"};
        }
    }
}

