/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelBinding;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRuleRegistrar;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionBackedModelCreator<T>
implements ModelCreator {
    private final List<? extends ModelProjection<? super T>> projections;
    private final ModelRuleDescriptor descriptor;
    private final List<ModelReference<?>> inputs;
    private final ModelPath path;
    private final Transformer<? extends T, ? super Inputs> transformer;

    public ProjectionBackedModelCreator(ModelPath path, ModelRuleDescriptor descriptor, List<ModelReference<?>> inputs, List<? extends ModelProjection<? super T>> projections, Transformer<? extends T, ? super Inputs> transformer) {
        this.transformer = transformer;
        this.projections = projections;
        this.path = path;
        this.descriptor = descriptor;
        this.inputs = inputs;
    }

    @Override
    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public ModelPromise getPromise() {
        return new DefaultModelPromise(this.projections);
    }

    @Override
    public ModelAdapter create(Inputs inputs) {
        return new DefaultModelAdapter<Object>(this.projections, this.transformer.transform((Object)inputs));
    }

    @Override
    public List<ModelReference<?>> getInputs() {
        return this.inputs;
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultModelAdapter<T>
    implements ModelAdapter {
        private final List<? extends ModelProjection<? super T>> projections;
        private final T instance;

        DefaultModelAdapter(List<? extends ModelProjection<? super T>> projections, T instance) {
            this.instance = instance;
            this.projections = projections;
        }

        public <B> ModelView<? extends B> asWritable(ModelBinding<B> binding, ModelRuleDescriptor sourceDescriptor, Inputs inputs, ModelRuleRegistrar modelRegistry) {
            for (ModelProjection<B> modelProjection : this.projections) {
                ModelView<B> view = modelProjection.asWritable(binding, sourceDescriptor, inputs, modelRegistry, this.instance);
                if (view == null) continue;
                return view;
            }
            return null;
        }

        public <B> ModelView<? extends B> asReadOnly(ModelType<B> targetType) {
            for (ModelProjection<B> modelProjection : this.projections) {
                ModelView<B> view = modelProjection.asReadOnly(targetType, this.instance);
                if (view == null) continue;
                return view;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultModelPromise<T>
    implements ModelPromise {
        private final List<? extends ModelProjection<? super T>> projections;

        DefaultModelPromise(List<? extends ModelProjection<? super T>> projections) {
            this.projections = projections;
        }

        public <B> boolean asWritable(final ModelType<B> type) {
            return CollectionUtils.any(this.projections, (Spec)new Spec<ModelProjection<? super T>>(){

                public boolean isSatisfiedBy(ModelProjection<? super T> projection) {
                    return projection.canBeViewedAsWritable(type);
                }
            });
        }

        public <B> boolean asReadOnly(final ModelType<B> type) {
            return CollectionUtils.any(this.projections, (Spec)new Spec<ModelProjection<? super T>>(){

                public boolean isSatisfiedBy(ModelProjection<? super T> projection) {
                    return projection.canBeViewedAsReadOnly(type);
                }
            });
        }

        private Iterable<String> collectDescriptions(Transformer<Iterable<String>, ModelProjection<? super T>> transformer) {
            return CollectionUtils.flattenCollections(String.class, (Object[])new Object[]{CollectionUtils.collect(this.projections, transformer)});
        }

        @Override
        public Iterable<String> getWritableTypeDescriptions() {
            return this.collectDescriptions(new Transformer<Iterable<String>, ModelProjection<? super T>>(){

                public Iterable<String> transform(ModelProjection<? super T> projection) {
                    return projection.getWritableTypeDescriptions();
                }
            });
        }

        @Override
        public Iterable<String> getReadableTypeDescriptions() {
            return this.collectDescriptions(new Transformer<Iterable<String>, ModelProjection<? super T>>(){

                public Iterable<String> transform(ModelProjection<? super T> projection) {
                    return projection.getReadableTypeDescriptions();
                }
            });
        }
    }
}

