/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThrowableConvertor;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.api.GithubUserDetailed;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubSettingsPanel {
    private static final String DEFAULT_PASSWORD_TEXT = "************";
    private static final String AUTH_PASSWORD = "Password";
    private static final String AUTH_TOKEN = "Token";
    private static final Logger LOG = GithubUtil.LOG;
    private final GithubSettings mySettings;
    private JTextField myLoginTextField;
    private JPasswordField myPasswordField;
    private JPasswordField myTokenField;
    private JTextPane mySignupTextField;
    private JPanel myPane;
    private JButton myTestButton;
    private JTextField myHostTextField;
    private ComboBox myAuthTypeComboBox;
    private JPanel myCardPanel;
    private JBLabel myAuthTypeLabel;
    private JSpinner myTimeoutSpinner;
    private JButton myCreateTokenButton;
    private boolean myCredentialsModified;

    public GithubSettingsPanel() {
        this.$$$setupUI$$$();
        this.mySettings = GithubSettings.getInstance();
        this.mySignupTextField.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
        this.mySignupTextField.setText("<html>Do not have an account at github.com? <a href=\"https://github.com\">Sign up</a></html>");
        this.mySignupTextField.setBackground(this.myPane.getBackground());
        this.mySignupTextField.setCursor(new Cursor(12));
        this.myAuthTypeLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.myAuthTypeComboBox.addItem((Object)AUTH_PASSWORD);
        this.myAuthTypeComboBox.addItem((Object)AUTH_TOKEN);
        final Project project = ProjectManager.getInstance().getDefaultProject();
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    final GithubAuthData auth = GithubSettingsPanel.this.getAuthData();
                    GithubUser user = GithubUtil.computeValueInModal(project, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubUser, IOException>(){

                        @NotNull
                        public GithubUser convert(ProgressIndicator indicator) throws IOException {
                            GithubUserDetailed githubUserDetailed = GithubUtil.checkAuthData(project, new GithubAuthDataHolder(auth), indicator);
                            if (githubUserDetailed == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel$2$1", "convert"));
                            }
                            return githubUserDetailed;
                        }
                    });
                    if (GithubAuthData.AuthType.TOKEN.equals((Object)GithubSettingsPanel.this.getAuthType())) {
                        GithubNotifications.showInfoDialog(GithubSettingsPanel.this.myPane, "Success", "Connection successful for user " + user.getLogin());
                    } else {
                        GithubNotifications.showInfoDialog(GithubSettingsPanel.this.myPane, "Success", "Connection successful");
                    }
                }
                catch (GithubAuthenticationException ex) {
                    GithubNotifications.showErrorDialog(GithubSettingsPanel.this.myPane, "Login Failure", "Can't login using given credentials: ", ex);
                }
                catch (IOException ex) {
                    GithubNotifications.showErrorDialog(GithubSettingsPanel.this.myPane, "Login Failure", "Can't login: ", ex);
                }
            }
        });
        this.myCreateTokenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GithubSettingsPanel.this.myPasswordField.setText(GithubUtil.computeValueInModal(project, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, String, IOException>(){

                        @NotNull
                        public String convert(ProgressIndicator indicator) throws IOException {
                            String string = GithubUtil.runTaskWithBasicAuthForHost(project, GithubAuthDataHolder.createFromSettings(), indicator, GithubSettingsPanel.this.getHost(), new ThrowableConvertor<GithubConnection, String, IOException>(){

                                @NotNull
                                public String convert(@NotNull GithubConnection connection) throws IOException {
                                    if (connection == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/ui/GithubSettingsPanel$3$1$1", "convert"));
                                    }
                                    String string = GithubApiUtil.getMasterToken(connection, "IntelliJ plugin");
                                    if (string == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel$3$1$1", "convert"));
                                    }
                                    return string;
                                }
                            });
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel$3$1", "convert"));
                            }
                            return string;
                        }
                    }));
                }
                catch (IOException ex) {
                    GithubNotifications.showErrorDialog(GithubSettingsPanel.this.myPane, "Can't create API token", (Exception)ex);
                }
            }
        });
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                GithubSettingsPanel.this.myCredentialsModified = true;
            }
        });
        DocumentAdapter passwordEraser = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!GithubSettingsPanel.this.myCredentialsModified) {
                    GithubSettingsPanel.this.erasePassword();
                }
            }
        };
        this.myHostTextField.getDocument().addDocumentListener((DocumentListener)passwordEraser);
        this.myLoginTextField.getDocument().addDocumentListener((DocumentListener)passwordEraser);
        this.myPasswordField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!GithubSettingsPanel.this.myCredentialsModified && !GithubSettingsPanel.this.getPassword().isEmpty()) {
                    GithubSettingsPanel.this.erasePassword();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.myAuthTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String item = e.getItem().toString();
                    if (GithubSettingsPanel.AUTH_PASSWORD.equals(item)) {
                        ((CardLayout)GithubSettingsPanel.this.myCardPanel.getLayout()).show(GithubSettingsPanel.this.myCardPanel, GithubSettingsPanel.AUTH_PASSWORD);
                    } else if (GithubSettingsPanel.AUTH_TOKEN.equals(item)) {
                        ((CardLayout)GithubSettingsPanel.this.myCardPanel.getLayout()).show(GithubSettingsPanel.this.myCardPanel, GithubSettingsPanel.AUTH_TOKEN);
                    }
                    GithubSettingsPanel.this.erasePassword();
                }
            }
        });
        this.reset();
    }

    private void erasePassword() {
        this.setPassword("");
        this.myCredentialsModified = true;
    }

    public JComponent getPanel() {
        return this.myPane;
    }

    @NotNull
    public String getHost() {
        String string = this.myHostTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getHost"));
        }
        return string;
    }

    @NotNull
    public String getLogin() {
        String string = this.myLoginTextField.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getLogin"));
        }
        return string;
    }

    public void setHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "setHost"));
        }
        this.myHostTextField.setText(host);
    }

    public void setLogin(@Nullable String login) {
        this.myLoginTextField.setText(login);
    }

    @NotNull
    private String getPassword() {
        String string = String.valueOf(this.myPasswordField.getPassword());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getPassword"));
        }
        return string;
    }

    private void setPassword(@NotNull String password) {
        if (password == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "setPassword"));
        }
        this.myPasswordField.setText(StringUtil.isEmpty((String)password) ? null : password);
    }

    @NotNull
    public GithubAuthData.AuthType getAuthType() {
        Object selected = this.myAuthTypeComboBox.getSelectedItem();
        if (AUTH_PASSWORD.equals(selected)) {
            GithubAuthData.AuthType authType = GithubAuthData.AuthType.BASIC;
            if (authType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getAuthType"));
            }
            return authType;
        }
        if (AUTH_TOKEN.equals(selected)) {
            GithubAuthData.AuthType authType = GithubAuthData.AuthType.TOKEN;
            if (authType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getAuthType"));
            }
            return authType;
        }
        LOG.error("GithubSettingsPanel: illegal selection: basic AuthType returned", new String[]{selected.toString()});
        GithubAuthData.AuthType authType = GithubAuthData.AuthType.BASIC;
        if (authType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getAuthType"));
        }
        return authType;
    }

    public void setAuthType(@NotNull GithubAuthData.AuthType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "setAuthType"));
        }
        switch (type) {
            case BASIC: {
                this.myAuthTypeComboBox.setSelectedItem((Object)AUTH_PASSWORD);
                break;
            }
            case TOKEN: {
                this.myAuthTypeComboBox.setSelectedItem((Object)AUTH_TOKEN);
                break;
            }
            default: {
                this.myAuthTypeComboBox.setSelectedItem((Object)AUTH_PASSWORD);
            }
        }
    }

    @NotNull
    public GithubAuthData getAuthData() {
        if (!this.myCredentialsModified) {
            GithubAuthData githubAuthData = this.mySettings.getAuthData();
            if (githubAuthData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getAuthData"));
            }
            return githubAuthData;
        }
        Object selected = this.myAuthTypeComboBox.getSelectedItem();
        if (AUTH_PASSWORD.equals(selected)) {
            GithubAuthData githubAuthData = GithubAuthData.createBasicAuth(this.getHost(), this.getLogin(), this.getPassword());
            if (githubAuthData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getAuthData"));
            }
            return githubAuthData;
        }
        if (AUTH_TOKEN.equals(selected)) {
            GithubAuthData githubAuthData = GithubAuthData.createTokenAuth(this.getHost(), StringUtil.trim((String)this.getPassword()));
            if (githubAuthData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getAuthData"));
            }
            return githubAuthData;
        }
        LOG.error("GithubSettingsPanel: illegal selection: anonymous AuthData created", new String[]{selected.toString()});
        GithubAuthData githubAuthData = GithubAuthData.createAnonymous(this.getHost());
        if (githubAuthData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/ui/GithubSettingsPanel", "getAuthData"));
        }
        return githubAuthData;
    }

    public void setConnectionTimeout(int timeout) {
        this.myTimeoutSpinner.setValue(timeout);
    }

    public int getConnectionTimeout() {
        return ((SpinnerNumberModel)this.myTimeoutSpinner.getModel()).getNumber().intValue();
    }

    public void reset() {
        this.setHost(this.mySettings.getHost());
        this.setLogin(this.mySettings.getLogin());
        this.setPassword(this.mySettings.isAuthConfigured() ? DEFAULT_PASSWORD_TEXT : "");
        this.setAuthType(this.mySettings.getAuthType());
        this.setConnectionTimeout(this.mySettings.getConnectionTimeout());
        this.resetCredentialsModification();
    }

    public void apply() {
        if (this.myCredentialsModified) {
            this.mySettings.setAuthData(this.getAuthData(), true);
        }
        this.mySettings.setConnectionTimeout(this.getConnectionTimeout());
        this.resetCredentialsModification();
    }

    public boolean isModified() {
        return this.myCredentialsModified || !Comparing.equal((String)this.mySettings.getHost(), (String)this.getHost()) || !Comparing.equal((Object)this.mySettings.getConnectionTimeout(), (Object)this.getConnectionTimeout());
    }

    public void resetCredentialsModification() {
        this.myCredentialsModified = false;
    }

    private void createUIComponents() {
        PlainDocument doc = new PlainDocument();
        this.myPasswordField = new JPasswordField(doc, null, 0);
        this.myTokenField = new JPasswordField(doc, null, 0);
        this.myTimeoutSpinner = new JSpinner(new SpinnerNumberModel((Number)5000, Integer.valueOf(0), Integer.valueOf(60000), (Number)500));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        JPanel jPanel;
        ComboBox comboBox;
        JTextField jTextField2;
        JTextPane jTextPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("html.disable", Boolean.FALSE);
        this.mySignupTextField = jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        ((Component)jTextPane).setEnabled(true);
        jTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jPanel2.add((Component)jTextPane, new GridConstraints(2, 1, 1, 3, 0, 1, 2, 0, null, new Dimension(150, 10), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Host:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAuthTypeComboBox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(0, 3, 1, 2, 0, 1, 0, 0, null, new Dimension(120, -1), null));
        this.myCardPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, AUTH_PASSWORD);
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Login:");
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLoginTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Password:");
        jPanel3.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPasswordField jPasswordField = this.myPasswordField;
        jPanel3.add((Component)jPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, AUTH_TOKEN);
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Token:");
        jPanel4.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPasswordField jPasswordField2 = this.myTokenField;
        jPanel4.add((Component)jPasswordField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCreateTokenButton = jButton2 = new JButton();
        jButton2.setText("Create API Token");
        jPanel4.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTestButton = jButton = new JButton();
        jButton.setText("Test");
        jPanel2.add((Component)jButton, new GridConstraints(2, 4, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myAuthTypeLabel = jBLabel = new JBLabel();
        jBLabel.setText("Auth Type:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("html.disable", Boolean.FALSE);
        jPanel2.add((Component)jPanel5, new GridConstraints(4, 0, 1, 5, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Connection timeout:");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner = this.myTimeoutSpinner;
        jPanel5.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("ms");
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(3, 0, 1, 5, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        jBLabel2.setAnchor((JComponent)jBLabel4);
        jBLabel3.setAnchor((JComponent)jBLabel4);
        jBLabel5.setAnchor((JComponent)jBLabel4);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }
}

