/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.DefaultFileInfo;
import org.netbeans.lib.cvsclient.event.ICvsListener;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEntryListener;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.BugLog;

public class DefaultEntryParser
implements ICvsListener,
IEntryListener {
    private final IEventSender eventManager;
    private final ICvsFileSystem cvsFileSystem;

    public DefaultEntryParser(IEventSender eventManager, ICvsFileSystem cvsFileSystem) {
        BugLog.getInstance().assertNotNull(eventManager);
        BugLog.getInstance().assertNotNull(cvsFileSystem);
        this.eventManager = eventManager;
        this.cvsFileSystem = cvsFileSystem;
    }

    @Override
    public void registerListeners(ICvsListenerRegistry listenerRegistry) {
        listenerRegistry.addEntryListener(this);
    }

    @Override
    public void unregisterListeners(ICvsListenerRegistry listenerRegistry) {
        listenerRegistry.removeEntryListener(this);
    }

    @Override
    public void gotEntry(FileObject fileObject, Entry entry) {
        File file = this.cvsFileSystem.getLocalFileSystem().getFile(fileObject);
        this.eventManager.notifyFileInfoListeners(new DefaultFileInfo(fileObject, file));
    }
}

