/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PushConditionInCallAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        if ("Push condition inside call" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "getFamilyName"));
        }
        return "Push condition inside call";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "isAvailable"));
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiConditionalExpression.class);
        if (conditionalExpression == null) {
            return false;
        }
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        if (!(thenExpression instanceof PsiCallExpression)) {
            return false;
        }
        PsiMethod thenMethod = ((PsiCallExpression)thenExpression).resolveMethod();
        PsiExpressionList thenArgsList = ((PsiCallExpression)thenExpression).getArgumentList();
        if (thenArgsList == null) {
            return false;
        }
        PsiExpression[] thenExpressions = thenArgsList.getExpressions();
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        if (!(elseExpression instanceof PsiCallExpression)) {
            return false;
        }
        PsiMethod elseMethod = ((PsiCallExpression)elseExpression).resolveMethod();
        PsiExpressionList elseArgsList = ((PsiCallExpression)elseExpression).getArgumentList();
        if (elseArgsList == null) {
            return false;
        }
        PsiExpression[] elseExpressions = elseArgsList.getExpressions();
        if (thenMethod != elseMethod || thenMethod == null) {
            return false;
        }
        if (thenExpressions.length != elseExpressions.length) {
            return false;
        }
        PsiExpression tExpr = null;
        PsiExpression eExpr = null;
        for (int i = 0; i < thenExpressions.length; ++i) {
            PsiExpression lExpr = thenExpressions[i];
            PsiExpression rExpr = elseExpressions[i];
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lExpr, (PsiElement)rExpr)) continue;
            if (tExpr == null || eExpr == null) {
                tExpr = lExpr;
                eExpr = rExpr;
                continue;
            }
            return false;
        }
        this.setText("Push condition '" + conditionalExpression.getCondition().getText() + "' inside " + (thenMethod.isConstructor() ? "constructor" : "method") + " call");
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiConditionalExpression.class);
        PsiExpression thenExpression = (PsiExpression)conditionalExpression.getThenExpression().copy();
        PsiExpressionList thenArgsList = ((PsiCallExpression)thenExpression).getArgumentList();
        PsiExpression[] thenExpressions = thenArgsList.getExpressions();
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        PsiExpressionList elseArgsList = ((PsiCallExpression)elseExpression).getArgumentList();
        PsiExpression[] elseExpressions = elseArgsList.getExpressions();
        for (int i = 0; i < thenExpressions.length; ++i) {
            PsiExpression lExpr = thenExpressions[i];
            PsiExpression rExpr = elseExpressions[i];
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lExpr, (PsiElement)rExpr)) continue;
            lExpr.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(conditionalExpression.getCondition().getText() + "?" + lExpr.getText() + ":" + rExpr.getText(), (PsiElement)lExpr));
            break;
        }
        CodeStyleManager.getInstance((Project)project).reformat(conditionalExpression.replace((PsiElement)thenExpression));
    }
}

