/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.application.options.emmet.XmlEmmetConfigurable;
import com.intellij.codeInsight.template.HtmlTextContextType;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlZenCodingGeneratorImpl
extends XmlZenCodingGenerator {
    public static final XmlZenCodingGeneratorImpl INSTANCE = new XmlZenCodingGeneratorImpl();

    private static boolean isTrueXml(FileType type) {
        return type == StdFileTypes.XHTML || type == StdFileTypes.JSPX || type == StdFileTypes.XML;
    }

    @Override
    @NotNull
    public String toString(@NotNull XmlTag tag, @NotNull Map<String, String> attributes, boolean hasChildren, @NotNull PsiElement context) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "toString"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "toString"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "toString"));
        }
        FileType fileType = context.getContainingFile().getFileType();
        if (XmlZenCodingGeneratorImpl.isTrueXml(fileType)) {
            XmlZenCodingGeneratorImpl.closeUnclosingTags(tag);
        }
        String string = tag.getContainingFile().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "toString"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildAttributesString(@NotNull Map<String, String> attributes, boolean hasChildren, int numberInIteration, int totalIterations, @Nullable String surroundedText) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "buildAttributesString"));
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String name = entry.getKey();
            String value = ZenCodingUtil.getValue(entry.getValue(), numberInIteration, totalIterations, surroundedText);
            result.append(XmlZenCodingGeneratorImpl.getAttributeString(name, value));
            result.append(' ');
        }
        String string = result.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "buildAttributesString"));
        }
        return string;
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context, boolean wrapping) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "isMyContext"));
        }
        return this.isMyLanguage(context.getLanguage()) && (wrapping || HtmlTextContextType.isInContext(context));
    }

    protected boolean isMyLanguage(Language language) {
        return language instanceof XMLLanguage;
    }

    @Override
    public String getSuffix() {
        return "html";
    }

    @Override
    public boolean isEnabled() {
        return EmmetOptions.getInstance().isEmmetEnabled();
    }

    @Override
    public boolean isAppliedByDefault(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "isAppliedByDefault"));
        }
        return true;
    }

    private static String getAttributeString(String name, String value) {
        return name + "=\"" + value + '\"';
    }

    private static void closeUnclosingTags(@NotNull XmlTag root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "closeUnclosingTags"));
        }
        final ArrayList tagToClose = new ArrayList();
        Project project = root.getProject();
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (!XmlZenCodingGeneratorImpl.isTagClosed(tag)) {
                    tagToClose.add(pointerManager.createSmartPsiElementPointer((PsiElement)tag));
                }
            }
        });
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        for (SmartPsiElementPointer pointer : tagToClose) {
            ASTNode child;
            final XmlTag tag = (XmlTag)pointer.getElement();
            if (tag == null || (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) == null) continue;
            final int offset = child.getTextRange().getStartOffset();
            VirtualFile file = tag.getContainingFile().getVirtualFile();
            if (file == null) continue;
            final Document document = FileDocumentManager.getInstance().getDocument(file);
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    document.replaceString(offset, tag.getTextRange().getEndOffset(), (CharSequence)"/>");
                    documentManager.commitDocument(document);
                }
            });
        }
    }

    private static boolean isTagClosed(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/codeInsight/template/emmet/generators/XmlZenCodingGeneratorImpl", "isTagClosed"));
        }
        ASTNode node = tag.getNode();
        assert (node != null);
        ASTNode emptyTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(node);
        ASTNode endTagEnd = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(node);
        return emptyTagEnd != null || endTagEnd != null;
    }

    @Override
    @Nullable
    public Configurable createConfigurable() {
        return new XmlEmmetConfigurable();
    }
}

