/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.ui.DebuggerEditorImpl;
import com.intellij.debugger.ui.DebuggerRecents;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.EditorTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class DebuggerStatementEditor
extends DebuggerEditorImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.DebuggerStatementEditor");
    private final EditorTextField myEditor;
    private int myRecentIdx = this.getRecentItemsCount();

    public DebuggerStatementEditor(Project project, PsiElement context, @NonNls String recentsId, CodeFragmentFactory factory) {
        super(project, context, recentsId, factory);
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = new EditorTextField(document, project, (FileType)factory.getFileType(), false, false){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setVerticalScrollbarVisible(true);
                editor.setHorizontalScrollbarVisible(true);
                return editor;
            }
        };
        this.setLayout(new BorderLayout());
        this.add(this.addChooseFactoryLabel((JComponent)((Object)this.myEditor), true));
        DefaultActionGroup actionGroup = new DefaultActionGroup(null, false);
        actionGroup.add((AnAction)new ItemAction("PreviousOccurence", this){

            public void actionPerformed(AnActionEvent e) {
                LOG.assertTrue(DebuggerStatementEditor.this.myRecentIdx >= 0);
                DebuggerStatementEditor.this.myRecentIdx += 1;
                DebuggerStatementEditor.this.updateTextFromRecents();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(DebuggerStatementEditor.this.myRecentIdx < DebuggerStatementEditor.this.getRecentItemsCount());
            }
        });
        actionGroup.add((AnAction)new ItemAction("NextOccurence", this){

            public void actionPerformed(AnActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.assertTrue(DebuggerStatementEditor.this.myRecentIdx < DebuggerStatementEditor.this.getRecentItemsCount());
                }
                DebuggerStatementEditor.this.myRecentIdx -= 1;
                DebuggerStatementEditor.this.updateTextFromRecents();
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(DebuggerStatementEditor.this.myRecentIdx > 0);
            }
        });
        this.add((Component)ActionManager.getInstance().createActionToolbar("ComboBoxPager", (ActionGroup)actionGroup, false).getComponent(), "East");
        this.setText(new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, ""));
    }

    private void updateTextFromRecents() {
        List<TextWithImports> recents = this.getRecents();
        LOG.assertTrue(this.myRecentIdx <= recents.size());
        this.setText((TextWithImports)(this.myRecentIdx < recents.size() ? recents.get(this.myRecentIdx) : new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "")));
    }

    private List<TextWithImports> getRecents() {
        LinkedList<TextWithImports> recents = DebuggerRecents.getInstance(this.getProject()).getRecents(this.getRecentsId());
        ArrayList<TextWithImports> reversed = new ArrayList<TextWithImports>(recents.size());
        ListIterator<TextWithImports> it = recents.listIterator(recents.size());
        while (it.hasPrevious()) {
            reversed.add(it.previous());
        }
        return reversed;
    }

    private int getRecentItemsCount() {
        return DebuggerRecents.getInstance(this.getProject()).getRecents(this.getRecentsId()).size();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        Editor editor = this.myEditor.getEditor();
        return editor != null ? editor.getContentComponent() : this.myEditor;
    }

    @Override
    public TextWithImports getText() {
        return this.createItem(this.myEditor.getDocument(), this.getProject());
    }

    @Override
    protected void doSetText(TextWithImports text) {
        this.restoreFactory(text);
        this.myEditor.setNewDocumentAndFileType((FileType)this.getCurrentFactory().getFileType(), this.createDocument(text));
    }

    @Override
    protected void updateEditorUi() {
        Editor editor = this.myEditor.getEditor();
        if (editor != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).updateVisibleHighlighters(editor);
        }
    }

    @Override
    public TextWithImports createText(String text, String importsString) {
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, text, importsString, (FileType)this.getCurrentFactory().getFileType());
    }

    private static abstract class ItemAction
    extends AnAction {
        public ItemAction(String sourceActionName, JComponent component) {
            this.copyFrom(ActionManager.getInstance().getAction(sourceActionName));
            this.registerCustomShortcutSet(this.getShortcutSet(), component);
        }
    }
}

