/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DesignerEditorState
implements FileEditorState {
    private static final String DESIGNER_ZOOM = "ui-designer-zoom";
    private final long myModificationStamp;
    private final double myZoom;

    public DesignerEditorState(VirtualFile file, double zoom) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        this.myModificationStamp = document != null ? document.getModificationStamp() : file.getModificationStamp();
        this.myZoom = zoom;
    }

    public double getZoom() {
        return this.myZoom;
    }

    public int hashCode() {
        int A = (int)(this.myModificationStamp ^ this.myModificationStamp >>> 32);
        long B2 = Double.doubleToLongBits(this.myZoom);
        return 31 * A + (int)(B2 ^ B2 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DesignerEditorState) {
            DesignerEditorState state = (DesignerEditorState)object;
            return this.myModificationStamp == state.myModificationStamp && this.myZoom == state.myZoom;
        }
        return false;
    }

    public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
        return otherState instanceof DesignerEditorState;
    }

    @NotNull
    public static FileEditorState readState(@NotNull Element sourceElement, @NotNull VirtualFile file, double defaultZoom) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/designer/DesignerEditorState", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/designer/DesignerEditorState", "readState"));
        }
        double zoom = defaultZoom;
        try {
            zoom = Double.parseDouble(sourceElement.getAttributeValue(DESIGNER_ZOOM));
        }
        catch (Throwable e) {
            // empty catch block
        }
        DesignerEditorState designerEditorState = new DesignerEditorState(file, zoom);
        if (designerEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/DesignerEditorState", "readState"));
        }
        return designerEditorState;
    }

    public static void writeState(@NotNull FileEditorState state, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/designer/DesignerEditorState", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/designer/DesignerEditorState", "writeState"));
        }
        targetElement.setAttribute(DESIGNER_ZOOM, Double.toString(((DesignerEditorState)state).getZoom()));
    }
}

