/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.SetEditorSettingsAction;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class TextDiffViewerBase
extends ListenerDiffViewerBase {
    @NotNull
    private final TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private final MyFontSizeListener myFontSizeListener;
    @NotNull
    private final MyEditorMouseListener myEditorPopupListener;
    @NotNull
    private List<AnAction> myEditorPopupActions;

    public TextDiffViewerBase(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "<init>"));
        }
        super(context, request);
        this.myFontSizeListener = new MyFontSizeListener();
        this.myEditorPopupListener = new MyEditorMouseListener();
        this.myTextSettings = TextDiffViewerBase.initTextSettings(context);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myEditorPopupActions = this.createEditorPopupActions();
        this.installEditorListeners();
    }

    @Override
    protected void onDispose() {
        this.destroyEditorListeners();
        super.onDispose();
    }

    protected void installEditorListeners() {
        List<? extends EditorEx> editors = this.getEditors();
        for (EditorEx editorEx : editors) {
            editorEx.addEditorMouseListener((EditorMouseListener)this.myEditorPopupListener);
        }
        if (editors.size() > 1) {
            for (EditorEx editorEx : editors) {
                editorEx.addPropertyChangeListener(this.myFontSizeListener);
            }
        }
    }

    protected void destroyEditorListeners() {
        List<? extends EditorEx> editors = this.getEditors();
        for (EditorEx editorEx : editors) {
            editorEx.removeEditorMouseListener((EditorMouseListener)this.myEditorPopupListener);
        }
        if (editors.size() > 1) {
            for (EditorEx editorEx : editors) {
                editorEx.removePropertyChangeListener(this.myFontSizeListener);
            }
        }
    }

    @NotNull
    protected abstract List<? extends EditorEx> getEditors();

    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        List list = ContainerUtil.list((Object[])new AnAction[]{ActionManager.getInstance().getAction("CompareClipboardWithSelection")});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "createEditorPopupActions"));
        }
        return list;
    }

    @NotNull
    protected TextDiffSettingsHolder.TextDiffSettings getTextSettings() {
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = this.myTextSettings;
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "getTextSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    private static TextDiffSettingsHolder.TextDiffSettings initTextSettings(@NotNull DiffContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "initTextSettings"));
        }
        TextDiffSettingsHolder.TextDiffSettings settings = (TextDiffSettingsHolder.TextDiffSettings)context.getUserData(TextDiffSettingsHolder.KEY);
        if (settings == null) {
            settings = TextDiffSettingsHolder.TextDiffSettings.getSettings((String)context.getUserData(DiffUserDataKeysEx.PLACE));
            context.putUserData(TextDiffSettingsHolder.KEY, (Object)settings);
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, new UserDataHolder[]{context})) {
                settings.setIgnorePolicy(IgnorePolicy.DEFAULT);
            }
        }
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = settings;
        if (textDiffSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "initTextSettings"));
        }
        return textDiffSettings;
    }

    @NotNull
    protected boolean[] checkForceReadOnly() {
        int contentCount = this.myRequest.getContents().size();
        boolean[] result = new boolean[contentCount];
        if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.FORCE_READ_ONLY, new UserDataHolder[]{this.myRequest, this.myContext})) {
            Arrays.fill(result, true);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "checkForceReadOnly"));
            }
            return result;
        }
        boolean[] data = (boolean[])this.myRequest.getUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS);
        if (data != null && data.length == contentCount) {
            if (data == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "checkForceReadOnly"));
            }
            return data;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "checkForceReadOnly"));
        }
        return result;
    }

    protected static int getLineCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/util/base/TextDiffViewerBase", "getLineCount"));
        }
        return DiffUtil.getLineCount(document);
    }

    private final class MyEditorMouseListener
    extends EditorPopupHandler {
        private MyEditorMouseListener() {
        }

        @Override
        public void invokePopup(EditorMouseEvent event) {
            if (TextDiffViewerBase.this.myEditorPopupActions.isEmpty()) {
                return;
            }
            DefaultActionGroup group = new DefaultActionGroup(TextDiffViewerBase.this.myEditorPopupActions);
            EditorPopupHandler handler = EditorActionUtil.createEditorPopupHandler((ActionGroup)group);
            handler.invokePopup(event);
        }
    }

    protected abstract class ToggleExpandByDefaultAction
    extends ToggleActionButton
    implements DumbAware {
        public ToggleExpandByDefaultAction() {
            super("Collapse unchanged fragments", AllIcons.Actions.Collapseall);
            this.setEnabledInModalContext(true);
        }

        public boolean isSelected(AnActionEvent e) {
            return !TextDiffViewerBase.this.getTextSettings().isExpandByDefault();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            boolean expand;
            boolean bl = expand = !state;
            if (TextDiffViewerBase.this.getTextSettings().isExpandByDefault() == expand) {
                return;
            }
            TextDiffViewerBase.this.getTextSettings().setExpandByDefault(expand);
            this.expandAll(expand);
        }

        protected abstract void expandAll(boolean var1);
    }

    protected class ToggleAutoScrollAction
    extends ToggleActionButton
    implements DumbAware {
        public ToggleAutoScrollAction() {
            super("Synchronize Scrolling", AllIcons.Actions.SynchronizeScrolling);
            this.setEnabledInModalContext(true);
        }

        public boolean isSelected(AnActionEvent e) {
            return TextDiffViewerBase.this.getTextSettings().isEnableSyncScroll();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            TextDiffViewerBase.this.getTextSettings().setEnableSyncScroll(state);
        }
    }

    protected class IgnorePolicySettingAction
    extends ComboBoxSettingAction<IgnorePolicy> {
        @Override
        protected void applySetting(@NotNull IgnorePolicy setting, @NotNull AnActionEvent e) {
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerBase$IgnorePolicySettingAction", "applySetting"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerBase$IgnorePolicySettingAction", "applySetting"));
            }
            if (this.getCurrentSetting() == setting) {
                return;
            }
            TextDiffViewerBase.this.getTextSettings().setIgnorePolicy(setting);
            this.update(e);
            TextDiffViewerBase.this.rediff();
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            IgnorePolicy ignorePolicy = TextDiffViewerBase.this.getTextSettings().getIgnorePolicy();
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$IgnorePolicySettingAction", "getCurrentSetting"));
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected String getText(@NotNull IgnorePolicy setting) {
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerBase$IgnorePolicySettingAction", "getText"));
            }
            String string = setting.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$IgnorePolicySettingAction", "getText"));
            }
            return string;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            List<IgnorePolicy> list = Arrays.asList(IgnorePolicy.values());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$IgnorePolicySettingAction", "getAvailableSettings"));
            }
            return list;
        }
    }

    protected class HighlightPolicySettingAction
    extends ComboBoxSettingAction<HighlightPolicy> {
        @Override
        protected void applySetting(@NotNull HighlightPolicy setting, @NotNull AnActionEvent e) {
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerBase$HighlightPolicySettingAction", "applySetting"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerBase$HighlightPolicySettingAction", "applySetting"));
            }
            if (this.getCurrentSetting() == setting) {
                return;
            }
            TextDiffViewerBase.this.getTextSettings().setHighlightPolicy(setting);
            this.update(e);
            TextDiffViewerBase.this.rediff();
        }

        @Override
        @NotNull
        protected HighlightPolicy getCurrentSetting() {
            HighlightPolicy highlightPolicy = TextDiffViewerBase.this.getTextSettings().getHighlightPolicy();
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$HighlightPolicySettingAction", "getCurrentSetting"));
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected String getText(@NotNull HighlightPolicy setting) {
            if (setting == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerBase$HighlightPolicySettingAction", "getText"));
            }
            String string = setting.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$HighlightPolicySettingAction", "getText"));
            }
            return string;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getAvailableSettings() {
            List<HighlightPolicy> list = Arrays.asList(HighlightPolicy.values());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$HighlightPolicySettingAction", "getAvailableSettings"));
            }
            return list;
        }
    }

    protected static abstract class ComboBoxSettingAction<T>
    extends ComboBoxAction
    implements DumbAware {
        private DefaultActionGroup myChildren;

        public ComboBoxSettingAction() {
            this.setEnabledInModalContext(true);
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setText(this.getText(this.getCurrentSetting()));
        }

        @NotNull
        public DefaultActionGroup getPopupGroup() {
            this.initChildren();
            DefaultActionGroup defaultActionGroup = this.myChildren;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$ComboBoxSettingAction", "getPopupGroup"));
            }
            return defaultActionGroup;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            this.initChildren();
            DefaultActionGroup defaultActionGroup = this.myChildren;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$ComboBoxSettingAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        private void initChildren() {
            if (this.myChildren == null) {
                this.myChildren = new DefaultActionGroup();
                for (T setting : this.getAvailableSettings()) {
                    this.myChildren.add((AnAction)new MyAction(setting));
                }
            }
        }

        @NotNull
        protected abstract List<T> getAvailableSettings();

        @NotNull
        protected abstract String getText(@NotNull T var1);

        @NotNull
        protected abstract T getCurrentSetting();

        protected abstract void applySetting(@NotNull T var1, @NotNull AnActionEvent var2);

        private class MyAction
        extends AnAction
        implements DumbAware {
            @NotNull
            private final T mySetting;

            public MyAction(T setting) {
                if (setting == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setting", "com/intellij/diff/tools/util/base/TextDiffViewerBase$ComboBoxSettingAction$MyAction", "<init>"));
                }
                super(ComboBoxSettingAction.this.getText(setting));
                this.setEnabledInModalContext(true);
                this.mySetting = setting;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/base/TextDiffViewerBase$ComboBoxSettingAction$MyAction", "actionPerformed"));
                }
                ComboBoxSettingAction.this.applySetting(this.mySetting, e);
            }
        }
    }

    protected class MySetEditorSettingsAction
    extends SetEditorSettingsAction {
        public MySetEditorSettingsAction() {
            super(TextDiffViewerBase.this.myTextSettings);
        }

        @Override
        @NotNull
        public List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = TextDiffViewerBase.this.getEditors();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/TextDiffViewerBase$MySetEditorSettingsAction", "getEditors"));
            }
            return list;
        }
    }

    private class MyFontSizeListener
    implements PropertyChangeListener {
        private boolean myDuringUpdate = false;

        private MyFontSizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            int fontSize = (Integer)evt.getNewValue();
            for (EditorEx editorEx : TextDiffViewerBase.this.getEditors()) {
                if (evt.getSource() == editorEx) continue;
                this.updateEditor(editorEx, fontSize);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateEditor(@NotNull EditorEx editor, int fontSize) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/base/TextDiffViewerBase$MyFontSizeListener", "updateEditor"));
            }
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(fontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }
    }
}

