/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiInspectorAction
extends ToggleAction
implements DumbAware {
    private UiInspector myInspector = null;

    public boolean isSelected(AnActionEvent e) {
        return this.myInspector != null;
    }

    public void setSelected(AnActionEvent e, boolean state) {
        if (state) {
            UiInspectorNotification[] existing;
            if (this.myInspector == null) {
                this.myInspector = new UiInspector();
                Toolkit.getDefaultToolkit().addAWTEventListener(this.myInspector, 16L);
            }
            if ((existing = (UiInspectorNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UiInspectorNotification.class, null)).length == 0) {
                Notifications.Bus.notify((Notification)new UiInspectorNotification(), null);
            }
        } else if (this.myInspector != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myInspector);
            Disposer.dispose((Disposable)this.myInspector);
            this.myInspector = null;
        }
    }

    private static class UiInspector
    implements AWTEventListener,
    Disposable {
        private Map<JComponent, InspectorWindow> myComponentToInspector = new HashMap();

        private UiInspector() {
        }

        public void dispose() {
            for (JComponent c : this.myComponentToInspector.keySet()) {
                InspectorWindow window = this.myComponentToInspector.get(c);
                window.close();
            }
            this.myComponentToInspector.clear();
        }

        public void showInspector(@NotNull JComponent c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiInspectorAction$UiInspector", "showInspector"));
            }
            InspectorWindow window = this.myComponentToInspector.get(c);
            if (window != null) {
                window.setVisible(true);
                window.toFront();
            } else {
                window = new InspectorWindow(c, this);
                this.myComponentToInspector.put(c, window);
                window.pack();
                window.setVisible(true);
                window.toFront();
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            MouseEvent me;
            if (event instanceof MouseEvent && (me = (MouseEvent)event).isAltDown() && me.isControlDown()) {
                switch (me.getID()) {
                    case 500: {
                        if (me.getClickCount() != 1 || me.isPopupTrigger()) break;
                        Object source = me.getSource();
                        if (source instanceof JComponent) {
                            this.showInspector((JComponent)source);
                        } else {
                            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                            if (owner instanceof JComponent) {
                                this.showInspector((JComponent)owner);
                            }
                        }
                        me.consume();
                        break;
                    }
                }
            }
        }

        public void closed(InspectorWindow inspectorWindow) {
            JComponent c = inspectorWindow.getComponent();
            this.myComponentToInspector.remove(c);
        }
    }

    private static class InspectorTableModel
    extends AbstractTableModel {
        private static final String[] JCOMPONENT_METHODS = new String[]{"getLocation", "getLocationOnScreen", "getSize", "isOpaque", "getBorder", "getForeground", "getBackground", "getFont", "getMinimumSize", "getMaximumSize", "getPreferredSize", "getAlignmentX", "getAlignmentY", "getText", "isEditable", "getIcon", "getTooltipText", "getToolTipText", "getVisibleRect", "getLayout", "isFocusCycleRoot", "isValid", "isDisplayable", "isShowing", "isEnabled", "isLightweight", "isFocusable", "isFocusOwner"};
        private Component myComponent;
        private List<PropertyBean> myProperties;

        public InspectorTableModel(@NotNull Component c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiInspectorAction$InspectorTableModel", "<init>"));
            }
            this.myProperties = new ArrayList<PropertyBean>();
            this.myComponent = c;
            this.fillTable();
        }

        private void fillTable() {
            Class<?> cls = this.myComponent.getClass();
            for (String methodName : JCOMPONENT_METHODS) {
                try {
                    Method method = cls.getMethod(methodName, new Class[0]);
                    Object result = method.invoke((Object)this.myComponent, new Object[0]);
                    String propertyName = methodName.startsWith("is") ? StringUtil.decapitalize((String)methodName.substring(2)) : StringUtil.decapitalize((String)methodName.substring(3));
                    this.myProperties.add(new PropertyBean(propertyName, result, true));
                }
                catch (NoSuchMethodException e) {
                }
                catch (InvocationTargetException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }

        @Override
        @Nullable
        public Object getValueAt(int row, int column) {
            PropertyBean bean = this.myProperties.get(row);
            if (bean != null) {
                switch (column) {
                    case 0: {
                        return bean.propertyName;
                    }
                }
                return bean.propertyValue;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.myProperties.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return columnIndex == 0 ? "Property" : "Value";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? String.class : Object.class;
        }

        public void refresh() {
            this.myProperties.clear();
            this.fillTable();
            this.fireTableDataChanged();
        }
    }

    private static class PropertyBean {
        public String propertyName;
        public Object propertyValue;
        public boolean isComponentMethod;

        private PropertyBean(String propertyName, Object propertyValue, boolean componentMethod) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.isComponentMethod = componentMethod;
        }
    }

    private static class ObjectRenderer
    extends JLabel
    implements Renderer<Object> {
        private ObjectRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }

        @Override
        public JComponent setValue(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$ObjectRenderer", "setValue"));
            }
            this.setText(String.valueOf(value).replace('\n', ' '));
            return this;
        }
    }

    private static class IconRenderer
    extends JLabel
    implements Renderer<Icon> {
        private IconRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Icon value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$IconRenderer", "setValue"));
            }
            this.setIcon(value);
            return this;
        }
    }

    private static class BooleanRenderer
    extends JLabel
    implements Renderer<Boolean> {
        private BooleanRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Boolean value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$BooleanRenderer", "setValue"));
            }
            this.setText(value != false ? "Yes" : "No");
            return this;
        }
    }

    private static class FontRenderer
    extends JLabel
    implements Renderer<Font> {
        private FontRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Font value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$FontRenderer", "setValue"));
            }
            this.setText(value.getFontName() + " (" + value.getFamily() + "), " + value.getSize() + "px");
            return this;
        }
    }

    private static class ColorRenderer
    extends JLabel
    implements Renderer<Color> {
        private ColorRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Color value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$ColorRenderer", "setValue"));
            }
            this.setText("r:" + value.getRed() + ", g:" + value.getGreen() + ", b:" + value.getBlue());
            this.setIcon((Icon)new ColorIcon(13, 11, value, true));
            return this;
        }
    }

    private static class RectangleRenderer
    extends JLabel
    implements Renderer<Rectangle> {
        private RectangleRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Rectangle value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$RectangleRenderer", "setValue"));
            }
            this.setText(String.valueOf(value.x) + ":" + value.y + ", " + value.width + " x " + value.height);
            return this;
        }
    }

    private static class InsetsRenderer
    extends JLabel
    implements Renderer<Insets> {
        private InsetsRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Insets value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$InsetsRenderer", "setValue"));
            }
            this.setText("top: " + value.top + " left:" + value.left + " bottom:" + value.bottom + " right:" + value.right);
            return this;
        }
    }

    private static class DimensionRenderer
    extends JLabel
    implements Renderer<Dimension> {
        private DimensionRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Dimension value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$DimensionRenderer", "setValue"));
            }
            this.setText(String.valueOf(value.width) + " x " + value.height);
            return this;
        }
    }

    private static class PointRenderer
    extends JLabel
    implements Renderer<Point> {
        private PointRenderer() {
        }

        @Override
        public JComponent setValue(@NotNull Point value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/UiInspectorAction$PointRenderer", "setValue"));
            }
            this.setText(String.valueOf(value.x) + ':' + value.y);
            return this;
        }
    }

    private static interface Renderer<T> {
        public JComponent setValue(@NotNull T var1);
    }

    private static class ValueCellRenderer
    implements TableCellRenderer {
        private static final Map<Class, Renderer> RENDERERS = ContainerUtil.newHashMap();
        private static final Renderer<Object> DEFAULT_RENDERER;
        private static final JLabel NULL_RENDERER;

        private ValueCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                NULL_RENDERER.setOpaque(isSelected);
                NULL_RENDERER.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                NULL_RENDERER.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return NULL_RENDERER;
            }
            Renderer renderer = (Renderer)ObjectUtils.notNull(ValueCellRenderer.getRenderer(value.getClass()), DEFAULT_RENDERER);
            JComponent result = renderer.setValue(value);
            result.setOpaque(isSelected);
            result.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            result.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return result;
        }

        @Nullable
        private static Renderer<Object> getRenderer(Class clazz) {
            Class<?>[] interfaces;
            if (clazz == null) {
                return null;
            }
            Renderer<Object> renderer = RENDERERS.get(clazz);
            if (renderer != null) {
                return renderer;
            }
            for (Class<?> aClass : interfaces = clazz.getInterfaces()) {
                renderer = ValueCellRenderer.getRenderer(aClass);
                if (renderer == null) continue;
                return renderer;
            }
            if ((clazz = clazz.getSuperclass()) != null) {
                return ValueCellRenderer.getRenderer(clazz);
            }
            return null;
        }

        static {
            RENDERERS.put(Point.class, new PointRenderer());
            RENDERERS.put(Dimension.class, new DimensionRenderer());
            RENDERERS.put(Insets.class, new InsetsRenderer());
            RENDERERS.put(Rectangle.class, new RectangleRenderer());
            RENDERERS.put(Color.class, new ColorRenderer());
            RENDERERS.put(Font.class, new FontRenderer());
            RENDERERS.put(Boolean.class, new BooleanRenderer());
            RENDERERS.put(Icon.class, new IconRenderer());
            DEFAULT_RENDERER = new ObjectRenderer();
            NULL_RENDERER = new JLabel("-");
        }
    }

    private static class DimensionsComponent
    extends JComponent {
        private Component myComponent;
        private int myWidth;
        private int myHeight;
        private Border myBorder;
        private Insets myInsets;

        private DimensionsComponent(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiInspectorAction$DimensionsComponent", "<init>"));
            }
            this.myComponent = component;
            this.setOpaque(true);
            this.setBackground((Color)JBColor.WHITE);
            this.setBorder(new EmptyBorder(5, 0, 5, 0));
            this.setFont(new JLabel().getFont().deriveFont(0, 9.0f));
            this.update();
        }

        public void update() {
            this.myWidth = this.myComponent.getWidth();
            this.myHeight = this.myComponent.getHeight();
            if (this.myComponent instanceof JComponent) {
                this.myBorder = ((JComponent)this.myComponent).getBorder();
                this.myInsets = ((JComponent)this.myComponent).getInsets();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle bounds = this.getBounds();
            g2d.setColor(this.getBackground());
            Insets insets = this.getInsets();
            g2d.fillRect(insets.left, insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
            g2d.setColor(this.getForeground());
            String sizeString = String.valueOf(this.myWidth) + " x " + this.myHeight;
            FontMetrics fm = g2d.getFontMetrics();
            int sizeWidth = fm.stringWidth(sizeString);
            int fontHeight = fm.getHeight();
            g2d.drawString(sizeString, bounds.width / 2 - sizeWidth / 2, bounds.height / 2 + fontHeight / 2);
            g2d.setColor((Color)JBColor.GRAY);
            int innerX = bounds.width / 2 - sizeWidth / 2 - 20;
            int innerY = bounds.height / 2 - fontHeight / 2 - 5;
            int innerWidth = sizeWidth + 40;
            int innerHeight = fontHeight + 10;
            g2d.drawRect(innerX, innerY, innerWidth, innerHeight);
            Insets borderInsets = null;
            if (this.myBorder != null) {
                borderInsets = this.myBorder.getBorderInsets(this.myComponent);
            }
            UIUtil.drawDottedRectangle((Graphics)g2d, (int)(innerX - 15), (int)(innerY - 15), (int)(innerX - 15 + innerWidth + 30), (int)(innerY - 15 + innerHeight + 30));
            DimensionsComponent.drawInsets(g2d, fm, "border", borderInsets, 15, fontHeight, innerX, innerY, innerWidth, innerHeight);
            g2d.drawRect(innerX - 30, innerY - 30, innerWidth + 60, innerHeight + 60);
            DimensionsComponent.drawInsets(g2d, fm, "insets", this.myInsets, 30, fontHeight, innerX, innerY, innerWidth, innerHeight);
        }

        private static void drawInsets(Graphics2D g2d, FontMetrics fm, String name, Insets insets, int offset, int fontHeight, int innerX, int innerY, int innerWidth, int innerHeight) {
            g2d.setColor((Color)JBColor.BLACK);
            g2d.drawString(name, innerX - offset + 5, innerY - offset + fontHeight);
            g2d.setColor((Color)JBColor.GRAY);
            int dashWidth = fm.stringWidth("-");
            if (insets != null) {
                String top = Integer.toString(insets.top);
                String bottom = Integer.toString(insets.bottom);
                String left = Integer.toString(insets.left);
                String right = Integer.toString(insets.right);
                g2d.drawString(top, innerX - offset + ((innerWidth + offset * 2) / 2 - fm.stringWidth(top) / 2), innerY - offset + fontHeight);
                g2d.drawString(bottom, innerX - offset + ((innerWidth + offset * 2) / 2 - fm.stringWidth(bottom) / 2), innerY - offset + innerHeight + offset * 2 - 8 + fontHeight / 2);
                g2d.drawString(left, innerX - offset + 7 - fm.stringWidth(left) / 2, innerY - offset + (innerHeight + offset * 2) / 2 + fontHeight / 2);
                g2d.drawString(right, innerX + innerWidth + offset - 7 - fm.stringWidth(right) / 2, innerY - offset + (innerHeight + offset * 2) / 2 + fontHeight / 2);
            } else {
                g2d.drawString("-", innerX - offset + ((innerWidth + offset * 2) / 2 - dashWidth / 2), innerY - offset + fontHeight);
                g2d.drawString("-", innerX - offset + ((innerWidth + offset * 2) / 2 - dashWidth / 2), innerY - offset + innerHeight + offset * 2 - 8 + fontHeight / 2);
                g2d.drawString("-", innerX - offset + 7 - dashWidth / 2, innerY - offset + (innerHeight + offset * 2) / 2 + fontHeight / 2);
                g2d.drawString("-", innerX + innerWidth + offset - 7 - dashWidth / 2, innerY - offset + (innerHeight + offset * 2) / 2 + fontHeight / 2);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(120, 120);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(150, 150);
        }
    }

    private static class InspectorTable
    extends JPanel {
        private JLabel myTitleLabel;
        private InspectorTableModel myModel;
        private DimensionsComponent myDimensionComponent;

        private InspectorTable(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiInspectorAction$InspectorTable", "<init>"));
            }
            this.setLayout(new BorderLayout());
            this.myTitleLabel = new JLabel(component.getClass().getCanonicalName(), 0);
            this.myModel = new InspectorTableModel(component);
            StripeTable table = new StripeTable((TableModel)this.myModel);
            TableColumnModel columnModel = table.getColumnModel();
            TableColumn propertyColumn = columnModel.getColumn(0);
            propertyColumn.setMinWidth(150);
            propertyColumn.setMaxWidth(150);
            propertyColumn.setResizable(false);
            TableColumn valueColumn = columnModel.getColumn(1);
            valueColumn.setMinWidth(200);
            valueColumn.setResizable(false);
            valueColumn.setCellRenderer(new ValueCellRenderer());
            table.setAutoResizeMode(3);
            this.add((Component)this.myTitleLabel, "North");
            this.add((Component)new JBScrollPane((Component)table), "Center");
            this.myDimensionComponent = new DimensionsComponent(component);
            this.add((Component)this.myDimensionComponent, "South");
        }

        public void refresh() {
            this.myModel.refresh();
            this.myDimensionComponent.update();
            this.myDimensionComponent.repaint();
        }
    }

    private static class HighlightComponent
    extends JComponent {
        private Color myColor;

        private HighlightComponent(@NotNull Color c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiInspectorAction$HighlightComponent", "<init>"));
            }
            this.myColor = c;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            g2d.setColor(this.myColor);
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Rectangle r = this.getBounds();
            g2d.fillRect(0, 0, r.width, r.height);
            g2d.setColor(this.myColor.darker());
            g2d.drawRect(0, 0, r.width - 1, r.height - 1);
            g2d.setComposite(old);
            g2d.setColor(oldColor);
        }
    }

    private static abstract class HierarchyTree
    extends JTree
    implements TreeSelectionListener {
        private final JComponent myComponent;

        private HierarchyTree(JComponent c) {
            this.myComponent = c;
            this.setModel(HierarchyTree.buildModel(c));
            this.setCellRenderer(new ComponentTreeCellRenderer());
            this.getSelectionModel().addTreeSelectionListener(this);
        }

        public void expandPath() {
            TreeUtil.expandAll((JTree)this);
            int count = this.getRowCount();
            ComponentNode node = new ComponentNode(this.myComponent, this.myComponent.getParent());
            for (int i = 0; i < count; ++i) {
                TreePath row = this.getPathForRow(i);
                if (!row.getLastPathComponent().equals(node)) continue;
                this.setSelectionPath(row);
                this.scrollPathToVisible(this.getSelectionPath());
                break;
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path == null) {
                this.onComponentChanged(null);
                return;
            }
            Object component = path.getLastPathComponent();
            if (component instanceof ComponentNode) {
                Component c = ((ComponentNode)component).getOwnComponent();
                this.onComponentChanged(c);
            }
        }

        private static TreeModel buildModel(JComponent c) {
            return new DefaultTreeModel(new ComponentNode(c, null));
        }

        public abstract void onComponentChanged(Component var1);

        private static class ComponentNode
        extends DefaultMutableTreeNode {
            private final Component myParent;
            private final Component myToSelect;

            private ComponentNode(Object userObject, Component parent) {
                super(userObject);
                this.myParent = parent == null ? SwingUtilities.getWindowAncestor((Component)userObject) : parent;
                this.myToSelect = (Component)userObject;
                this.children = ComponentNode.prepareChildren(this.myToSelect, parent);
            }

            public Component getOwnComponent() {
                return this.myParent;
            }

            public Component getToSelect() {
                return this.myToSelect;
            }

            @Override
            public String toString() {
                return this.myParent.getClass().getName();
            }

            public boolean equals(Object obj) {
                return obj instanceof ComponentNode && ((ComponentNode)obj).getOwnComponent() == this.getOwnComponent();
            }

            private static Vector prepareChildren(Component toSelect, Component parent) {
                Vector<ComponentNode> result;
                block3: {
                    block2: {
                        result = new Vector<ComponentNode>();
                        if (parent != null) break block2;
                        Window root = SwingUtilities.windowForComponent(toSelect);
                        for (Component component : root.getComponents()) {
                            result.add(new ComponentNode((Object)toSelect, component));
                        }
                        break block3;
                    }
                    if (!(parent instanceof Container)) break block3;
                    for (Component component : ((Container)parent).getComponents()) {
                        result.add(new ComponentNode((Object)toSelect, component));
                    }
                }
                return result;
            }
        }
    }

    private static class ComponentTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private ComponentTreeCellRenderer() {
            this.setOpaque(true);
            this.setFont((Font)JBUI.Fonts.label((float)11.0f));
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color background;
            Color foreground = selected ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground();
            Color color = background = selected ? UIUtil.getTreeSelectionBackground() : null;
            if (value instanceof HierarchyTree.ComponentNode) {
                HierarchyTree.ComponentNode componentNode = (HierarchyTree.ComponentNode)value;
                Component component = componentNode.getOwnComponent();
                String name = component.getName();
                if (StringUtil.isEmpty((String)name) && (name = component.getClass().getSimpleName()).isEmpty()) {
                    name = component.getClass().getSuperclass().getSimpleName();
                }
                if (!selected) {
                    if (!component.isVisible()) {
                        foreground = JBColor.GRAY;
                    } else if (component.getWidth() == 0 || component.getHeight() == 0) {
                        foreground = new Color(128, 10, 0);
                    } else if (component.getPreferredSize() != null && (component.getSize().width < component.getPreferredSize().width || component.getSize().height < component.getPreferredSize().height)) {
                        foreground = PlatformColors.BLUE;
                    }
                    if (componentNode.getToSelect() == componentNode.getOwnComponent()) {
                        background = new Color(31, 128, 8, 58);
                    }
                }
                this.setText(name);
            }
            this.setForeground(foreground);
            this.setBackground(background);
            return this;
        }
    }

    private static class InspectorWindow
    extends JDialog {
        private InspectorTable myInspectorTable;
        private UiInspector myUiInspector;
        private JComponent myComponent;
        private boolean myHighlighted;
        private HighlightComponent myHighlightComponent;
        private HierarchyTree myHierarchyTree;
        private final JPanel myWrapperPanel;

        private InspectorWindow(@NotNull JComponent component, UiInspector uiInspector) throws HeadlessException {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/UiInspectorAction$InspectorWindow", "<init>"));
            }
            super(InspectorWindow.findWindow(component));
            this.myHighlighted = true;
            Window window = InspectorWindow.findWindow(component);
            this.setModal(window instanceof JDialog && ((JDialog)window).isModal());
            this.myComponent = component;
            this.myUiInspector = uiInspector;
            this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setDefaultCloseOperation(2);
            this.setLayout(new BorderLayout());
            String simpleName = component.getClass().getSimpleName();
            this.setTitle(simpleName.length() == 0 ? component.getClass().getName() : simpleName);
            JToolBar bar = new JToolBar(0);
            bar.setFloatable(false);
            bar.add(new AbstractAction("Highlight", AllIcons.Toolbar.Unknown){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InspectorWindow.this.myHighlighted = !InspectorWindow.this.myHighlighted;
                    InspectorWindow.this.highlight(InspectorWindow.this.myComponent, !InspectorWindow.this.myHighlighted);
                }

                @Override
                public boolean isEnabled() {
                    return InspectorWindow.this.myComponent.isVisible();
                }
            });
            bar.addSeparator();
            bar.add(new AbstractAction("Refresh", AllIcons.Actions.Refresh){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InspectorWindow.this.getCurrentTable().refresh();
                }

                @Override
                public boolean isEnabled() {
                    return InspectorWindow.this.myComponent.isVisible();
                }
            });
            this.add((Component)bar, "North");
            this.myWrapperPanel = new JPanel(new BorderLayout());
            this.add((Component)new JLabel(component.getClass().getName()), "South");
            this.myInspectorTable = new InspectorTable(component);
            this.myHierarchyTree = new HierarchyTree(component){

                @Override
                public void onComponentChanged(Component c) {
                    InspectorWindow.this.highlight(InspectorWindow.this.myComponent, true);
                    InspectorWindow.this.switchInfo(c);
                    if (InspectorWindow.this.myHighlighted) {
                        InspectorWindow.this.highlight(c, false);
                    }
                }
            };
            this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            JSplitPane splitPane = new JSplitPane();
            splitPane.setDividerLocation(0.5);
            splitPane.setRightComponent(this.myWrapperPanel);
            JBScrollPane pane = new JBScrollPane((Component)this.myHierarchyTree);
            splitPane.setLeftComponent((Component)pane);
            this.add((Component)splitPane, "Center");
            this.myHierarchyTree.expandPath();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    InspectorWindow.this.myUiInspector.closed(InspectorWindow.this);
                    InspectorWindow.this.close();
                }
            });
            this.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InspectorWindow.this.myUiInspector.closed(InspectorWindow.this);
                    InspectorWindow.this.close();
                    InspectorWindow.this.setVisible(false);
                    InspectorWindow.this.dispose();
                }
            });
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CLOSE");
        }

        private static Window findWindow(JComponent component) {
            DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
            if (dialogWrapper != null) {
                return dialogWrapper.getPeer().getWindow();
            }
            return null;
        }

        private InspectorTable getCurrentTable() {
            return this.myInspectorTable;
        }

        private void switchInfo(Component c) {
            this.myWrapperPanel.removeAll();
            if (c != null) {
                this.myInspectorTable = new InspectorTable(c);
                this.myWrapperPanel.add((Component)this.myInspectorTable, "Center");
            }
            this.myWrapperPanel.revalidate();
            this.myWrapperPanel.repaint();
        }

        public void close() {
            this.highlight(this.myComponent, true);
            this.myComponent = null;
        }

        private void highlight(Component c, boolean clear) {
            JRootPane rootPane;
            if (c != null && (rootPane = SwingUtilities.getRootPane(c)) != null) {
                JComponent glassPane = (JComponent)rootPane.getGlassPane();
                if (clear) {
                    if (this.myHighlightComponent != null) {
                        glassPane.remove(this.myHighlightComponent);
                        this.myHighlightComponent = null;
                        glassPane.revalidate();
                        glassPane.repaint();
                    }
                } else {
                    this.myHighlightComponent = new HighlightComponent((Color)JBColor.GREEN);
                    Point pt = SwingUtilities.convertPoint(c, new Point(0, 0), rootPane);
                    this.myHighlightComponent.setBounds(pt.x, pt.y, c.getWidth(), c.getHeight());
                    glassPane.add(this.myHighlightComponent);
                    glassPane.revalidate();
                    glassPane.repaint();
                }
            }
        }

        public JComponent getComponent() {
            return this.myComponent;
        }
    }

    private static class UiInspectorNotification
    extends Notification {
        private UiInspectorNotification() {
            super("System Messages", "UI Inspector", "Control-Alt-Click to view component info!", NotificationType.INFORMATION);
        }
    }
}

