/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsUtil {
    private NotificationsUtil() {
    }

    public static String buildHtml(@NotNull Notification notification, @Nullable String style) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        String result = "";
        if (style != null) {
            result = result + "<div style=\"" + style + "\">";
        }
        result = result + "<b color=\"#" + ColorUtil.toHex((Color)NotificationsUtil.getMessageType(notification).getTitleForeground()) + "\">" + notification.getTitle() + "</b>" + "<p>" + notification.getContent() + "</p>";
        if (style != null) {
            result = result + "</div>";
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result);
    }

    public static String buildHtml(@NotNull String title, @NotNull String content, @Nullable String style) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        String result = "";
        if (style != null) {
            result = result + "<div style=\"" + style + "\">";
        }
        result = result + "<b>" + title + "</b><p>" + content + "</p>";
        if (style != null) {
            result = result + "</div>";
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result);
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "wrapListener"));
        }
        NotificationListener listener = notification.getListener();
        if (listener == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener listener1;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification.getListener()) != null) {
                    listener1.hyperlinkUpdate(notification, e);
                }
            }
        };
    }

    public static Icon getIcon(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "getIcon"));
        }
        Icon icon = notification.getIcon();
        if (icon == null) {
            icon = NotificationsUtil.getMessageType(notification).getDefaultIcon();
        }
        return icon;
    }

    public static MessageType getMessageType(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "getMessageType"));
        }
        switch (notification.getType()) {
            case WARNING: {
                return MessageType.WARNING;
            }
            case ERROR: {
                return MessageType.ERROR;
            }
        }
        return MessageType.INFO;
    }

    public static Color getBackground(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "getBackground"));
        }
        return NotificationsUtil.getMessageType(notification).getPopupBackground();
    }

    public static Color getBorderColor(Notification notification) {
        switch (notification.getType()) {
            case ERROR: {
                return new JBColor(Color.gray, new Color(0xC8C8C8));
            }
            case WARNING: {
                return new JBColor(Color.gray, new Color(6381393));
            }
        }
        return new JBColor(Color.gray, new Color(2120704));
    }
}

