/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class CaptionIcon
implements Icon {
    private final Component mySomeComponent;
    private final Form myForm;
    private final boolean myWithContinuation;
    private final boolean myEmphasize;
    private final Color myBgrnd;
    private Font myFont;
    private final String myText;
    private int myHeight;
    private int myWidth;
    private Font myPlusFont;
    private int myAddWidth;

    public CaptionIcon(Color bgrnd, Font font, String text, Component someComponent, Form form, boolean withContionuation, boolean emphasize) {
        this.myBgrnd = bgrnd;
        this.myFont = font;
        this.myText = text;
        this.mySomeComponent = someComponent;
        this.myForm = form;
        this.myWithContinuation = withContionuation;
        this.myEmphasize = emphasize;
        this.fontBasedCalculations();
    }

    private void fontBasedCalculations() {
        FontMetrics fm = this.mySomeComponent.getFontMetrics(this.myFont);
        Rectangle2D bounds = fm.getStringBounds(this.myText, this.mySomeComponent.getGraphics());
        double height = bounds.getHeight() - (double)fm.getMaxDescent();
        this.myPlusFont = this.myFont.deriveFont(1);
        this.myAddWidth = this.myWithContinuation ? this.mySomeComponent.getFontMetrics(this.myPlusFont).stringWidth(" +") : 0;
        this.myHeight = (int)height + 4;
        this.myWidth = (int)bounds.getWidth() + 4 + this.myAddWidth;
    }

    public void setFont(Font font) {
        this.myFont = font;
        this.fontBasedCalculations();
    }

    @Override
    public int getIconHeight() {
        return this.myHeight;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        ((Graphics2D)g).setPaint(this.myBgrnd);
        this.myForm.draw(c, (Graphics2D)g, this.myWidth, this.myHeight, x, y, this.myWithContinuation, this.myEmphasize);
        g.setFont(this.myFont);
        g.setColor(UIUtil.getTextAreaForeground());
        g.drawString(this.myText, x + 4, y + this.myHeight - 3);
        g.setColor(this.myBgrnd.darker().darker());
        g.setFont(this.myPlusFont);
        if (this.myWithContinuation) {
            g.drawString(" +", x + this.myWidth - 2 - this.myAddWidth, y + this.myHeight - 3);
        }
        config.restore();
    }

    @Override
    public int getIconWidth() {
        return this.myWidth + 4;
    }

    public static enum Form {
        SQUARE{

            @Override
            public void draw(Component c, Graphics2D g, int width, int height, int x, int y, boolean withPlus, boolean emphasize) {
                g.fillRect(x + 2, y, width, height);
                g.setColor((Color)new JBColor(Color.gray, Color.gray.darker()));
                g.drawRect(x + 2, y, width, height - 1);
            }
        }
        ,
        ROUNDED{

            @Override
            public void draw(Component c, Graphics2D g, int width, int height, int x, int y, boolean withPlus, boolean emphasize) {
                g.fillRoundRect(x + 2, y, width, height, 5, 5);
                BasicStroke stroke = new BasicStroke(1.0f);
                g.setColor((Color)new JBColor(Color.gray, Color.gray.darker()));
                g.setStroke(stroke);
                g.drawRoundRect(x + 2, y, width, height - 1, 5, 5);
            }
        };


        public abstract void draw(Component var1, Graphics2D var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);
    }
}

