/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretModelImpl
implements CaretModel,
PrioritizedDocumentListener,
Disposable {
    private final EditorImpl myEditor;
    private final EventDispatcher<CaretListener> myCaretListeners = EventDispatcher.create(CaretListener.class);
    private TextAttributes myTextAttributes;
    boolean myIsInUpdate;
    boolean isDocumentChanged;
    private final LinkedList<CaretImpl> myCarets = new LinkedList();
    private CaretImpl myCurrentCaret;
    private boolean myPerformCaretMergingAfterCurrentOperation;

    public CaretModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myCarets.add(new CaretImpl(this.myEditor));
    }

    void onBulkDocumentUpdateStarted() {
        for (CaretImpl caret : this.myCarets) {
            caret.onBulkDocumentUpdateStarted();
        }
    }

    void onBulkDocumentUpdateFinished() {
        this.doWithCaretMerging(new Runnable(){

            @Override
            public void run() {
                for (CaretImpl caret : CaretModelImpl.this.myCarets) {
                    caret.onBulkDocumentUpdateFinished();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentChanged(final DocumentEvent e) {
        this.isDocumentChanged = true;
        try {
            this.myIsInUpdate = false;
            this.doWithCaretMerging(new Runnable(){

                @Override
                public void run() {
                    for (CaretImpl caret : CaretModelImpl.this.myCarets) {
                        caret.updateCaretPosition((DocumentEventImpl)e);
                    }
                }
            });
        }
        finally {
            this.isDocumentChanged = false;
        }
    }

    public void beforeDocumentChange(DocumentEvent e) {
        this.myIsInUpdate = true;
    }

    @Override
    public int getPriority() {
        return 120;
    }

    public void dispose() {
        for (CaretImpl caret : this.myCarets) {
            Disposer.dispose((Disposable)caret);
        }
    }

    public void updateVisualPosition() {
        for (CaretImpl caret : this.myCarets) {
            caret.updateVisualPosition();
        }
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.getCurrentCaret().moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretModelImpl", "moveToLogicalPosition"));
        }
        this.getCurrentCaret().moveToLogicalPosition(pos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretModelImpl", "moveToVisualPosition"));
        }
        this.getCurrentCaret().moveToVisualPosition(pos);
    }

    public void moveToOffset(int offset) {
        this.getCurrentCaret().moveToOffset(offset);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCurrentCaret().moveToOffset(offset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.getCurrentCaret().isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.getCurrentCaret().getLogicalPosition();
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getLogicalPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.getCurrentCaret().getVisualPosition();
        if (visualPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getVisualPosition"));
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.getCurrentCaret().getOffset();
    }

    public int getVisualLineStart() {
        return this.getCurrentCaret().getVisualLineStart();
    }

    public int getVisualLineEnd() {
        return this.getCurrentCaret().getVisualLineEnd();
    }

    int getWordAtCaretStart() {
        return this.getCurrentCaret().getWordAtCaretStart();
    }

    int getWordAtCaretEnd() {
        return this.getCurrentCaret().getWordAtCaretEnd();
    }

    public void addCaretListener(@NotNull CaretListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/CaretModelImpl", "addCaretListener"));
        }
        this.myCaretListeners.addListener((EventListener)listener);
    }

    public void removeCaretListener(@NotNull CaretListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/CaretModelImpl", "removeCaretListener"));
        }
        this.myCaretListeners.removeListener((EventListener)listener);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            this.myTextAttributes = new TextAttributes();
            if (this.myEditor.getSettings().isCaretRowShown()) {
                this.myTextAttributes.setBackgroundColor(this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
            }
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    public boolean supportsMultipleCarets() {
        return true;
    }

    @NotNull
    public CaretImpl getCurrentCaret() {
        CaretImpl currentCaret = this.myCurrentCaret;
        CaretImpl caretImpl = ApplicationManager.getApplication().isDispatchThread() && currentCaret != null ? currentCaret : this.getPrimaryCaret();
        if (caretImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getCurrentCaret"));
        }
        return caretImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CaretImpl getPrimaryCaret() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        // MONITORENTER : linkedList
        CaretImpl caretImpl = this.myCarets.get(this.myCarets.size() - 1);
        // MONITOREXIT : linkedList
        if (caretImpl != null) return caretImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getPrimaryCaret"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretCount() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            return this.myCarets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Caret> getAllCarets() {
        ArrayList<Caret> carets;
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            carets = new ArrayList<Caret>(this.myCarets);
        }
        Collections.sort(carets, CaretPositionComparator.INSTANCE);
        ArrayList<Caret> arrayList = carets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getAllCarets"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretModelImpl", "getCaretAt"));
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            for (CaretImpl caret : this.myCarets) {
                if (!caret.getVisualPosition().equals((Object)pos)) continue;
                return caret;
            }
            return null;
        }
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/openapi/editor/impl/CaretModelImpl", "addCaret"));
        }
        EditorImpl.assertIsDispatchThread();
        CaretImpl caret = new CaretImpl(this.myEditor);
        caret.moveToVisualPosition(pos, false);
        if (this.addCaret(caret)) {
            return caret;
        }
        Disposer.dispose((Disposable)caret);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCaret(@NotNull CaretImpl caretToAdd) {
        if (caretToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretToAdd", "com/intellij/openapi/editor/impl/CaretModelImpl", "addCaret"));
        }
        for (CaretImpl caret : this.myCarets) {
            if (!CaretModelImpl.caretsOverlap(caret, caretToAdd)) continue;
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            this.myCarets.add(caretToAdd);
        }
        this.fireCaretAdded(caretToAdd);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/impl/CaretModelImpl", "removeCaret"));
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myCarets.size() <= 1 || !(caret instanceof CaretImpl)) {
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (!this.myCarets.remove(caret)) {
                return false;
            }
        }
        this.fireCaretRemoved(caret);
        Disposer.dispose((Disposable)caret);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecondaryCarets() {
        EditorImpl.assertIsDispatchThread();
        ListIterator<CaretImpl> caretIterator = this.myCarets.listIterator(this.myCarets.size() - 1);
        while (caretIterator.hasPrevious()) {
            CaretImpl caret = caretIterator.previous();
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                caretIterator.remove();
            }
            this.fireCaretRemoved(caret);
            Disposer.dispose((Disposable)caret);
        }
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/editor/impl/CaretModelImpl", "runForEachCaret"));
        }
        this.runForEachCaret(action, false);
    }

    public void runForEachCaret(final @NotNull CaretAction action, final boolean reverseOrder) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/editor/impl/CaretModelImpl", "runForEachCaret"));
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myCurrentCaret != null) {
            throw new IllegalStateException("Current caret is defined, cannot operate on other ones");
        }
        this.doWithCaretMerging(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<Caret> sortedCarets = CaretModelImpl.this.getAllCarets();
                    if (reverseOrder) {
                        Collections.reverse(sortedCarets);
                    }
                    for (Caret caret : sortedCarets) {
                        CaretModelImpl.this.myCurrentCaret = (CaretImpl)caret;
                        action.perform(caret);
                    }
                }
                finally {
                    CaretModelImpl.this.myCurrentCaret = null;
                }
            }
        });
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/editor/impl/CaretModelImpl", "runBatchCaretOperation"));
        }
        EditorImpl.assertIsDispatchThread();
        this.doWithCaretMerging(runnable);
    }

    private void mergeOverlappingCaretsAndSelections() {
        if (this.myCarets.size() <= 1) {
            return;
        }
        LinkedList<CaretImpl> carets = new LinkedList<CaretImpl>(this.myCarets);
        Collections.sort(carets, CaretPositionComparator.INSTANCE);
        ListIterator it = carets.listIterator();
        while (it.hasNext()) {
            CaretImpl toRemove;
            CaretImpl toRetain;
            CaretImpl prevCaret = null;
            if (it.hasPrevious()) {
                prevCaret = (CaretImpl)((Object)it.previous());
                it.next();
            }
            CaretImpl currCaret = (CaretImpl)((Object)it.next());
            if (prevCaret == null || !CaretModelImpl.caretsOverlap(currCaret, prevCaret)) continue;
            int newSelectionStart = Math.min(currCaret.getSelectionStart(), prevCaret.getSelectionStart());
            int newSelectionEnd = Math.max(currCaret.getSelectionEnd(), prevCaret.getSelectionEnd());
            if (currCaret.getOffset() >= prevCaret.getSelectionStart() && currCaret.getOffset() <= prevCaret.getSelectionEnd()) {
                toRetain = prevCaret;
                toRemove = currCaret;
                it.remove();
                it.previous();
            } else {
                toRetain = currCaret;
                toRemove = prevCaret;
                it.previous();
                it.previous();
                it.remove();
            }
            this.removeCaret(toRemove);
            if (newSelectionStart >= newSelectionEnd) continue;
            toRetain.setSelection(newSelectionStart, newSelectionEnd);
        }
    }

    private static boolean caretsOverlap(@NotNull CaretImpl firstCaret, @NotNull CaretImpl secondCaret) {
        if (firstCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstCaret", "com/intellij/openapi/editor/impl/CaretModelImpl", "caretsOverlap"));
        }
        if (secondCaret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondCaret", "com/intellij/openapi/editor/impl/CaretModelImpl", "caretsOverlap"));
        }
        if (firstCaret.getVisualPosition().equals((Object)secondCaret.getVisualPosition())) {
            return true;
        }
        int firstStart = firstCaret.getSelectionStart();
        int secondStart = secondCaret.getSelectionStart();
        int firstEnd = firstCaret.getSelectionEnd();
        int secondEnd = secondCaret.getSelectionEnd();
        return firstStart < secondStart && firstEnd > secondStart || firstStart > secondStart && firstStart < secondEnd || firstStart == secondStart && secondEnd != secondStart && firstEnd > firstStart || (CaretModelImpl.hasPureVirtualSelection(firstCaret) || CaretModelImpl.hasPureVirtualSelection(secondCaret)) && (firstStart == secondStart || firstEnd == secondEnd);
    }

    private static boolean hasPureVirtualSelection(CaretImpl firstCaret) {
        return firstCaret.getSelectionStart() == firstCaret.getSelectionEnd() && firstCaret.hasVirtualSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWithCaretMerging(Runnable runnable) {
        if (this.myPerformCaretMergingAfterCurrentOperation) {
            runnable.run();
        } else {
            this.myPerformCaretMergingAfterCurrentOperation = true;
            try {
                runnable.run();
                this.mergeOverlappingCaretsAndSelections();
            }
            finally {
                this.myPerformCaretMergingAfterCurrentOperation = false;
            }
        }
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates) {
        if (caretStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretStates", "com/intellij/openapi/editor/impl/CaretModelImpl", "setCaretsAndSelections"));
        }
        this.setCaretsAndSelections(caretStates, true);
    }

    public void setCaretsAndSelections(final @NotNull List<CaretState> caretStates, final boolean updateSystemSelection) {
        if (caretStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretStates", "com/intellij/openapi/editor/impl/CaretModelImpl", "setCaretsAndSelections"));
        }
        EditorImpl.assertIsDispatchThread();
        if (caretStates.isEmpty()) {
            throw new IllegalArgumentException("At least one caret should exist");
        }
        this.doWithCaretMerging(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CaretImpl caret;
                int index = 0;
                int oldCaretCount = CaretModelImpl.this.myCarets.size();
                Iterator caretIterator = CaretModelImpl.this.myCarets.iterator();
                for (CaretState caretState : caretStates) {
                    boolean caretAdded;
                    if (index++ < oldCaretCount) {
                        caret = (CaretImpl)((Object)caretIterator.next());
                        caretAdded = false;
                    } else {
                        caret = new CaretImpl(CaretModelImpl.this.myEditor);
                        if (caretState != null && caretState.getCaretPosition() != null) {
                            caret.moveToLogicalPosition(caretState.getCaretPosition(), false, null, false);
                        }
                        LinkedList linkedList = CaretModelImpl.this.myCarets;
                        synchronized (linkedList) {
                            CaretModelImpl.this.myCarets.add(caret);
                        }
                        CaretModelImpl.this.fireCaretAdded(caret);
                        caretAdded = true;
                    }
                    if (caretState != null && caretState.getCaretPosition() != null && !caretAdded) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition());
                    }
                    if (caretState == null || caretState.getSelectionStart() == null || caretState.getSelectionEnd() == null) continue;
                    caret.setSelection(CaretModelImpl.this.myEditor.logicalToVisualPosition(caretState.getSelectionStart()), CaretModelImpl.this.myEditor.logicalPositionToOffset(caretState.getSelectionStart()), CaretModelImpl.this.myEditor.logicalToVisualPosition(caretState.getSelectionEnd()), CaretModelImpl.this.myEditor.logicalPositionToOffset(caretState.getSelectionEnd()), updateSystemSelection);
                }
                int caretsToRemove = CaretModelImpl.this.myCarets.size() - caretStates.size();
                for (int i = 0; i < caretsToRemove; ++i) {
                    LinkedList linkedList = CaretModelImpl.this.myCarets;
                    synchronized (linkedList) {
                        caret = (CaretImpl)((Object)CaretModelImpl.this.myCarets.removeLast());
                    }
                    CaretModelImpl.this.fireCaretRemoved(caret);
                    Disposer.dispose((Disposable)caret);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        // MONITORENTER : linkedList
        ArrayList<CaretState> states = new ArrayList<CaretState>(this.myCarets.size());
        Iterator i$ = this.myCarets.iterator();
        while (true) {
            if (!i$.hasNext()) {
                ArrayList<CaretState> arrayList = states;
                // MONITOREXIT : linkedList
                if (arrayList != null) return arrayList;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/CaretModelImpl", "getCaretsAndSelections"));
            }
            CaretImpl caret = (CaretImpl)((Object)i$.next());
            states.add(new CaretState(caret.getLogicalPosition(), this.myEditor.visualToLogicalPosition(caret.getSelectionStartPosition()), this.myEditor.visualToLogicalPosition(caret.getSelectionEndPosition())));
        }
    }

    void fireCaretPositionChanged(CaretEvent caretEvent) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretPositionChanged(caretEvent);
    }

    void fireCaretAdded(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/impl/CaretModelImpl", "fireCaretAdded"));
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretAdded(new CaretEvent((Editor)this.myEditor, caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    void fireCaretRemoved(@NotNull Caret caret) {
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/impl/CaretModelImpl", "fireCaretRemoved"));
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretRemoved(new CaretEvent((Editor)this.myEditor, caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    private static class CaretPositionComparator
    implements Comparator<Caret> {
        private static final CaretPositionComparator INSTANCE = new CaretPositionComparator();

        private CaretPositionComparator() {
        }

        @Override
        public int compare(Caret o1, Caret o2) {
            return VisualPositionComparator.INSTANCE.compare(o1.getVisualPosition(), o2.getVisualPosition());
        }
    }

    private static class VisualPositionComparator
    implements Comparator<VisualPosition> {
        private static final VisualPositionComparator INSTANCE = new VisualPositionComparator();

        private VisualPositionComparator() {
        }

        @Override
        public int compare(VisualPosition o1, VisualPosition o2) {
            if (o1.line != o2.line) {
                return o1.line - o2.line;
            }
            return o1.column - o2.column;
        }
    }
}

